// PortadaView.cpp : implementation of the CPortadaView class
//

#include "stdafx.h"
#include "Portada.h"

#include "PortadaDoc.h"
#include "PortadaView.h"
#include "DlgNoModal.h"
#include "NumVblesInd.h"
#include "AFP.h"
#include "RedNeuronal.h"
#include "math.h"
#include "stdlib.h"
#include "string.h"
#include "fstream.h"
#include "iostream.h"
#include "iomanip.h"
#include "direct.h"

#include "process.h" // Para la llamda a un proceso remoto

#include "matlab.hpp" /// Interfaz para MATLAB CPP Math Library
//Necesito incluir todas las operaciones de MATLAB que importo (En este caso de las Redes Neuronales)
#include "premnmx.hpp" 
#include "minmax.hpp" 

#pragma comment(lib,"libmatpm.lib")
#pragma comment(lib,"libmx.lib")
#pragma comment(lib,"libmatlb.lib")
#pragma comment(lib,"libmat.lib")
#pragma comment(lib,"libmmfile.lib")





#define serie 100000
#define PATHBUFFER MAX_PATH 

////////////////////////////////////////////////////////
const int MAX_IND = 10;
typedef float buffer[MAX_IND+1];
////////////////////////////////////////////////////////
const int MAX_COLUMNAS = 100000;
float dprob[100],numdatos=0.0,datserie;
double intervalo[10]={0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0};
int donde,quien;

typedef struct{
	char cadena[10];
	float prob,prob_sig;
	int vale;
	float sigui[10];
	int orden_sig[10],pos_sig[10];
} TIPO_MARKOV;

typedef TIPO_MARKOV Array[MAX_COLUMNAS];

typedef struct Registro* Puntero; 

struct Registro{
    Array info;
    Puntero sig_fil;
};

typedef struct RegistroLista* Lista;
struct RegistroLista{
    int valor;
    Lista sig;
};

char estado[serie];

float datos[serie];

//////////////////////////////////////////////////////////////////////
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPortadaView

IMPLEMENT_DYNCREATE(CPortadaView, CScrollView)

BEGIN_MESSAGE_MAP(CPortadaView, CScrollView)
	//{{AFX_MSG_MAP(CPortadaView)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_HERRAMIENTAS_CONVERTIR, OnConvertir)
	ON_COMMAND(ID_ANLISISTEMPORAL_AFP, OnAnlisistemporalAfp)
	ON_UPDATE_COMMAND_UI(ID_HERRAMIENTAS_CONVERTIR, OnUpdateHerramientasConvertir)
	ON_UPDATE_COMMAND_UI(ID_ANLISISTEMPORAL_AFP, OnUpdateAnlisistemporalAfp)
	ON_UPDATE_COMMAND_UI(ID_ANLISISMULTIVARIANTE_PERCEPTRN, OnUpdateAnlisismultivariantePerceptrn)
	ON_UPDATE_COMMAND_UI(ID_FILE_PRINT, OnUpdateFilePrint)
	ON_COMMAND(ID_FILE_PRINT, OnFilePrint)
	ON_COMMAND(ID_FILE_MRU_FILE1, OnFileMruFile1)
	ON_COMMAND(ID_FILE_MRU_FILE2, OnFileMruFile2)
	ON_COMMAND(ID_FILE_MRU_FILE3, OnFileMruFile3)
	ON_COMMAND(ID_FILE_MRU_FILE4, OnFileMruFile4)
	ON_COMMAND(ID_ANLISISMULTIVARIANTE_PERCEPTRN, OnRNARetropropaga)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CScrollView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPortadaView construction/destruction

CPortadaView::CPortadaView()
{
	// TODO: add construction code here
	//m_pdcDisplayMemory = new CDC;
	//m_pBitmap = new CBitmap;

}

CPortadaView::~CPortadaView()
{
	//delete	m_pdcDisplayMemory;
	//delete	m_pBitmap;
	delete m_pDlg;

}

BOOL CPortadaView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CScrollView::PreCreateWindow(cs);
	
}

/////////////////////////////////////////////////////////////////////////////
// CPortadaView drawing

void CPortadaView::OnDraw(CDC* pDC)
{
	CPortadaDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here
	CBitmap m_pBitmap;
	CDC m_pdcDisplayMemory;
	m_pBitmap.LoadBitmap(IDB_BITMAP1);
	m_pdcDisplayMemory.CreateCompatibleDC(pDC);
	m_pdcDisplayMemory.SelectObject(&m_pBitmap);
	pDC->SetMapMode(MM_TEXT);
	pDC->BitBlt(40,20,991,616,&m_pdcDisplayMemory,0,0,SRCCOPY);
	//CSize size(54,96);
	//pDC->DPtoLP(&size);
	//pDC->StretchBlt(0,0,size.cx,-size.cy,&m_pdcDisplayMemory,0,0,54,96,SRCCOPY);
}

void CPortadaView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	CSize sizeTotal;
	// TODO: calculate the total size of this view
	sizeTotal.cx = sizeTotal.cy = 100;
	SetScrollSizes(MM_TEXT, sizeTotal);

	m_pDlg= new CDlgNoModal();
	InicializarMRU();

}

/////////////////////////////////////////////////////////////////////////////
// CPortadaView printing

BOOL CPortadaView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	    
	return DoPreparePrinting(pInfo);
}

void CPortadaView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{
	// TODO: add extra initialization before printing
     	

}

void CPortadaView::OnEndPrinting(CDC* pDC, CPrintInfo* pInfo)
{
	// TODO: add cleanup after printing
	    
}

/////////////////////////////////////////////////////////////////////////////
// CPortadaView diagnostics

#ifdef _DEBUG
void CPortadaView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CPortadaView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}

CPortadaDoc* CPortadaView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CPortadaDoc)));
	return (CPortadaDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CPortadaView message handlers

void CPortadaView::OnFileOpen() 
{
	// TODO: Add your command handler code here
	CFileDialog DlgAbrir(true);//llama al constructor
	
	//Definir los pares descripcin|filtro
	DlgAbrir.m_ofn.lpstrFilter = "Ficheros anlisis temporal (*.ts)\0*.ts\0Ficheros anlisis multivariante (*.mul)\0*.mul\0Todos los archivos (*.*)\0*.*\0";

	if (DlgAbrir.DoModal() == IDOK)
	{
		//Visualiza el nombre del fichero en la caja de texto
		CString szNomFichero = DlgAbrir.GetFileName();
		//Abrir el fichero
		CFile MiFichero;
		if (!MiFichero.Open(szNomFichero,CFile::modeRead))
		{
			AfxMessageBox("No se puede abrir el fichero para leer");
			return;
		}
		

		//Leer el texto del fichero
		AfxGetApp()->AddToRecentFileList(szNomFichero);
		char path[_MAX_PATH];
		_fullpath(path,szNomFichero,_MAX_PATH);
		CPortadaView::ActualizarMRU(path);

		//AfxMessageBox(szNomFichero);
		UINT tam = (UINT)(MiFichero.GetLength());
		char *Texto = new char[tam+1];
		MiFichero.Read(Texto,tam);
		Texto[tam] = 0;
	
		m_pDlg->m_texto = Texto;
		m_pDlg->SetWindowPos(NULL,2,75,1020,638,SWP_SHOWWINDOW);
		m_pDlg->ShowWindow(SW_SHOW);
		m_pDlg->SetWindowText(szNomFichero);
		(m_pDlg->GetDlgItem(IDC_EDIT1))->SetWindowText(m_pDlg->m_texto);
		
		
		delete[] Texto;
		MiFichero.Close();
		
		//Paso el foco a la ventana principal
		CWnd *pVentanaPadre = GetParent();
		pVentanaPadre->SetFocus();

	}
}


///////////////////////////////////////////////////////////////////////////////////////

void ordeno_array(buffer& buf, const int vble_ind){
    int i;
    
    for (i=0;i<vble_ind;i++){
        buf[i]=buf[i+1];    
    }
}



void escribir_array_fichero(ofstream& fs,const buffer& buf, const int vble_ind){
    int i;
    
    for (i = 0;i<vble_ind;i++){
        fs.width( 12 );
        fs << setiosflags( ios::fixed );
        fs << buf[i] << "\t";
    } 
    fs.width( 12 );
    fs << setiosflags( ios::fixed );
    fs << buf[i] << endl;

}


void leer_primera_linea_fichero(ifstream& fe,buffer& buf, const int vble_ind, bool& ok){
    int i = 0;
    
    fe >> buf[i];
    while ((!fe.eof()) && (i<vble_ind) && (buf[i] != -1111)&& (buf[i] != -2222)){
        i++;
        fe >> buf[i];  
    } 
    if (i < vble_ind)
    {
     ok = false;
    }
}


void leer_temporal(const CString& fichero, const int vble_ind,CString& nom_sal_mul, bool& ok){
    
    ifstream fe;
    ofstream fs;
    CString nom_sal;
    int num_fich1,num_fich2;
    buffer buf;
        
    ok = true;
    num_fich1 = 0;
    num_fich2 = 0;
    fe.open(fichero,ios::in);
    //nom_sal = "MULTI";
	nom_sal = nom_sal_mul;
    nom_sal += char(num_fich1+48);
    nom_sal += char(num_fich2+48);
    nom_sal += ".MUL";
    fs.open(nom_sal,ios::out);
    
    if ( (fe.fail()) ||(fs.fail())) {
        ok = false;
    } else {
        fs << "Vble Depen";
        for (int i = 1; i <= vble_ind;i++) {
			//Tenemos como mximo 10 vbles independientes por lo que no cotejamos los dems casos
			if (i == 10) {    
				fs << "\tVble Indep10";
			} else {	
				fs << "\tVble Indep" << char(i+48) ;
			}
        } 
        fs << endl;
        leer_primera_linea_fichero(fe,buf,vble_ind,ok);
        if (ok) {
           escribir_array_fichero(fs,buf,vble_ind);
           ordeno_array(buf,vble_ind);
           fe >> buf[vble_ind];
           while((!fe.fail()) && (buf[vble_ind]!= -2222)) {
             if (buf[vble_ind] == -1111) {
                 fs.close();
                 num_fich2++;
                 if (num_fich2 > 9){
                   num_fich1++;
                   num_fich2 = 0;
                 }
                 //nom_sal[5] = char(num_fich1+48);
				 //nom_sal.GetBuffer(5)->char(num_fich1+48);
                 //nom_sal[6] = char(num_fich2+48);
				 //nom_sal.ReleaseBuffer();
				 //nom_sal.GetBuffer(6)->char(num_fich1+48);
				 //nom_sal.ReleaseBuffer();
				//nom_sal = "MULTI";
				nom_sal = nom_sal_mul;
				nom_sal += char(num_fich1+48);
				nom_sal += char(num_fich2+48);
				nom_sal += ".MUL";	
                 fs.open(nom_sal,ios::out);
                 fs << "Vble Depen";
                 for (int i = 1; i <= vble_ind;i++) {
					//Tenemos como mximo 10 vbles independientes por lo que no cotejamos los dems casos
					if (i == 10) {    
						fs << "\tVble Indep10";
					} else {	
						fs << "\tVble Indep" << char(i+48) ;
					}
                 } 
                 fs << endl;
                 leer_primera_linea_fichero(fe,buf,vble_ind,ok);
                 escribir_array_fichero(fs,buf,vble_ind);
                 ordeno_array(buf,vble_ind);
                 fe >> buf[vble_ind];
              } else {
                 escribir_array_fichero(fs,buf,vble_ind);
                 ordeno_array(buf,vble_ind);
                 fe >> buf[vble_ind];
              }     
           }
           if (!fe.eof()) {
              ok = false;
           }
         }  
    }   
    fe.close();
    fs.close();
}   



// Diseado para un Fichero Temporal con varias series temporales
// delimitadas por el nmero -1111 entre cada serie y con el nmero
// -2222 para el Fin de Fichero
// Por defecto los nombres de los ficheros de salida sern MULTI00,MULTI01,...
// Convierte hasta 100 ficheros de salida del MULTI00 al MULTI99

void CPortadaView::OnConvertir() 
{
	// TODO: Add your command handler code here
	CNumVblesInd dlg;
	//dlg.DoModal();
	if (dlg.DoModal() == IDOK)	
	{	
		
		CString szNomFichero;
		m_pDlg->GetWindowText(szNomFichero);
		// AfxMessageBox(szNomFichero);
		// Convierte un Fichero de Series Temporales  en un fichero para
		// anlisis multivariante con un nmero mximo de vlbes independientes 
		
		
		int vble_ind;
		CString nom_sal;
		bool ok;
  
		vble_ind = dlg.m_numvble; 
		nom_sal  = dlg.m_fich_sal_mul;
		
				
		leer_temporal(szNomFichero,vble_ind,nom_sal,ok);
		if (ok)
		{
			MessageBox("Los ficheros se han leido y creado correctamente.","H.A.M.",MB_ICONINFORMATION);
		}
		else
		{
			MessageBox("ERROR al leer-crear fichero.","H.A.M.",MB_ICONSTOP);
		}
		
	}
}
	

/////////////////////////////////////////////////////////////

// Cdigo perteneciente al Autmata Finito Probabilstico



char discretiza(const float val) {
	int i;
	char c;
	
	i=0;
	if ((val > 1.0) || (val < 0.0)) {
       c = '0'; 
    } else {
		while ((val > intervalo[i]) && (i < 10)) {
              ++i;
        }      
		c = i + '0';
		if (i > 9) {
           AfxMessageBox("mayor que diez al discretizar?"); 
           i = 9;
        }
	}
	return c;
}


void Inicializar(const int orden,Lista& l) {
	int i;
	Lista ptr;
	
	ptr = l;
    for (i=0;i<orden;++i) {
        ptr->valor=0;
        ptr = ptr->sig;
    }                 //estados distintos en cada orden del autmata
}



Puntero Devuelve_fila(const Puntero& p,const int pos){
    
    Puntero ptr;
    int cont;
    
    ptr = p;
    cont = 0;
    while (cont < pos){
        ptr = ptr->sig_fil;
        ++cont;
    }
    return ptr;
}

Lista Devuelve_pos(const Lista& l,const int pos){
    
    Lista ptr;
    int cont;
    
    ptr = l;
    cont = 0;
    while (cont < pos){
        ptr = ptr->sig;
        ++cont;
    }
    return ptr;
}



void Calcular_prob(const int primera,const int tam_serie,const int orden,
                    Lista& nvalores,Puntero& p){  /*longitud de las secuencias*/
	
	char cad[20];
	int i,j,ind,iguales,tam;
	Puntero ptr;
	Lista ptr_l;
	
    for(ind=0;ind<orden;++ind){
        ptr_l = Devuelve_pos(nvalores,ind);
	    tam=ind+1;
	    for(i=0;i<tam;++i){ 
            cad[i]=estado[i]; 
        }
	    cad[tam]='\0';
		ptr = Devuelve_fila(p,ind); 		
  	    if(primera) {
		   strcpy(ptr->info[0].cadena,cad); 
           ptr->info[0].prob=1.0;
		   ptr_l->valor=1;
         } else {
		   j=0;
		   do {
		       iguales = strcmp(ptr->info[j].cadena,cad);
	           if(iguales) j++;
           }while((j<ptr_l->valor) && (iguales));
           if(j==ptr_l->valor) {
               strcpy(ptr->info[j].cadena,cad);
               ptr->info[j].prob=1.0;
               ++ptr_l->valor;
           } else {
               ptr->info[j].prob+=1.0;
           }        
	     } //end else (primera)
       
	     for (i=tam;i<tam_serie;++i) {		//tam_serie==serieg
	    	 for (j=0;j<tam-1;++j) {
                 cad[j]=cad[j+1];
			 }
             cad[tam-1]=estado[i];
	         j=0;
		     do {
			    iguales = strcmp(ptr->info[j].cadena,cad);
			    if(iguales) j++;
		     }while((j < ptr_l->valor) && (iguales));
		     if(j==ptr_l->valor) {
			    strcpy(ptr->info[j].cadena,cad);
			    ptr->info[j].prob=1.0;
			    ++ptr_l->valor;
		     } else {
                    ptr->info[j].prob+=1.0;
             }        
         } //end for i =tam

    }//end for ind =0

}// end Calcular_prob


void Selecciona_probables(const float umbral_min,const int orden,
                          const Lista& nvalores,Lista& usados, Puntero& p){
   //selecciona aquellos estados con prob mayor que el umbral definido
	int i,j;
	Puntero ptr;
	Lista ptr_nval;
	Lista ptr_usa;
	
	ptr_usa = Devuelve_pos(usados,0);
    ptr_usa->valor=10;
	ptr = Devuelve_fila(p,0);
	for(i=0;i<10;++i) {
	    ptr->info[i].vale=1;
    }
    for(i=1;i<orden;++i){
        ptr_nval = Devuelve_pos(nvalores,i);
        ptr_usa = Devuelve_pos(usados,i);
	    ptr = Devuelve_fila(p,i);
	    for(j=0; j < ptr_nval->valor; ++j){  	
			if(ptr->info[j].prob > umbral_min) {
				ptr->info[j].vale=1; 
                ++ptr_usa->valor;
            } else {
               ptr->info[j].vale=0;
            }   
		}
	}
}


void Normalizar_prob(const int orden,const Lista& nvalores,Puntero& p){
	
	float numerador,arriba,total_prob;
	char csigui[10][2]={"0","1","2","3","4","5","6","7","8","9"};
	int ll,i,ii,j,usa,pos;
	char cad[20];
	Puntero ptr;
	Puntero ptr2;
	Lista ptr_l;
	Lista ptr2_l;
	
	numerador=0.0; 
    arriba=0.0; 
    usa=0;
    for(ll=0;ll<orden-1;++ll){
        ptr_l = Devuelve_pos(nvalores,ll);
        ptr = Devuelve_fila(p,ll);    
	    for(j=0;j<ptr_l->valor;++j) {
            for(pos=0;pos<10;++pos) {
                ptr->info[j].sigui[pos]=0.0;
            }
        }    
	    for(i=0;i<ptr_l->valor;++i){
	        if(ptr->info[i].vale){
		       for(ii=0;ii<10;++ii){
			       j=0;
			       strcpy(cad,ptr->info[i].cadena);
			       strcat(cad,csigui[ii]);
			       ptr2 = Devuelve_fila(p,ll+1);
			       ptr2_l = Devuelve_pos(nvalores,ll+1);
			       while((j<ptr2_l->valor) && (strcmp(ptr2->info[j].cadena,cad))){
                          ++j;
                   }       
		           if(j<ptr2_l->valor) { 
                      ptr->info[i].sigui[ii]+=ptr2->info[j].prob; 
                   }
		        }//end for ii = 0  
		        total_prob=0.0;
		        for(j=0;j<10;++j){
					total_prob+=ptr->info[i].sigui[j];
                }
		        ptr->info[i].prob_sig=total_prob;  //HAY UNA DIFER ENTRE LAS VECES 
                //QUE APARECE UNA CAD Y LAS VECES QUE TIENE SIGUIENTE, 
                //POR QUE CUANDO ES LA ULTIMA NO TIENE SIGUIENTE
		        for(j=0;j<10;++j) {
		            if (ptr->info[i].prob_sig != 0) {      
		                 ptr->info[i].sigui[j]/=ptr->info[i].prob_sig;
		            } else {
                         ptr->info[i].sigui[j] = 0;
                    }     
	            }
  	        }// end if (p[ll][i].vale)
	    } //end for i = 0
    }//end for ll = 0

}//end Normalizar_prob


void Calcular_siguientes_en_p(const int orden,const Lista& nvalores,Puntero& p){
	int oo, i, sig,sigue,letras,j,ii,mm;
	char une[2]=" ";
	char nueva[20];
	Puntero ptr;
	Puntero ptr2;
	Lista ptr_l;
	Lista ptr2_l;
	
	for(oo=0; oo<orden-1 ; ++oo){
	    ptr_l = Devuelve_pos(nvalores,oo);
        ptr = Devuelve_fila(p,oo);    
		for(i=0; i<ptr_l->valor; ++i){
		  if(ptr->info[i].vale){
			for(sig=0; sig<10; ++sig){
				strcpy(nueva,ptr->info[i].cadena);
				une[0]=sig + '0';
				strcat(nueva,une);
				if(oo==orden-2){
					for(mm=0;mm<orden-1;++mm) {
                        nueva[mm]=nueva[mm+1];
                    }    
					nueva[orden-1]='\0';
				}

				sigue=1; 
                letras=oo+1;  //se empieza buscando en las cadenas de longitud inmediatamente mayor
				if(oo==orden-2) {
                    letras--;
                }    
				while(sigue){
					j=0;
					ptr2 = Devuelve_fila(p,letras);
                    ptr2_l = Devuelve_pos(nvalores,letras);    
					while((j<ptr2_l->valor) && (strcmp(ptr2->info[j].cadena,nueva))){
					    ++j;
					}
					if(j<ptr2_l->valor && ptr2->info[j].vale){    //se encuentra la secuencia actual
						sigue=0;
					} else {  //hay que quitar el primer caracter a nueva
						letras--;
						for(ii=0;ii<=letras;++ii) {
                              nueva[ii]=nueva[ii+1];
                        }      
	                    nueva[letras+1] = '\0';  //se incluye ya el fin de cadena
						if(letras < 0) {
                             AfxMessageBox("no quedan letras....."); 
                             getchar();
                        }
					}
				}// end while (sigue)
				
				ptr->info[i].pos_sig[sig]=j;
				ptr->info[i].orden_sig[sig]=letras;
			}// end for (sig = 0)
		  }// end if (p[oo][i].vale)
		}// end for (i = 0)
	}// end for (oo = 0)

}// end Calcular_siguiente_en_p 


void Escribir_p(CString& szNomFichero,const int orden,const Lista& nvalores,const Lista& usados,Puntero& p){
	
	int l,i,j;
	ofstream fs;
	Puntero ptr;
	Lista ptr_nval;
	Lista ptr_usa;
	
	//CString szNomFichero;
	//szNomFichero = "NuevaSalida3.mk";
	szNomFichero += ".MK";
	fs.open(szNomFichero,ios::out);
	for(l=0;l<orden-1;++l){
	    ptr = Devuelve_fila(p,l);
	    ptr_nval = Devuelve_pos(nvalores,l);
	    ptr_usa = Devuelve_pos(usados,l);
		fs << endl  << endl << "Secuencias distintas " << ptr_nval->valor 
           << " , usadas " << ptr_usa->valor << endl;
		for(i=0;i<ptr_nval->valor;++i){
		  if(ptr->info[i].vale){
			fs << ptr->info[i].cadena << "     " << ptr->info[i].prob << "     " 
               << ptr->info[i].prob_sig << endl;
			for(j=0;j<10;++j) {
                fs << "  " << ptr->info[i].sigui[j] ;
            }    
			fs << endl;
			for(j=0;j<10;++j) {
               fs << "     " << ptr->info[i].orden_sig[j];
			}
            fs << endl;
			for(j=0;j<10;++j) {
                fs << "    " << ptr->info[i].pos_sig[j];
			}
            fs << endl;
		  }
		}
	}
	fs.close();

}


void Discretizar_series(const int tam){
	int i;
	for(i=0;i<tam;++i){
			estado[i]=discretiza(datos[i]);
	}
}




int Leer_series(const CString& NomFichero, int& primera,const int orden,
                Lista& nvalores,Puntero& p){   //Devuelve el nmero de series ledas
	
	ifstream fe;
	int i;
	float valor;
	int numseries;
 	
	
	fe.open(NomFichero,ios::in);
	i = 0;
    numseries = 0;	
    do {
	    do {
           fe >> valor;
           if ((valor != -1111) && (valor!=-2222)) {
                datos[i]=valor; //-1111.0 fin serie  -2222.0 ultima serie
           }
           ++i;    
        } while ((valor != -1111) && (valor != -2222));
        numdatos+=i; 
        numseries++;
        Discretizar_series(i);
        Calcular_prob(primera,i,orden,nvalores,p);//rellena p, sec y prob de cada una y de siguientes
        primera = 0;
        i=0;//Inicializo el contador para la nueva serie
    } while (valor != -2222);
  
    fe.close();
    return numseries;

}



void Crear_Lista(Lista& l,const int orden){
    
    Lista nuevo;
    
    for (int i = 0;i < orden; i++) {
        nuevo = new(RegistroLista);
        nuevo->sig = l;
        l = nuevo;
    }
}


void Crear_Estructura(Puntero& p,const int orden){
    
    Puntero nuevo;
    
    for (int i = 0;i < orden; i++) {
        nuevo = new(Registro);
        nuevo->sig_fil = p;
        p = nuevo;
    }
}






void CPortadaView::OnAnlisistemporalAfp() 
{
	// TODO: Add your command handler code here
	CAFP dlg;
	if (dlg.DoModal() == IDOK)	
	{
	    CString szNomFichero;
		m_pDlg->GetWindowText(szNomFichero);	
		int primera,i;
        Lista nvalores;
		Lista usados;
		Puntero p; 
		int numseries;   
    
		
		//Inicializo la variable
		p = NULL;
		Crear_Lista(nvalores,dlg.m_orden);
		Crear_Lista(usados,dlg.m_orden);
		Inicializar(dlg.m_orden,nvalores);
		Inicializar(dlg.m_orden,usados);
		Crear_Estructura(p,dlg.m_orden);
		primera=1;
		for(i=0;i<100;++i) {
			dprob[i]=0.0;
		}    
   
    
	 /* Para varios ficheros*/
		numseries = Leer_series(szNomFichero,primera,dlg.m_orden,nvalores,p);

    
		if (numseries == 0) { 
			MessageBox("No se ha podido leer fichero ","H.A.M.",MB_ICONSTOP); 
			
		} else {
		 //CONSTRUCCION PFA
			Selecciona_probables(dlg.m_umbral,dlg.m_orden,nvalores,usados,p);
			Normalizar_prob(dlg.m_orden,nvalores,p);
			Calcular_siguientes_en_p(dlg.m_orden,nvalores,p);
			Escribir_p(dlg.m_fich_sal_afp,dlg.m_orden,nvalores,usados,p);
			MessageBox("Los ficheros se han leido y creado correctamente.","H.A.M.",MB_ICONINFORMATION) ;
		}
	
		
	}
}

void CPortadaView::OnUpdateHerramientasConvertir(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	CString szNomFichero;
	
	if (m_pDlg->m_texto != "") {				
	  m_pDlg->GetWindowText(szNomFichero);
	  if (szNomFichero.GetLength() != 0) {
        if (toupper(szNomFichero[szNomFichero.GetLength()-1]) == 'S') {
	        pCmdUI->Enable(TRUE);
		} else {
		   pCmdUI->Enable(FALSE);
		}
      } else {
	    pCmdUI->Enable(FALSE);
	  }
	} else {
	  pCmdUI->Enable(FALSE);
	}	
}

void CPortadaView::OnUpdateAnlisistemporalAfp(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	CString szNomFichero;
	
	if (m_pDlg->m_texto != "") {
	  m_pDlg->GetWindowText(szNomFichero);
	  if (szNomFichero.GetLength() != 0) {
        if (toupper(szNomFichero[szNomFichero.GetLength()-1]) == 'S') {
	        pCmdUI->Enable(TRUE);
		} else {
		   pCmdUI->Enable(FALSE);
		}
      } else {
	    pCmdUI->Enable(FALSE);
	  }
	} else {
	  pCmdUI->Enable(FALSE);
	}	  
}

void CPortadaView::OnUpdateAnlisismultivariantePerceptrn(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	CString szNomFichero;
	
    if (m_pDlg->m_texto != "") {
	  m_pDlg->GetWindowText(szNomFichero);
	  if (szNomFichero.GetLength() != 0) {
        if (toupper(szNomFichero[szNomFichero.GetLength()-1]) == 'L') {
	        pCmdUI->Enable(TRUE);
		} else {
		   pCmdUI->Enable(FALSE);
		}
	  } else {
	    pCmdUI->Enable(FALSE);
	  }
	} else {
	  pCmdUI->Enable(FALSE);
	}	    
}

void CPortadaView::OnUpdateFilePrint(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	CString szNomFichero;
		
	if (m_pDlg->m_texto != "") {
	  m_pDlg->GetWindowText(szNomFichero);
	  if (szNomFichero.GetLength() != 0) {
        pCmdUI->Enable(TRUE);
		
	  } else {
	    pCmdUI->Enable(FALSE);
	  }
	} else {
	  pCmdUI->Enable(FALSE);
	}	  
}

/*
void CPortadaView::OnUpdateFilePrintPreview(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	CString szNomFichero;
	
	if (m_pDlg->m_texto != "") {
	  m_pDlg->GetWindowText(szNomFichero);
	  if (szNomFichero.GetLength() != 0) {
        pCmdUI->Enable(TRUE);
		
	  } else {
	    pCmdUI->Enable(FALSE);
	  }
	} else {
	  pCmdUI->Enable(FALSE);
	}  
	
}
*/

void CPortadaView::OnFilePrint() 
{
	// TODO: Add your command handler code here
	bool bPrintSetupOnly = false;

	//Llamar al constructor
	CPrintDialog DlgImprimir(bPrintSetupOnly,PD_ALLPAGES|PD_USEDEVMODECOPIES|PD_PAGENUMS|
		                     PD_HIDEPRINTTOFILE|PD_NOSELECTION,NULL);

	//Visualizar la caja de dilogo Imprimir
	if (DlgImprimir.DoModal() == IDOK) {

		//Manejador al contexto de dispositivo asociado a la impresora
		HDC hDC = DlgImprimir.GetPrinterDC();
		
		//Asociar un contexto de dispositivo a la impresora
		CDC dc;
		dc.Attach(hDC);
		dc.m_bPrinting = TRUE;

		CString szNomFichero;
		m_pDlg->GetWindowText(szNomFichero);
		
		//Estructura de informacin del documento
		DOCINFO di;
		di.cbSize = sizeof(DOCINFO); //Tamao de la estructura
		di.lpszDocName = szNomFichero; //Nombre del documento
		di.lpszOutput = NULL; //Documento de salida
		
		BOOL bPrintingOK = dc.StartDoc(&di);

		CPrintInfo Info;
		Info.m_rectDraw.SetRect(60,60,dc.GetDeviceCaps(HORZRES),dc.GetDeviceCaps(VERTRES));
		
		OnBeginPrinting(&dc, &Info); 
        
		if (bPrintingOK == -1) {

			MessageBox("No se puede iniciar la impresin.","H.A.M.",MB_ICONWARNING);
			return;
		}
		
		//Imprimir el documento
		for (int cop = 0; cop < DlgImprimir.GetCopies();cop++) {

			if (DlgImprimir.PrintAll()) {
				
				int nTamX = dc.GetDeviceCaps(HORZSIZE) * 10;
				int nTamY = dc.GetDeviceCaps(VERTSIZE) * 10;
				int nResX = dc.GetDeviceCaps(HORZRES);
				int nResY = dc.GetDeviceCaps(VERTRES);

				dc.SetMapMode(MM_ANISOTROPIC);
				dc.SetWindowExt(nTamX,nTamY);
				dc.SetViewportExt(nResX,nResY);
				
				CString pagina = "";
				int numlineas = 0;
				int cont = 0;
				const int MAX_LINEAS = 65;

				while (cont < m_pDlg->m_texto.GetLength()){
					pagina += m_pDlg->m_texto[cont];
					if (m_pDlg->m_texto[cont] == char(10)) {
						numlineas++;
					}
					if (numlineas == MAX_LINEAS) { 
						dc.StartPage();
						//Info.m_nCurPage = 1;
						//dc.DrawText(m_pDlg->m_texto,Info.m_rectDraw ,DT_LEFT|DT_EXPANDTABS );
						dc.DrawText(pagina,Info.m_rectDraw ,DT_LEFT|DT_EXPANDTABS );
						//dc.TextOut(50,50,m_pDlg->m_texto);
						dc.EndPage();
						numlineas = 0;
						pagina = "";
					}
					cont++;

				}
				if (!pagina.IsEmpty()) { 
					dc.StartPage();
					//Info.m_nCurPage = 1;
					//dc.DrawText(m_pDlg->m_texto,Info.m_rectDraw ,DT_LEFT|DT_EXPANDTABS );
					dc.DrawText(pagina,Info.m_rectDraw ,DT_LEFT|DT_EXPANDTABS );
					//dc.TextOut(50,50,m_pDlg->m_texto);
					dc.EndPage();
				}
								
			}
			/*else if (DlgImprimir.PrintSelection()) {
				
			}
			else if (DlgImprimir.PrintRange()) {
				for (int pag = DlgImprimir.GetFromPage();pag <= DlgImprimir.GetToPage(); pag++) {
					dc.StartPage();
					dc.TextOut(50,50,m_pDlg->m_texto);
					dc.EndPage();	
				}	
			}*/
		}		
		
		OnEndPrinting(&dc, &Info);
		dc.EndDoc();
		//Eliminar la memoria asignada a las estructuras
		GlobalFree(DlgImprimir.m_pd.hDevMode);
		GlobalFree(DlgImprimir.m_pd.hDevNames);
		//Eliminar el contexto de dispositivo utilizado
		DeleteDC (hDC);
		

	}
	
}


void CPortadaView::OnFileMruFile1() 
{
	// TODO: Add your command handler code here
	 //Visualiza el nombre del fichero en la caja de texto
		
		//Una manera de obetner el nombre de MRU
		//Al capturar la cadena recoge las direcciones de los ficheros
		//PERO cuando son largas llevan \...\ y no nos sirve esta forma
		/*
		UINT m_IdElementoMenu = LOWORD(GetCurrentMessage()->wParam);
		char Titulo[_MAX_PATH];
		CWnd *pVentanaPadre = GetParent();
		CMenu * pMenu = pVentanaPadre->GetMenu();
		pMenu->GetMenuString(m_IdElementoMenu,Titulo,_MAX_PATH,MF_BYCOMMAND);
		
		CString szNomFichero;
		szNomFichero = Titulo;
		szNomFichero = szNomFichero.Right(szNomFichero.GetLength() - 3);
		//_fullpath(Titulo,szNomFichero,100);
		//AfxMessageBox(Titulo);
		*/
	
	//CString szNomFichero = AfxGetApp()->GetProfileString("Recent File List","File1","");
	//CPortadaView::AbreFicherosMRU(szNomFichero);
	
	CPortadaView::AbreFicherosMRU(MRU[0]);
	
}

void CPortadaView::OnFileMruFile2() 
{
	// TODO: Add your command handler code here
	
	//CString szNomFichero = AfxGetApp()->GetProfileString("Recent File List","File2","");
	//CPortadaView::AbreFicherosMRU(szNomFichero);

	CPortadaView::AbreFicherosMRU(MRU[1]);
}

void CPortadaView::OnFileMruFile3() 
{
	// TODO: Add your command handler code here
	
	//CString szNomFichero = AfxGetApp()->GetProfileString("Recent File List","File3","");
	//CPortadaView::AbreFicherosMRU(szNomFichero);
	
	CPortadaView::AbreFicherosMRU(MRU[2]);
}

void CPortadaView::OnFileMruFile4() 
{
	// TODO: Add your command handler code here
	//CString szNomFichero = AfxGetApp()->GetProfileString("Recent File List","File4","");
	//CPortadaView::AbreFicherosMRU(szNomFichero);
	
	CPortadaView::AbreFicherosMRU(MRU[3]);
}


void CPortadaView::AbreFicherosMRU(const CString szNomFichero)
{
		
		
		//Abrir el fichero
		CFile MiFichero;
		if (!MiFichero.Open(szNomFichero,CFile::modeRead))
		{
			AfxMessageBox("No se puede abrir el fichero para leer");
			return;
		}
		//Leer el texto del fichero
		AfxGetApp()->AddToRecentFileList(szNomFichero);
		char path[_MAX_PATH];
		_fullpath(path,szNomFichero,_MAX_PATH);
		CPortadaView::ActualizarMRU(path);		
		// Actualizo el directorio de trabajo a la direccion correspondiente de este fichero
		CPortadaView::ActualizaPath(path);
		//AfxMessageBox(szNomFichero);
		UINT tam = (UINT)(MiFichero.GetLength());
		char *Texto = new char[tam+1];
		MiFichero.Read(Texto,tam);
		Texto[tam] = 0;
	    
		m_pDlg->m_texto = Texto;
		m_pDlg->SetWindowPos(NULL,2,75,1020,638,SWP_SHOWWINDOW);
		m_pDlg->ShowWindow(SW_SHOW);
		m_pDlg->SetWindowText(szNomFichero);
		(m_pDlg->GetDlgItem(IDC_EDIT1))->SetWindowText(m_pDlg->m_texto);
		
		
		delete[] Texto;
		MiFichero.Close();
		
		//Paso el foco a la ventana principal
		CWnd *pVentanaPadre = GetParent();
		pVentanaPadre->SetFocus();
}

void CPortadaView::InicializarMRU()
{

	//Inicializamos la estrutuctura con  los valores que hay en el Registro de Windows
	MRU[0] = AfxGetApp()->GetProfileString("Recent File List","File1","");
	MRU[1] = AfxGetApp()->GetProfileString("Recent File List","File2","");
	MRU[2] = AfxGetApp()->GetProfileString("Recent File List","File3","");
	MRU[3] = AfxGetApp()->GetProfileString("Recent File List","File4","");
	
}

void CPortadaView::ActualizarMRU(const CString szNomFichero)
{
	CString aux0,aux1,aux2;
	//Actualiza nuestra estructura auxiliar MRU en la que tenemos los nombres completos de los archivos
	if (MRU[0] != szNomFichero) {
		aux0   = MRU [0];
		MRU[0] = szNomFichero;
		if (MRU[1] == szNomFichero) {
			MRU[1] = aux0;
		} else {
			aux1 = MRU[1];
			MRU[1] = aux0;
			if (MRU[2] == szNomFichero) {
				MRU[2] = aux1;
			} else {
				aux2 = MRU[2];
				MRU[2] = aux1;
				MRU[3] = aux2; 

			}
		
		}
		
	}
	
}

void CPortadaView::OnRNARetropropaga() 
{
	// TODO: Add your command handler code here
	CRedNeuronal dlg;
	// Obtengo el nombre del Fichero y lo pongo por defecto
	CString var_nom_fich;
	m_pDlg->GetWindowText(var_nom_fich);
	// Quito la ruta por si la tuviera en el nombre
	int cont = LongitudRuta(var_nom_fich);
	var_nom_fich = var_nom_fich.Right(var_nom_fich.GetLength() - 1 - cont);
	// Eliminamos la extensin .MUL (que son los 4 ltimos caracteres)
	dlg.m_nombre_red = var_nom_fich.Left(var_nom_fich.GetLength() - 4);
	// Pulso el botn de entrenamiento	
	if  (dlg.DoModal() == IDOK) {
		//Obtengo el nmero de variables, es decir, el nmero de columnas del fichero actual
		int columnas = CPortadaView::CalculaColumnasFichero();
								
		//Quito la primera fila del fichero actual 
		CString datos;
		datos = m_pDlg->m_texto;
		int cont = 0;
		while (datos.GetAt(cont) != '\n') {
			cont++;
		}
		
		// Leo el resto de los datos para el entrenamiento
		mwArray data,data2,f;
		mwArray cadena(datos.Right(datos.GetLength() - cont));
		f = "%f";
		data = sscanf(cadena,f);
		int M,N;
		// He usado size y no length porque ste me devolva un mwArray y no hace el cast
		M = size(&N,data);
		// Necesito que filas sea de tipo int para poderlo usar en el bucle FOR
		int filas = M / columnas;
		data2 = empty();
		for (int I=1;I<=columnas;I++){
			cont = 0;
			for (int J=1;J<=filas;J++){
				data2 = vertcat(data2,data(I+cont));
				cont = cont + columnas;
			}
		}
		data = reshape(data2,filas,columnas);
		mwArray Out,Inp;
		// Columna de la variable Dependiente
		Out = data(colon(),1);
		// Resto de columnas de las variables Independientes
		Inp = data(colon(),colon(2,columnas));
		
		mwArray PEntrena,TEntrena;
		PEntrena = transpose(Inp); //Entradas
		TEntrena = transpose(Out); //Salida 
		
		// Normalizamos los datos
		mwArray pn,minp,maxp,tn,mint,maxt;
		pn = premnmx(&minp,&maxp,&tn,&mint,&maxt,PEntrena,TEntrena);

		//Creamos la red
		//mwArray red;
		mwArray s,tf,combo;
		//mwArray btf("trainlm");
		switch	(dlg.m_Num_Capas) { //Elige el nemro de capas ocultas de la red
			case 0 : {	//Una capa oculta
						s = horzcat(dlg.m_neuronas_capa1,1);
						// En Modal desaparece la ventana y no pudeo obtener el handler 
						// para recuperar los valores de la ComboBox

						//CString trans_1,trans_sal;
						//dlg.m_fun_transf_combo1.GetLBText(dlg.m_fun_transf_combo1.GetCurSel(),trans_1);
						//dlg.m_fun_transf_combo4.GetLBText(dlg.m_fun_transf_combo4.GetCurSel(),trans_sal);
						
						// La solucin es con una variable miembro de la clase CRedNeuronal
						// cuando pulso el botn IDOK realizo el mtodo OnOk 
						// que almacena en esta variable el contenido del ComboBox
						mwArray tf_1(dlg.funtrans_uno);
						mwArray tf_sal(dlg.funtrans_sal);
						tf = cellhcat(tf_1,tf_sal);
						combo = horzcat(ComboElegido(dlg.funtrans_uno),
										ComboElegido(dlg.funtrans_sal));
						// Actualmente no se pude importar estas libreras 
						// Tampoco con el Matla 7 y el Matlab Compiler 4.4
						//red = newff(minmax(pn),s,tf,btf); 
						break;
					 }
			case 1 : { //Dos capas ocultas
						s = horzcat(dlg.m_neuronas_capa1,dlg.m_neuronas_capa2,1);
						mwArray tf_1(dlg.funtrans_uno);
						mwArray tf_2(dlg.funtrans_dos);
						mwArray tf_sal(dlg.funtrans_sal);
						tf = cellhcat(tf_1,tf_2,tf_sal);
						combo = horzcat(ComboElegido(dlg.funtrans_uno),
										ComboElegido(dlg.funtrans_dos),
										ComboElegido(dlg.funtrans_sal));
						break;
					 }
			
			case 2 : { //Tres capas ocultas
						s = horzcat(dlg.m_neuronas_capa1,dlg.m_neuronas_capa2,dlg.m_neuronas_capa3,1);
						mwArray tf_1(dlg.funtrans_uno);
						mwArray tf_2(dlg.funtrans_dos);
						mwArray tf_3(dlg.funtrans_tres);
						mwArray tf_sal(dlg.funtrans_sal);
						tf = cellhcat(tf_1,tf_2,tf_3,tf_sal);
						combo = horzcat(ComboElegido(dlg.funtrans_uno),
										ComboElegido(dlg.funtrans_dos),
										ComboElegido(dlg.funtrans_tres),
										ComboElegido(dlg.funtrans_sal));
						break;
					 }
			
			}	
		
		
		
		// Le aado al nombre elegido la extensin .MAT y la ruta donde guardaremos el fichero
		CString nombre_red;
		nombre_red = dlg.m_nombre_red + ".MAT";

		// Guardo en un fichero de configuracin desde donde leer MATLAB para recuperar
		// el nombre del fichero.MAT que vamos a entrenar
		mwArray Config("C:/HAM/MATLAB/confifich.MAT");
		// Lo guardo con la ruta completa para poderlo recuperar desde MATLAB
		CString szNomFichero;
		m_pDlg->GetWindowText(szNomFichero);
		char path[_MAX_PATH];
		_fullpath(path,szNomFichero,_MAX_PATH);
		// Calculo la longitud de la ruta y le quitamos el nombre completo del fichero
		szNomFichero = path;
		cont = LongitudRuta(szNomFichero);
		// Ponemos cont + 1 para que contemple la ltima barra de la ruta
		mwArray Nombre(szNomFichero.Left(cont+1) + nombre_red);
		save(Config,"NombreRed",Nombre);
		
		//Guardo el nombre del fichero en B 
		mwArray B(nombre_red);
		
		//Guardo en dicho fichero toda la informacin de la red (en el directorio actual de trabajo)
		mwArray config_red = horzcat(dlg.m_entrena_porcen,dlg.m_valida_porcen,dlg.m_num_iter,
							dlg.m_epocas,dlg.m_frecuencia,dlg.m_objetivo,dlg.m_tasa_aprendizaje,
							dlg.m_tasa_aprendizaje_max,dlg.m_tasa_aprendizaje_inc,
							dlg.m_tasa_aprendizaje_dec,dlg.m_gradiente);
		
		save(B,"FicheroRed",B,"data",data,"TEntrena",TEntrena,"PEntrena",PEntrena,"tipo_red",
			dlg.m_BotonOpcion,"CapasOcultas",dlg.m_Num_Capas + 1,"pn",pn,"tn",tn,"mint",mint,
			"maxt",maxt,"minp",minp,"maxp",maxp,"s",s,"tf",tf,"config_red",config_red,"Combo",combo);
		
		
		// Cambio el direcotrio de MATLAB 
		_chdir("C://HAM//MATLAB//");
		// Hago una llamada a Matlab en las distintas versiones
		char prog[80];
		strcpy(prog,"C:/matlabR12/bin/win32/matlab");
		if (_spawnlp(_P_NOWAIT,prog," ",NULL ) == -1){
			strcpy(prog,"C:/matlabR13/bin/win32/matlab");
			if (_spawnlp(_P_NOWAIT,prog," ",NULL ) == -1){
				strcpy(prog,"C:/MATLAB7/bin/win32/matlab");
				if (_spawnlp(_P_NOWAIT,prog," ",NULL ) == -1){
					MessageBox("No se puede iniciar MATLAB.Consulte el Manual.","H.A.M.",MB_ICONWARNING);		
				}
			}
		}
		// Recupero la ruta de trabajo actual
		m_pDlg->GetWindowText(var_nom_fich);
		CPortadaView::ActualizaPath(var_nom_fich);

	}
	
}

void CPortadaView::ActualizaPath(const char path[])
{
		CString directorio = path;
		int cont = LongitudRuta(directorio);
		directorio = directorio.Left(cont);
		LPCTSTR viejo,nuevo;
		viejo = "\\";
		nuevo = "\\\\";
		directorio.Replace(viejo,nuevo);
		_chdir(directorio);
}

int CPortadaView::CalculaColumnasFichero()
{
	CString datos;
	datos = m_pDlg->m_texto;
	int cont = 0;
	while (datos.GetAt(cont) != '\n') {
		cont++;
	}
	// En esta posicin tenmos el numero de la ltima varialbe independiente
	// Pero puede ser que llegue a 10 por lo que hay que testear el anterior
	char recojo[2];
	recojo[0] = datos.GetAt(cont-2);
	int num_columnas = atoi(&recojo[0]) + 1; //Hay que tener en cuenta la vble dependiente
	recojo[1] = datos.GetAt(cont-3);
	//Slo puede ser el uno u otro caracter(ya que el mximo es 10)
	if (recojo[1] == char(49)){ // char(49) es el nmero 1 en ascii
		num_columnas = num_columnas + 10;
	}
	return num_columnas;
}

int CPortadaView::LongitudRuta(CString ruta)
{
	int cont = ruta.GetLength() - 1;
	while ((cont >= 0)  && (ruta[cont] != char(92))) { //char(92) corresponde a \ en ASCII
			cont--;

	}
	return cont;
}

int CPortadaView::ComboElegido(const CString nombre_transf)
{
	int resul;
	
	if (nombre_transf.Compare("logsig") == 0) {
		resul = 0;
	} else if (nombre_transf.Compare("purelin") == 0){
		resul = 1;
	} else {
		resul = 2;
	}
	return resul;
}
