ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	Purpose: Driver routine to compute solar irradiance on clear sky
c     Date written: 31.01.2007
c     Last revision:
c	Author: Viorel Badescu
c		Candida Oancea Institute, Polytechnic University of Bucharest
c         Email address: badescu@theta.termo.pub.ro
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	subroutine g_clear(nluna,nzi,ora,pres,temp,u,cosz,dsen,gsen)
c
c	Driver routine which computes the solar irradiance 
c     on a horizontal surface, at ground level, on clear sky
c
c	INPUT
c	nluna - number of the month within the year
c	nzi - number of the day within the month
c	ora - hour
c	pres - air pressure at ground level (Pa)
c	temp - air temperature at ground level (K)
c	u - air relative humidity at ground level
c         (dimensionless; between 0 and 1)
c
c	OUTPUT
c	cosz - the cosine of the solar zenith angle)
c     dsen - diffuse solar irradiance on clear sky (W/m2)
c     gsen - global solar irradiance on clear sky (W/m2)
c	
c
	COMMON/locality/alat,along,alt
c
        call gradrad(alat,elat)
        call gradrad(along,elong)
c
        call zidinan(nluna,nzi,nabs)
        call ddelta(nabs,delta)
        call eet2(nabs,et)
        call ie(nabs,g0)
c
        call oraom(elong,ora,et,omega)
        call ccosz(elat,delta,omega,cosz)
        call psatv(temp,ps)
        call tst(temp,alt,tst0)
        call ppst(temp,tst0,pst)
        call wwleck(temp,u,w)
        call emkast(cosz,emst)
        call eem(pres,pst,emst,em)
        call valt0(em,tt0)
        call valtr(em,ttr)
        call valta(em,tta)
        call valaw(em,w,aaw)
c               if(em.le.0.)em=1.e-6
        call valg(em,gg)
        call vali0(g0,tt0,ttr,aaw,tta,vi0)
        call valdr(g0,tt0,ttr,vdr)
        call valda(g0,tt0,ttr,aaw,tta,gg,vda)
c
	  gsen=vi0+vdr+vda
        dsen=vdr+vda
c
	return
	end