ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	Purpose: Collection of routines needed to compute solar irradiance
c     Date written: 31.01.2007
c     Last revision:
c	Author: Viorel Badescu
c		Candida Oancea Institute, Polytechnic University of Bucharest
c         Email address: badescu@theta.termo.pub.ro
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine valaw(em,w,aaw)
c
c     Computes the atmospheric absorptance due to precipable water
c
c     INPUT
c     em - air mass (dimensionless)
c     w - thickness of water precipitable layer (mm)
c
c     OUTPUT
c     aaw - atmospheric absorptance due to precipable water
c           (dimensionless)
c
	  x2=em*w
	  f1=0.29*x2
	  f2=(1.+14.15*x2)**0.635
	  f3=0.5925*x2
	  aaw=f1/(f2+f3)
	  return
	  end
c----------------------------------------------------------------------
      subroutine valda(g0,tt0,ttr,aaw,tta,gg,vda)
c
c     Computes diffuse solar irradiance on a horizontal surface,
c     due to aerosols
c
c     INPUT
c     g0 - intensity of solar radiation ouside atmosphere (W/m2)
c     tt0,ttr,tta - transmittances due to, respectively:
c		ozon layer,
c		Rayleigh scattering
c		aerosols 
c     aaw - absorptance due to precipitable water	(dimensionless)
c     gg - ratio of forward to total scattering by aerosols
c
c     OUTPUT
c     vda - diffuse solar irradiance due to aerosols (W/m2)
c
	  omega=0.75
	  vda=g0*(tt0*ttr-aaw)*(1.-tta)*omega*gg
	  return
	  end
c----------------------------------------------------------------------
      subroutine valdr(g0,tt0,ttr,vdr)
c
c     Computes diffuse solar irradiance on a horizontal surface,
c     due to Rayleigh scattering
c
c     INPUT
c     g0 - intensity of solar radiation ouside atmosphere (W/m2)
c     tt0,ttr - transmittances due to, respectively:
c		ozon layer,
c		Rayleigh scattering
c
c     OUTPUT
c     vdr - diffuse solar irradiance due to Rayleigh scattering (W/m2)
c
        vdr=g0*tt0*(1.-ttr)/2.
	  return
	  end
c----------------------------------------------------------------------
      subroutine valg(em,gg)
c
c     Computes the ratio of forward to total scattering by aerosols
c
c     INPUT
c     em - air mass (dimensionless)
c
c     IESIRI
c     gg - ratio of forward to total scattering by aerosols
c
        gg=0.93-0.21*alog(em)
	  return
	  end
c----------------------------------------------------------------------
      subroutine vali0(g0,tt0,ttr,aaw,tta,vi0)
c
c     Computes solar direct irradiance on clear sky, 
c     on a horizontal surface
c
c     INPUT
c     g0 - intensity of solar radiation ouside atmosphere (W/m2)
c     tt0,ttr,tta - transmittances due to, respectively:
c		ozon layer,
c		Rayleigh scattering
c		aerosols 
c     aaw - absorptance due to precipitable water	(dimensionless)
c
c     OUTPUT
c     vi0 - solar direct irradiance on clear sky (W/m2)
c
	  vi0=g0*(tt0*ttr-aaw)*tta
	  return
	  end
c----------------------------------------------------------------------
      subroutine valt0(em,tt0)
c
c	Computes the atmospheric transmittance due to ozone
c
c     INPUT
c     em - air mass
c
c     OUTPUT
c     tt0 - atmospheric transmittance due to ozone
c
	  u0=3.5
	  x1=em*u0
	  f1=0.1082*x1/(1.+13.86*x1**0.805)
	  f2=0.00658*x1/(1.+(10.36*x1)**3.)
	  f3=0.00218/(1.+0.0042*x1+0.00000323*x1*x1)
	  a0=f1+f2+f3
	  tt0=1.-a0
	  return
	  end
c----------------------------------------------------------------------
      subroutine valta(em,tta)
c
c     Computes the atmospheric transmittance due to aerosols
c
c     INPUT
c     em -air mass
c
c     OUTPUT
c     tta - atmospheric transmittance due to aerosols
c
	  ek=0.9
	  tta=ek**em
	  return
	  end
c----------------------------------------------------------------------
      subroutine valtr(em,ttr)
c
c     Computes the atmospheric transmittance due to Rayleigh scattering
c
c     INPUT
c     em - air mass
c
c     IESIRI
c     ttr - atmospheric transmittance due to Rayleigh scattering
c
	  logical spline
	  dimension am(17),atr(17),d(17),wk(34)
	  real xval(1),fval(1),dval(1)
        data am/0.5,1.,1.2,1.4,1.6,1.8,2.,2.5,3.,3.5,4.,4.5,5.,
     *5.5,6.,10.,30./
	  data atr/0.9385,0.8973,.883,.8696,.8572,.8455,.8344,.8094,
     *.7872,.7673,.7493,.7328,.7177,.7037,.6907,.6108,.4364/
	  lwk=2*n
	  spline=.false.
	  n=17
	  call pchez(n,am,atr,d,spline,wk,lwk,ierr)
	  nval=1
	  xval(1)=em
	  call pchev(n,am,atr,d,nval,xval,fval,dval,ierr)
          ttr=fval(1)
c	  if(em.gt.30.)em=25.
c	  write(*,*)em
c	  dy=1.e-3
c	  call ratint(am,atr,17,em,ttr,dy)
c	  a=-1.*(0.0279286*alog(em)-0.806955)
c	  x=8.688237*em*a
c	  ttr=x/(1.+x)
	  return
	  end
c----------------------------------------------------------------------