function B_cs=B_clear_ESRA(julian_day,z,gamma,TLAM2)
% Funcion para calcular la Irradiancia directa para cielo claro segun el modelo del ESRA
% Extraido del Heliosat 2
%
% INPUT:
%       julian_day: dia juliano
%       z       : elevacion del terreno (m)
%       gamma   : elevacion solar (rad)
%       TLAM2   : indice de turbiedad de Linke para masa de aire 2
%
% OUTPUT:
%       B_cs    : Irradiancia directa (W/m2)
%
% sintaxis:  B_cs=B_clear_ESRA(z,epsilon,TLAM2)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% J. Polo, 2004
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
I0=1367.0; % solar constant


% angulo de dia
[day_angle,ier]=Day_Angle(julian_day);
% Calculo la correcion por excentricidad
[epsilon,ier]=corr_distance(day_angle);

% masa optica relativa del aire y al nivel del mar
[m,ier]=air_mass_Kasten(gamma,z);
[ms1,ier]=air_mass_Kasten(gamma,0.0);

% correcion por altura
[height_corr,ier]=station_height_correction(z);

% espesor optico Rayleigh
[deltaR,ier]=deltaR_Page(ms1,m,height_corr);

if ((TLAM2 <= 1.0) | (m <= 0.0))
    B_cs=0.0;
else
    B_cs=I0*epsilon*exp(-0.8662*TLAM2*m*deltaR);
end
