function [Bc,ier]=Bc_model5_direct(epsilon,m,deltaR,TLAM2)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                       HELIOSAT-2 METHOD
%
%  Estimation of beam irradiance for a clear sky model
%
%  [Bc,ier]=Bc_model5_direct(epsilon,m,deltaR,TLAM2)
%
%  INPUT: 
%           epsilon     : eccentricity correction
%           m           : relative air optical mass
%           deltaR      : Rayleigh optical thickness
%           TLAM2       : Linke turbidity factor for air mass 2
%
%  OUTPUT:
%           Bc          : Beam irradiance for a clear sky (W/m2)
%           ier         : control FLAG : FLAG=0 OK, otherwise error ocurred
%
%  CALLS:
%           none
%__________________________________________________________________________________________________
% 
% Luis F. Zarzalejo, Jesus Polo and Lourdes Ramirez
% CIEMAT (Renewable Energy Department) 2004
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ier=0;
I0=1367.0; % solar constant
if((TLAM2 <= 1.0) | (m <= 0.0))
    Bc=0.0;
else
    beam_trans=exp(-0.8662*TLAM2*m*deltaR);
    Bc=I0*epsilon*beam_trans;
end
