function [Dc,ier]=Dc_model5_irradiance(z,gammasun,epsilon,TLAM2)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                       HELIOSAT-2 METHOD
%
%  Estimation of diffuse irradiance for a clear sky model
%
%  [Dc,ier]=Dc_model5_irradiance(z,gammasun,epsilon,TLAM2)
%
%  INPUT: 
%           z           : elevation of pixel (i.j) above sea level (m)
%           gammasun    : sun elevation angle (radians)
%           epsilon     : eccentricity correction
%           TLAM2       : Linke turbidity factor for air mass 2
%
%  OUTPUT:
%           Dc          : Diffuse irradiance for a clear sky (W/m2)
%           ier         : control FLAG : FLAG=0 OK, otherwise error ocurred
%
%  CALLS:
%           station_height_correction
%           Diff_trans
%           Diff_ang_func
%__________________________________________________________________________________________________
% 
% Luis F. Zarzalejo, Jesus Polo and Lourdes Ramirez
% CIEMAT (Renewable Energy Department) 2004
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


ier=1;
I0=1367.0; % solar constant

if( (TLAM2 < 1.0) | (gammasun < -(pi/12)) )
    ier=0;
    Dc=0.0;
else
    ier=0;
    sing=sin(gammasun);
    % diffuse transmittance at zenith Trd
    [height_corr,ier]=station_height_correction(z); % correction of height
    TLAM2_corr=TLAM2*height_corr;
    Trd=Diff_trans(TLAM2_corr);
    Fd=Diff_ang_func(TLAM2_corr,gammasun,Trd); % Diffuse angular function
    Dc=I0*epsilon*Trd*Fd;
    if(Dc < 0.0) Dc=0.0; end
end
