function Trd=Diff_trans(TLAM2_corr)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                       HELIOSAT-2 METHOD
%
%  Estimation of diffuse transmittance for a clear sky 
%
%  Trd=Diff_trans(TLAM2_corr)
%
%  INPUT: 
%        TLAM2_corr   : Linke turbidity factor corrected by pressure
%  OUTPUT:
%        Trd          : clear-sky diffuse transmittance at zenith
%  CALLS: 
%        none
%___________________________________________________________________________________________________
% 
% Luis F. Zarzalejo, Jesus Polo and Lourdes Ramirez
% CIEMAT (Renewable Energy Department) 2004
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Trd=-1.5843e-2+3.0543e-2*TLAM2_corr+3.797e-4*TLAM2_corr^2;