function [G0h,ier]=G0_hour(phi,eccentricity,delta,t)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
%
% Esta funcion calcula la irradiacion solar extraterrestre incidente en una superficie
% horizontal para una hora especifica en un dia dado (W h/ m2).
% |omega1-omega2|=pi/12. t esta tomado a la mitad de la hora para computar el valor
% horario de la irradiacion solar extraterrestre
% El FLAG ier devuelve 0 si OK y 1 en caso contrario
%
% [G0h,ier]=G0_hour(phi,eccentricity,delta,t)
%
% INPUT: 
%       phi         : latitude del sitio (radianes, norte positivo)
%       eccentricity: correcion de la excentricidad por la orbita terrestre
%       delta       : angulo de declinacion solar (radianes)
%       t           : tiempo solar, LAT (0..24 horas decimales)
% OUTPUT:
%       G0h         : irradiacion solar extraterrestre horaria ( W h / m2)
%       ier         : FLAG de control
%-------------------------------------------------------------------------------
ier=1;
I0=1367.0; % Constante solar en W/m2
Dl=24.0;   % valor promedio de la duracion del dia en horas decimales

[omega_sr,omega_ss,ier]=sunrise_hour_angle(phi,delta,0.0);
if (ier ~= 0) return; end
a=I0*eccentricity*Dl/(2.0*pi); 
b1=sin(phi)*sin(delta);
b2=cos(phi)*cos(delta);

t1=t-1.0;
[omega1,ier]=solar_hour_angle(t1);
if (ier ~= 0) return; end
t2=t;
[omega2,ier]=solar_hour_angle(t2);
if (ier ~= 0) return; end

if (omega1 < omega_sr) omega1=omega_sr; end
if (omega2 > omega_ss) omega2=omega_ss; end

if (omega2 <= omega1)
    G0h=0.0;
else
    G0h=a*(b1*(omega2-omega1)+b2*(sin(omega2)-sin(omega1)));
    if(G0h<0.0) G0h=0.0; end
end
        
        
        