function [G0,ier]=G0_normal(I0j,theta)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
%
% Esta funcion calcula la irradiancia solar extraterrestre normal para el dia j
%
% El FLAG ier devuelve 0 si OK y 1 en caso contrario
%
% [G0,ier]=G0_normal(I0j,theta)
%
% INPUT: 
%       I0j          : irradiancia extraterrestre normal al haz para el dia j (I0j=I0*fj)
%       theta        : angulo cenital
% OUTPUT:
%       G0           : irradiacion global extratterrestre (W h / m2)
%       ier          : FLAG de control
%-------------------------------------------------------------------------------
G0=I0j*cos(theta);
ier=0;