function [alpha,ier]=azimuth_sun(phi,delta,omega,gamma)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
%
% Esta funcion calcula el angulo azimutal en el hemisferio norte.
% El angulo tiene valor positivo cuando el sol esta al oeste del sur, es decir durante la tarde
% 
%
% El FLAG ier devuelve 0 si OK y 1 en caso contrario
%
% [alpha,ier]=azimuth_sun(phi,delta,omega,gamma)
%
% INPUT: 
%       phi         : latitude del sitio (radianes, norte positivo)
%       delta       : angulo de declinacion solar (radianes)
%       omega       : angulo horario solar
%       gamma       : angulo de elevacion solar (radianes)
% OUTPUT:
%       alpha       : angulo azimutal (radianes)
%       ier         : FLAG de control
%-------------------------------------------------------------------------------
ier=0;

cos_as=(sin(phi)*sin(gamma)-sin(delta))/(cos(phi)*cos(gamma));
if ( phi < 0.0 ) cos_as=-cos_as; end % Hemisferio sur
sin_as=cos(delta)*sin(omega)/cos(gamma);
x=acos(cos_as);
if(abs(x) > pi) ier=1; end
if ( sin_as >= 0.0)
    alpha=x;
else
    alpha=-x;
end
