function [deltaR,ier]=deltaR_Page(ms1,m,height_corr)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                       HELIOSAT-2 METHOD
%
%  Determination of the Rayleigh optical thickness
% Ref: Page J., 2001. modified Rigollier et al. 2000 for pressure correction
%
%  [deltaR,ier]=deltaR_Page(ms1,m,height_corr)
%
%  INPUT: 
%       m            : relative optical air mass
%       ms1          : relative optical air mass at sea level
%       height_corr  : p/p0 pressure correction
% OUTPUT:
%       deltaR       : Rayleigh integral optical thickness per unit mass
%       ier          : control FLAG : FLAG=0 OK, otherwise error ocurred
%
%  CALLS:
%       presscorr
%__________________________________________________________________________________________________
% 
% Luis F. Zarzalejo, Jesus Polo and Lourdes Ramirez
% CIEMAT (Renewable Energy Department) 2004
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ier=0;
a=6.625928; b=1.92969; c=-0.170073; d=0.011517; e=-0.000285;
if(ms1<=0.0)
    deltaR=0.0;
else
    if(ms1<=20)
        m2=ms1*ms1;
        m3=m2*ms1;
        m4=m3*ms1;
        [press_corr,ier]=presscorr(height_corr,ms1);
        deltaR=(1.0/(a+b*ms1+c*m2+d*m3+e*m4))/press_corr;
    else
        %  Page (1996) m=20, gamma=3 deg
        deltaR=1.0/(10.4+0.718*m);
    end
end




