function [gamma,theta,ier]=elevation_zenith_sun(phi,delta,omega)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
%
% Esta funcion calcula la elevacion solar (o altitud) y el angulo cenital.
% Ambas variables son copmplementarias
%
% El FLAG ier devuelve 0 si OK y 1 en caso contrario
%
% [gamma,theta,ier]=elevation_zenith_sun(phi,delta,omega)
%
% INPUT: 
%       phi         : latitude del sitio (radianes, norte positivo)
%       delta       : angulo de declinacion solar (radianes)
%       omega       : angulo horario solar
% OUTPUT:
%       gamma       : angulo de elevacion solar (radianes)
%       theta       : angulo cenital (radianes)
%       ier         : FLAG de control
%-------------------------------------------------------------------------------
ier=1;
[omega_sr,omega_ss,ier]=sunrise_hour_angle(phi,delta,0.0);
if (ier ~= 0) return; end

if ( (omega < omega_sr) | (omega > omega_ss) )
    gamma=0.0;
else
    gamma=asin(sin(phi)*sin(delta)+cos(phi)*cos(delta)*cos(omega));
end
if(gamma < 0.0) gamma=0.0; end
theta=(pi/2.0)-gamma;