function [omega,ier]=solar_hour_angle(t)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
%
% Calcula el angulo horario solar en radianes
%
% El FLAG ier devuelve 0 si OK y 1 en caso contrario
%
% [omega,ier]=solar_hour_angle(t)
%
% INPUT: 
%       t       : tiempo solar, es decir LAT (0..24 horas decimales)  
%      
% OUTPUT:
%       omega   : angulo horario solar (radianes)
%       ier     : FLAG de control 
%
%-------------------------------------------------------------------------------
ier=1;
if ( (t >= 0.0) & (t <= 24.0) )
    ier=0;
    omega=(t-12.0)*pi/12.0;
end