function [day_angle_y,delta_y,omega_ss_y,S0_y,eccentricity_y,G0d_y,G0h_y,ier]=...
         yearly_averages(month_number,year_start,year_end,phi,lambda,gamma_riset)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
%
% Esta funcion calcula directamente el promedio anual de varios parametros solares:
% el angulo diario (rad), la excentricidad, la declinacion (rad), el angulo horario de salida
% del sol (rad), la duracion del dia (horas decimales), irradiacion diaria extraterrestre (Wh/m2)
% y los 24 valores de irradiacion horaria extraterrestre (Wh/m2)
% El FLAG ier devuelve 0 si OK y 1 en caso contrario
%
% [day_angle_y,delta_y,omega_ss_y,S0_y,eccentricity_y,G0d_y,G0h_y,ier]=...
%         yearly_averages(month_number,year_start,year_end,phi,lambda,gamma_riset)
%
% INPUT: 
%       month_number        : numero del mes
%       year_start          : el ao en el que comienza el periodo considerado (4 digitos)
%       year_end            : el ao en el que finaliza el periodo considerado (4 digitos)
%       phi                 : latitud del lugar (rad, positivo al norte)
%       lambda              : longitud del lugar (rqad, positivo al este)
%       gamma_riset         : elevacion solar cerca de la salida/puesta del sol
%                               -  0.0 para salida/puesta astronomica
%                               - -1.0 para salida/puesta corregida por refraccion
% OUTPUT:
%       day_angle_y         : promedio anual del angulo de dia (rad)
%       delta_y             : promedio anual de la declinacion solar (rad)
%       omega_ss_y          : promedio anual del angulo horario de puesta (rad)
%       S0_y                : promedio anual de la duracion del dia (horas decimales)
%       eccentricity_y      : promedio anual de la excentricidad
%       G0d_y               : promedio anual de la irradiacion extraterrestre diaria (Wh/m2)
%       G0h_y               : promedio anual de los 24 valores de la irradiacion extraterrestre horaria (Wh/m2)
%       ier                 : FLAG de control
%-------------------------------------------------------------------------------   

number_of_years=year_end-year_start+1;
ier=1;

%inicializo
for i=1:24
    G0h_y(i,1)=0.0;
end

for year_number=year_start:year_end
   
    k=year_number-year_start+1;
    
    [day_angle_m(k,1),delta_m(k,1),omega_ss_m(k,1),S0_m(k,1)...
    ,eccentricity_m(k,1),G0d_m(k,1),G0h_m,ier]=...
         monthly_averages(month_number,year_number,phi,lambda,gamma_riset);
     
    
    if (ier ~= 0) break; end
    for i=1:24
        G0h_y(i,1)=G0h_y(i,1)+G0h_m(i,1);
    end
    %sprintf('year_number = %4d G0d_m = %8.2f (Wh/m2) G0d_y = %8.2f (Wh/m2)\n',year_number,G0d_m(:,:),G0d_y(:,:))
    %for i=1:24
    %    sprintf('hh = %2d (hours)\tG0h_m = %8.2f (Wh/m2)\G0h_y = %8.2f (Wh/m2)\n',i,G0h_m(i,1),G0h_y(i,1))
    %end
    k=k+1;
end 

day_angle_y=mean(day_angle_m);
delta_y=mean(delta_m);
omega_ss_y=mean(omega_ss_m);
S0_y=mean(S0_m);
eccentricity_y=mean(eccentricity_m);
G0d_y=mean(G0d_m);
for i=1:24
    G0h_y(i,1)=G0h_y(i,1)/number_of_years;
end