%Create a neural network to calculate the Global Solar radiation
%using sunshine duration as input
%------------------------------------------------------------
%Daily calculations
%------------------------------------------------------------
%Initializing the environment
clear;

%Import data into Matlabs workspace. 
load ('cyprusdaily.mat') ;

%Plot all the available data for the month
figure(1);
Hold;
plot(Diffuse, '-'); 
plot(Global, ':');
plot(PAR_dif,'--');
plot(PAR_tot, '-.');
title ('Input data');
xlabel('Days (May 2003)');
ylabel('Jm(-2)/hour');
legend ('Diffuse','Global','PAR_dif','PAR_tot');

Continue=input ('Output 1 : Visualize input data \nSee figure "1" - Hit Enter to continue \n');

%Preprocessing of the data (normalization)
[xn,xmin,xmax,yn,ymin,ymax]=premnmx(Sunshine,Global);

%Create the network
net=newff([-1 1],[10 1],{'tansig' 'purelin'});

%Initialize network 
net=init(net);


%Simulate the network without training to show the initial response to the input data
Simulation=sim(net,xn');

hold off
figure(2);
plot(xn,yn,'o',xn,Simulation,'+');
title ('Untrained Network Response');
legend('Measured PAR','Simulated PAR');

Continue=input ('Output 2 : Untrained Network Response \nSee figure "2" - Hit Enter to continue \n');

%Set the most important training parameters 
net.trainParam.epochs=400;
net.trainParam.goal=.0046;

%Training the network
net=train(net,xn',yn');
anorm=sim(net,xn'); 

Continue=input ('Output 3 : The network is trained \nSee figure "Training with TRAINLM" - Hit Enter to continue \n');

%Postprocessing of the data
a=postmnmx(anorm,ymin,ymax);

%Plot the output
figure (4);
plot (Sunshine,Global,'d',Sunshine,a,'p');
title ('Network Response');
legend('input data','network output');
Continue=input ('Output 4 : Network Response \nSee figure "4" - Hit Enter to continue \n');

%creating training, testing and validationdataset
Test=2:4:28;
Val=4:4:28;
Train=[1:4:28 3:4:28];

xn=xn';
yn=yn';

val.P=xn(:,Val);
val.T=yn(:,Val);
test.P=xn(:,Test);
test.T=yn(:,Test);
xtrain_normalized=xn(:,Train);
ytrain_norm=yn(:,Train);


%training the network
net=init(net);
[net,tr]=train(net,xtrain_normalized,ytrain_norm,[],[],val,test);
an=sim(net,xtrain_normalized);

Continue=input ('Output 5 : Split the training set to training, testing and validation set \nand use them to train the network \nSee figure "Training with TRAINLM" - Hit Enter to continue \n');

%postprocessing of the data
a=postmnmx(an,ymin,ymax);

%plot the output
figure (6);
Global=Global(Train,:);
Sunshine=Sunshine(Train,:);

plot (Sunshine,Global,'+',Sunshine,a,'o');
title ('Network Response');
legend('input data','network output');

Continue=input ('Output 6 : Network response \nSee figure "6"  - Hit Enter to continue \n');

%Plot Training set, Testing set and Validation set 
figure (7);
plot(tr.epoch,tr.perf,tr.epoch,tr.vperf,tr.epoch,tr.tperf);
legend ('Training','Validation','Test',-1);
ylabel('Performance (Squared Error)');
xlabel('Epoch');
Continue=input ('Output 7 : Networks performance against epochs \nSee figure "7"  - Hit Enter to finish \n');
