function [day_angle,ier]=Day_Angle(julian_day)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
%
% Calcula el angulo del dia en radianes desde las 12:00 horas del 31 de Diciembre.
% Se usa como longitud del ao 365.2422 dias. El FLAG ier devuelve 0 si
% el calculo es correcto y 1 en caso contrario.
%
% [day_angle,ier]=Day_Angle(julian_day)
%
% INPUT: 
%       julian day   : dia juliano (1..366)
% OUTPUT:
%       day_angle    : angulo diario (radianes)
%       ier          : FLAG de control 
%-------------------------------------------------------------------------------
ier=1;
if ( (julian_day > 0) & (julian_day <= 366) )
    ier=0;
    day_angle=julian_day*2.0*pi/365.2422;
end