function Fd=Diff_ang_func(TLAM2_corr,gammasun,Trd)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                       HELIOSAT-2 METHOD
%
%  Estimation of diffuse angular function for a clear sky 
%
%  Fd=Diff_ang_func(TLAM2_corr,gamma,Trd)
%
%  INPUT: 
%       TLAM2_corr   : Linke turbidity factor corrected by pressure
%       gammasun     : sun elevation angle (radians)
%       Trd          : Diffuse transmittance at zenith
%  OUTPUT:
%       Fd           : Diffuse angular function
%  CALLS: 
%        none
%___________________________________________________________________________________________________
% 
% Luis F. Zarzalejo, Jesus Polo and Lourdes Ramirez
% CIEMAT (Renewable Energy Department) 2004
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
a=[2.6463e-1 -6.1581e-2 3.1408e-3; 2.0402 1.8945e-2 -1.1161e-2; -1.3025 3.9231e-2 8.5079e-3];
TLAM2_2=TLAM2_corr*TLAM2_corr;
A0=a(1,1)+a(1,2)*TLAM2_corr+a(1,3)*TLAM2_2;
A1=a(2,1)+a(2,2)*TLAM2_corr+a(2,3)*TLAM2_2;
A2=a(3,1)+a(3,2)*TLAM2_corr+a(3,3)*TLAM2_2;
if((Trd*A0)<2.0e-3)
    A0=2.0e-3/Trd;
end
sing=sin(gammasun);
Fd=A0+A1*sing+A2*sing*sing;
