function [G0d,ier]=G0_day(phi,eccentricity,delta)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
%
% Esta funcion calcula la irradiacion solar extraterrestre diaria incidente 
% sobre una superficie horizontal (omega1=omega_sr=-omega_ss y omega2=omega_ss).
% Es un caso particular de "G0_general" con los angulos de salida y puesta del sol
% como limites de integracion.
% El FLAG ier devuelve 0 si OK y 1 en caso contrario
%
% [G0d,ier]=G0_day(phi,eccentricity,delta)
%
% INPUT: 
%       phi         : latitude del sitio (radianes, norte positivo)
%       eccentricity: correcion de la excentricidad por la orbita terrestre
%       delta       : angulo de declinacion solar (radianes)
% OUTPUT:
%       G0d         : irradiacion solar extraterrestre diaria ( W h / m2)
%       ier         : FLAG de control
%-------------------------------------------------------------------------------
ier=1;
I0=1367.0; % Constante solar en W/m2
Dl=24.0;   % valor promedio de la duracion del dia en horas decimales

[omega_sr,omega_ss,ier]=sunrise_hour_angle(phi,delta,0.0);
if (ier ~= 0) return; end
a=I0*eccentricity*Dl/pi; 
b=sin(phi)*sin(delta)*omega_ss+cos(phi)*cos(delta)*sin(omega_ss);
G0d=a*b;

