function [dt,ier]=LMT_to_LAT(day_angle,lambda,lambda_ref,summer_corr)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
%
% Esta funcion calcula la diferencia (en horas decimales) entre LAT (local apparent time)
% y LMT (local mean time or clock time), en el mediodia solar. Dos etapas:
%  - La primera etapa calcula la ecuacion del tiempo, ET, que permite perturbaciones en la 
%    velocidad rotacional y angular de la tierra
%  - La segunda etapa maneja la diferencia entre la longitud del sitio considerado y la longitud
%    de una zona de tiempo de referencia.
%
% El FLAG ier devuelve 0 si OK y 1 en caso contrario
%
% [dt,ier]=LMT_to_LAT(day_angle,lambda,lambda_ref,summer_corr)
%
% INPUT: 
%       day_angle   : angulo de dia (radian)
%       lambda      : longitud del sitio (radian, este positivo)
%       lambda_ref  : longitud de referencia (radian)
%       summer_corr : correcion para el tiempo de verano (horas enteras)
% OUTPUT:
%       dt          : Offset entre LMT y LAT (horas decimales)
%       ier         : FLAG de control
%-------------------------------------------------------------------------------
deg_rad=pi/180.0; % convierte grados decimales en radian
ier=1;
a1 = -0.128;
a2 = -0.165;
a3 = 2.80*deg_rad;
a4 = 19.70*deg_rad;

if ( (day_angle > 0.0) & (day_angle < (2.0*pi*1.0021)) & (abs(lambda) <= pi) & (abs(lambda_ref) <= pi) )
    ier=0;
    ET=a1*sin(day_angle-a3)+a2*sin(2.0*day_angle+a4);
    dt=ET+((lambda-lambda_ref)*12.0/pi)-summer_corr;
end