function [eccentricity, ier]=corr_distance(day_angle)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
%
% Esta funcion calcula la correcion por la variacion de la distancia sol-tierra.
%
% El FLAG ier devuelve 0 si OK y 1 en caso contrario
%
% [eccentricity, ier]=corr_distance(day_angle)
%
% INPUT: 
%       day_angle    : angulo diario solar (radianes)
% OUTPUT:
%       eccentricity : correcion por la orbita terrestre de la excentricidad
%       ier          : FLAG de control
%-------------------------------------------------------------------------------
deg_rad=pi/180.0; % convierte grados decimales en radianes

ier=1;
a=2.80*deg_rad;
if ( (day_angle >= 0.0) & (day_angle <= (2.0*pi*1.0021))  )
    ier=0;
    eccentricity=1.0+0.03344*cos(day_angle-a);
end
