function [t,ier]=omega_to_LAT(omega)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
%
% Pasa de angulo horario solar a tiempo solar en horas decimales
%
% El FLAG ier devuelve 0 si OK y 1 en caso contrario
%
% [t,ier]=omega_to_LAT(omega)
%
% INPUT: 
%       omega   : angulo horario solar (radianes)
%      
% OUTPUT:
%       t       : tiempo solar, es decir LAT (0..24 horas decimales) 
%       ier     : FLAG de control
%-------------------------------------------------------------------------------
ier=1;
if ( (omega >= -pi) & (omega <= pi)  )
    ier=0;
    t=12.0*(1.0+omega/pi);
end