function [day_angle,delta,omega_ss,S0,eccentricity,G0d,G0h,ier]=...
    solar_parameters_day(day_of_month,month_number,year_number,phi,lambda,gamma_riset)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
%
% Esta funcion calcula los parametros relacionados con la geometria solar para un dia concreto
% El FLAG ier devuelve 0 si OK y 1 en caso contrario
%
% [day_angle,delta,omega_ss,S0,eccentricity,G0d,G0h,ier]=...
%    solar_parameters_day(day_of_month,month_number,year_number,phi,lambda,gamma_riset)
%
% INPUT:
%       day_of_month        : dia del mes (1..31)
%       month_number        : numero del mes (1..12)
%       year_number         : ao (4 digitos)
%       phi                 : latitud del lugar (rad, positivo al norte)
%       lambda              : longitud del lugar (rqad, positivo al este)
%       gamma_riset         : elevacion solar cerca de la salida/puesta del sol
%                               -  0.0 para salida/puesta astronomica
%                               - -1.0 para salida/puesta corregida por refraccion
% OUTPUT:
%       day_angle           : angulo de dia (rad)
%       delta               : declinacion solar (rad)
%       omega_ss            : angulo horario de puesta (rad)
%       S0                  : duracion del dia (horas decimales)
%       eccentricity        : excentricidad
%       G0d                 : irradiacion extraterrestre diaria (Wh/m2)
%       G0h                 : 24 valores de la irradiacion extraterrestre horaria (Wh/m2)
%       ier                 : FLAG de control
%-------------------------------------------------------------------------------   
ier=1;

[julian_day,ier]=make_julian_day(day_of_month,month_number,year_number);

if (ier == 0)  [day_angle,ier]=Day_Angle(julian_day); end
if (ier == 0)  [delta,ier]=declination_sun(year_number,julian_day,lambda); end
if (ier == 0)  [omega_sr,omega_ss,ier]=sunrise_hour_angle(phi,delta,gamma_riset); end
if (ier == 0)  [t_sr,t_ss,S0,ier]=timerise_daylenght(omega_sr,omega_ss); end
if (ier == 0)  [eccentricity, ier]=corr_distance(day_angle); end
if (ier == 0)  [G0d,ier]=G0_day(phi,eccentricity,delta); end
if ( (ier == 0) & (G0d > 0.0) )
    [G0h,ier]=G0_hours_profile(phi,eccentricity,delta);
end

    