function [day_angle_max,delta_max,omega_ss_max,S0_max,eccentricity_max,G0d_max,G0h_max,ier]=...
    solar_parameters_max(month_number,phi,lambda,gamma_riset)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
%
% Esta funcion es la misma que solar_parameters_avg usando type_use=1. Es decir la maxima mensual
% El FLAG ier devuelve 0 si OK y 1 en caso contrario
%
%  [day_angle_max,delta_max,omega_ss_max,S0_max,eccentricity_max,G0d_max,G0h_max,ier]=...
%    solar_parameters_max(month_number,phi,lambda,gamma_riset)
%
% INPUT:
%       month_number        : numero del mes (1..12)
%       phi                 : latitud del lugar (rad, positivo al norte)
%       lambda              : longitud del lugar (rqad, positivo al este)
%       gamma_riset         : elevacion solar cerca de la salida/puesta del sol
%                               -  0.0 para salida/puesta astronomica
%                               - -1.0 para salida/puesta corregida por refraccion
%
% OUTPUT:
% promedio en el mes month_number de:
%       day_angle_max       : angulo de dia (rad)
%       delta_max           : declinacion solar (rad)
%       omega_ss_max        : angulo horario de puesta (rad)
%       S0_max              : duracion del dia (horas decimales)
%       eccentricity_max    : excentricidad
%       G0d_max             : irradiacion extraterrestre diaria (Wh/m2)
%       G0h_max             : 24 valores de la irradiacion extraterrestre horaria (Wh/m2)
%       ier                 : FLAG de control
%-------------------------------------------------------------------------------   

% valores recomendados para el numero de dia para estimar la radiacion solar global maxima mensual
tab_julian_day = [29,57,89,119,150,173,186,217,248,278,309,339];

ier=1;
type_use=1; % Para estimar la radiacion solar global media mensual maxima

julian_day=tab_julian_day(month_number);

[day_angle_max,ier]=Day_Angle(julian_day);
if (ier == 0)  [delta_max,ier]=declination_sun_month(month_number,type_use); end
if (ier == 0)  [omega_sr,omega_ss_max,ier]=sunrise_hour_angle(phi,delta_max,gamma_riset); end
if (ier == 0)  [t_sr,t_ss,S0_max,ier]=timerise_daylenght(omega_sr,omega_ss_max); end
if (ier == 0)  [eccentricity_max, ier]=corr_distance(day_angle_max); end
if (ier == 0)  [G0d_max,ier]=G0_day(phi,eccentricity_max,delta_max); end
if (ier == 0) 
    [G0h_max,ier]=G0_hours_profile(phi,eccentricity_max,delta_max);
end
