function [height_corr,ier]=station_height_correction(z)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                       HELIOSAT-2 METHOD
%
%  Height correction due to the ratio of atmospheric pressure and the pressure at sea level
%
%  [height_corr,ier]=station_height_correction(z)
%
%  INPUT: 
%         z            : height of station above sea level (m)
%  OUTPUT:
%         height_corr  : height correction
%         ier          : control FLAG : FLAG=0 OK, otherwise error ocurred
%  CALLS:
%         none  
%__________________________________________________________________________________________________
% 
% Luis F. Zarzalejo, Jesus Polo and Lourdes Ramirez
% CIEMAT (Renewable Energy Department) 2004
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ier=0;
if(z<4000)
    height_corr=1.0-(z/1.0e4);
else
    height_corr=exp(-(0.1174+(0.0017*z/1.0e3))*z/1.0e3);
end
 
    
    
