function [omega_sr,omega_ss,ier]=sunrise_hour_angle(phi,delta,gamma_riset)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
%
% Esta funcion calcula el angulo horario de salida y puesta del sol en radianes.
% Debido a la dimension del disco solar y al efecto de la refraccion de la atmosfera
% el eje del disco solar puede aparecer (desaparecer) en el horizonte a la salida (puesta)
% cuando la elevacion calculada es de 50'.
%
% El FLAG ier devuelve 0 si OK y 1 en caso contrario
%
% [omega_sr,omega_ss,ier]=sunrise_hour_angle(phi,delta,gamma_riset)
%
% INPUT: 
%       phi         : latitud (radianes) positiva hacia el norte
%       delta       : angulo de declinacion solar (radianes)
%       gamma_riset : elevacion solar cerca de la salida/puesta.
%                        0.0 para salida/puesta astronomica
%                       -1.0 para salida o puesta corregida por refraccion
% OUTPUT:
%       omega_sr    : angulo solar horario de salida del sol (radianes)
%       omega_ss    : angulo solar horario de puesta del sol (radianes)
%       ier     : FLAG de control
%-------------------------------------------------------------------------------
deg_rad=pi/180.0; % convierte grados decimales en radianes
ier=0;

if ( (gamma_riset == 0.0) | (gamma_riset == -1.0) )
    ier=0;
end
horizon=(-50.0/60.0)*deg_rad; % horizonte, -50' en radianes
if (gamma_riset >= horizon) horizon=gamma_riset; end
max_delta=23.45*deg_rad;
    
if ( (abs(phi) < (pi/2.0)) & (abs(delta) <= max_delta) & (ier==0) )
        cos_omegas=(sin(horizon)-(sin(phi)*sin(delta)))/(cos(phi)*cos(delta));
        ier=0;
else
        ier=1; return;
end
if (abs(cos_omegas) < 1.0) omegas=acos(cos_omegas); end
if (cos_omegas >= 1.0) omegas=0.0; end % el sol esta siempre por debajo del horizonte: noche polar
if (cos_omegas <= -1.0) omegas=pi; end % el sol esta siempre por encima del horizonte: dia polar
    
omega_sr=-omegas;
omega_ss=omegas;
