function [t_sr,t_ss,s0,ier]=timerise_daylenght(omega_sr,omega_ss)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
%
% Esta funcion calcula el tiempo astronomico de salida y puestqa del sol y la duracion
% del dia, todo en LAT decimal
%
% El FLAG ier devuelve 0 si OK y 1 en caso contrario
%
% [t_sr,t_ss,s0,ier]=timerise_daylenght(omega_sr,omega_ss)
%
% INPUT: 
%       omega_sr    : angulo solar horario de salida del sol (radianes)
%       omega_ss    : angulo solar horario de puesta del sol (radianes)
% OUTPUT:
%       t_sr        : tiempo astronomico de salida del sol (en horas decimales)
%       t_ss        : tiempo astronomico de puesta del sol (en horas decimales)
%       s0          : duracion astronomica del dia (en horas decimales)
%       ier         : FLAG de control
%-------------------------------------------------------------------------------
ier=1;

if ( (omega_sr >= -pi) & (omega_sr <= 0.0) & (omega_ss >= 0.0) & (omega_ss <= pi) )
    ier=0;
    [t_sr,ier]=omega_to_LAT(omega_sr);
    if (ier == 0) [t_ss,ier]=omega_to_LAT(omega_ss); end
    if (ier ~= 0) return; end
    t_sr=12.0+omega_sr*12.0/pi;
    t_ss=12.0+omega_ss*12.0/pi;
    s0=t_ss-t_sr;
end