// RedNeuronal.cpp : implementation file
//

#include "stdafx.h"
#include "Portada.h"
#include "PortadaDoc.h"
#include "PortadaView.h"
#include "RedNeuronal.h"
#include "stdlib.h"

#include "matlab.hpp" /// Interfaz para MATLAB CPP Math Library

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRedNeuronal dialog


CRedNeuronal::CRedNeuronal(CWnd* pParent /*=NULL*/)
	: CDialog(CRedNeuronal::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRedNeuronal)
	m_BotonOpcion = 0;//Por defecto feedforward
	m_Num_Capas   = 0;//Por defecto una capa oculta
	m_num_iter = 1;
	m_epocas = 100;
	m_frecuencia = 25;
	m_objetivo = 0;
	m_neuronas_capa1 = 10;
	m_neuronas_capa2 = 10;
	m_neuronas_capa3 = 10;
	m_tasa_aprendizaje = 0.001f;
	m_tasa_aprendizaje_dec = 0.1f;
	m_tasa_aprendizaje_inc = 10.f;
	m_tasa_aprendizaje_max = 1.e10f;
	m_gradiente = 1.e-10f;
	m_valida_porcen = 10;
	m_entrena_porcen = 90;
	m_nombre_red = _T("");
	//}}AFX_DATA_INIT
}


void CRedNeuronal::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRedNeuronal)
	DDX_Control(pDX, IDC_COMBO4, m_fun_transf_combo4);
	DDX_Control(pDX, IDC_COMBO3, m_fun_transf_combo3);
	DDX_Control(pDX, IDC_COMBO2, m_fun_transf_combo2);
	DDX_Control(pDX, IDC_COMBO1, m_fun_transf_combo1);
	DDX_Radio(pDX, IDC_RADIO1, m_BotonOpcion);
	DDX_Radio(pDX, IDC_CAPA_UNA, m_Num_Capas);
	DDX_Text(pDX, IDC_NUM_ITER, m_num_iter);
	DDV_MinMaxInt(pDX, m_num_iter, 1, 10);
	DDX_Text(pDX, IDC_EPOCAS, m_epocas);
	DDV_MinMaxInt(pDX, m_epocas, 1, 1000);
	DDX_Text(pDX, IDC_FRECUENCIA, m_frecuencia);
	DDV_MinMaxInt(pDX, m_frecuencia, 1, 1000);
	DDX_Text(pDX, IDC_OBJETIVO, m_objetivo);
	DDV_MinMaxInt(pDX, m_objetivo, 0, 1);
	DDX_Text(pDX, IDC_NEURONAS_CAPA1, m_neuronas_capa1);
	DDV_MinMaxInt(pDX, m_neuronas_capa1, 1, 100);
	DDX_Text(pDX, IDC_NEURONAS_CAPA2, m_neuronas_capa2);
	DDV_MinMaxInt(pDX, m_neuronas_capa2, 1, 100);
	DDX_Text(pDX, IDC_NEURONAS_CAPA3, m_neuronas_capa3);
	DDV_MinMaxInt(pDX, m_neuronas_capa3, 1, 100);
	DDX_Text(pDX, IDC_TASA_APRENDE, m_tasa_aprendizaje);
	DDV_MinMaxFloat(pDX, m_tasa_aprendizaje, 0.f, 1.f);
	DDX_Text(pDX, IDC_TASA_APRENDE_DEC, m_tasa_aprendizaje_dec);
	DDV_MinMaxFloat(pDX, m_tasa_aprendizaje_dec, 0.f, 100.f);
	DDX_Text(pDX, IDC_TASA_APRENDE_INC, m_tasa_aprendizaje_inc);
	DDV_MinMaxFloat(pDX, m_tasa_aprendizaje_inc, 0.f, 100.f);
	DDX_Text(pDX, IDC_TASA_APRENDE_MAX, m_tasa_aprendizaje_max);
	DDV_MinMaxFloat(pDX, m_tasa_aprendizaje_max, 0.f, 1.e+36f);
	DDX_Text(pDX, IDC_GRADIENTE, m_gradiente);
	DDV_MinMaxFloat(pDX, m_gradiente, 1.e-36f, 1.e+36f);
	DDX_Text(pDX, IDC_VALIDA_PORCEN, m_valida_porcen);
	DDV_MinMaxInt(pDX, m_valida_porcen, 0, 100);
	DDX_Text(pDX, IDC_ENTRENA_PORCEN, m_entrena_porcen);
	DDV_MinMaxInt(pDX, m_entrena_porcen, 0, 100);
	DDX_Text(pDX, IDC_NOMBRE_RED, m_nombre_red);
	DDV_MaxChars(pDX, m_nombre_red, 15);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CRedNeuronal, CDialog)
	//{{AFX_MSG_MAP(CRedNeuronal)
	ON_BN_CLICKED(IDC_CAPA_UNA, OnCapaUna)
	ON_BN_CLICKED(IDC_CAPA_DOS, OnCapaDos)
	ON_BN_CLICKED(IDC_CAPA_TRES, OnCapaTres)
	ON_EN_KILLFOCUS(IDC_ENTRENA_PORCEN, OnKillfocusEntrenaPorcen)
	ON_EN_KILLFOCUS(IDC_VALIDA_PORCEN, OnKillfocusValidaPorcen)
	ON_BN_CLICKED(IDC_CARGAR_RED, OnCargarRed)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRedNeuronal message handlers

void CRedNeuronal::OnCapaUna() 
{
	// TODO: Add your control notification handler code here
	// Deshabilito las otras casillas y dejo slo activa la de la CAPA Uno
	GetDlgItem(IDC_NEURONAS_CAPA2)->EnableWindow(false);
	GetDlgItem(IDC_COMBO2)->EnableWindow(false);
	GetDlgItem(IDC_NEURONAS_CAPA3)->EnableWindow(false);
	GetDlgItem(IDC_COMBO3)->EnableWindow(false);
}

void CRedNeuronal::OnCapaDos() 
{
	// TODO: Add your control notification handler code here
	//Habilito la capa Dos y deshabilito la Capa Tres
	GetDlgItem(IDC_NEURONAS_CAPA2)->EnableWindow(true);
	GetDlgItem(IDC_COMBO2)->EnableWindow(true);
	GetDlgItem(IDC_NEURONAS_CAPA3)->EnableWindow(false);
	GetDlgItem(IDC_COMBO3)->EnableWindow(false);
	
}

void CRedNeuronal::OnCapaTres() 
{
	// TODO: Add your control notification handler code here
	// Habilito las tres capas
	GetDlgItem(IDC_NEURONAS_CAPA2)->EnableWindow(true);
	GetDlgItem(IDC_COMBO2)->EnableWindow(true);
	GetDlgItem(IDC_NEURONAS_CAPA3)->EnableWindow(true);
	GetDlgItem(IDC_COMBO3)->EnableWindow(true);
	
}

BOOL CRedNeuronal::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	//Estn ordenados por orden alfabtico
	// 0 -> logsig
	// 1 -> purelin
	// 2 -> tansig
	m_fun_transf_combo1.SetCurSel(2);//tansig por defecto
	m_fun_transf_combo2.SetCurSel(2);//tansig por defecto
	m_fun_transf_combo3.SetCurSel(2);//tansig por defecto
	m_fun_transf_combo4.SetCurSel(1);//purelin por defecto
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}




void CRedNeuronal::OnKillfocusEntrenaPorcen() 
{
	// TODO: Add your control notification handler code here
	UpdateData(true);
	if ((m_entrena_porcen >= 0) && (m_entrena_porcen <= 100)) {
		m_valida_porcen = 100 - m_entrena_porcen;
		UpdateData(false);

	}	
}

void CRedNeuronal::OnKillfocusValidaPorcen() 
{
	// TODO: Add your control notification handler code here
	UpdateData(true);
	if ((m_valida_porcen >= 0) && (m_valida_porcen <= 100)) {
		m_entrena_porcen = 100 - m_valida_porcen;
		UpdateData(false);
	}
}



void CRedNeuronal::OnOK() 
{
	// TODO: Add extra validation here
	m_fun_transf_combo1.GetLBText(m_fun_transf_combo1.GetCurSel(),funtrans_uno);
	m_fun_transf_combo2.GetLBText(m_fun_transf_combo2.GetCurSel(),funtrans_dos);
	m_fun_transf_combo3.GetLBText(m_fun_transf_combo3.GetCurSel(),funtrans_tres);
	m_fun_transf_combo4.GetLBText(m_fun_transf_combo4.GetCurSel(),funtrans_sal);
	
	CDialog::OnOK();
}

void CRedNeuronal::OnCargarRed() 
{
	// TODO: Add your control notification handler code here
	CFileDialog DlgAbrir(true);//llama al constructor
	
	//Definir los pares descripcin|filtro
	DlgAbrir.m_ofn.lpstrFilter = "Ficheros Configuracin Redes (*.MAT)\0*.MAT\0";

	if (DlgAbrir.DoModal() == IDOK)
	{
		// Cargo el nombre del fichero en la caja de texto
		CString szNomFichero = DlgAbrir.GetFileName();
		// Actualizo el valor de todos los valores obtenidos por el fichero .MAT
		mwArray Nombre(szNomFichero);
		mwArray nom,BotonOpcion,Num_Capas,config_red,s,tf,combo;
		load(Nombre,"FicheroRed",&nom,"tipo_red",&BotonOpcion,
		       "CapasOcultas",&Num_Capas,"s",&s,"tf",&tf,"config_red",&config_red,
			   "Combo",&combo);
		UpdateData(true);
		m_BotonOpcion = int(BotonOpcion.ExtractScalar(1));
		m_Num_Capas   = int(Num_Capas.ExtractScalar(1)) - 1;
		if (m_Num_Capas == 1) {
			CRedNeuronal::OnCapaDos();
			m_neuronas_capa1 = int(s.ExtractScalar(1));
			m_neuronas_capa2 = int(s.ExtractScalar(2));
			m_fun_transf_combo1.SetCurSel(int(combo.ExtractScalar(1)));
			m_fun_transf_combo2.SetCurSel(int(combo.ExtractScalar(2)));
			m_fun_transf_combo4.SetCurSel(int(combo.ExtractScalar(3)));

		} else if (m_Num_Capas == 2) {
			CRedNeuronal::OnCapaTres();
			m_neuronas_capa1 = int(s.ExtractScalar(1));
			m_neuronas_capa2 = int(s.ExtractScalar(2));
			m_neuronas_capa3 = int(s.ExtractScalar(3));
			m_fun_transf_combo1.SetCurSel(int(combo.ExtractScalar(1)));
			m_fun_transf_combo2.SetCurSel(int(combo.ExtractScalar(2)));
			m_fun_transf_combo3.SetCurSel(int(combo.ExtractScalar(3)));
			m_fun_transf_combo4.SetCurSel(int(combo.ExtractScalar(4)));
		} else {
			CRedNeuronal::OnCapaUna();
			m_neuronas_capa1 = int(s.ExtractScalar(1));
			m_fun_transf_combo1.SetCurSel(int(combo.ExtractScalar(1)));
			m_fun_transf_combo4.SetCurSel(int(combo.ExtractScalar(2)));
		}
		
			
		CString nom_red;
		nom_red = nom.ToString();
		m_nombre_red = nom_red.Left(nom_red.GetLength() - 4);
		
		m_entrena_porcen       = int(config_red.ExtractScalar(1));
		m_valida_porcen        = int(config_red.ExtractScalar(2));
		m_num_iter             = int(config_red.ExtractScalar(3));
		m_epocas               = int(config_red.ExtractScalar(4));
		m_frecuencia           = int(config_red.ExtractScalar(5));
		m_objetivo             = int(config_red.ExtractScalar(6));
		m_tasa_aprendizaje     = float(config_red.ExtractScalar(7));
		m_tasa_aprendizaje_max = float(config_red.ExtractScalar(8));
		m_tasa_aprendizaje_inc = float(config_red.ExtractScalar(9));
		m_tasa_aprendizaje_dec = float(config_red.ExtractScalar(10));
		m_gradiente            = float(config_red.ExtractScalar(11));
		UpdateData(false);


		
	}
}
