ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	Purpose: Driver routine to compute solar irradiance on cloudy sky
c     Date written: 31.01.2007
c     Last revision:
c	Author: Viorel Badescu
c		Candida Oancea Institute, Polytechnic University of Bucharest
c         Email address: badescu@theta.termo.pub.ro
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	subroutine g_cloudy(pc,cosz,dsen,gsen,nsun,vih,vdh,vgh)
c
c	Driver routine which computes the solar irradiance 
c     on a horizontal surface, at ground level, on cloudy sky
c
c	INPUT
c	pc - total cloud amount (dimensionless; between 0 and 1)
c	cosz - the cosine of the solar zenith angle)
c     dsen - diffuse solar irradiance on clear sky (W/m2)
c     gsen - global solar irradiance on clear sky (W/m2)
c
c	OUTPUT
c	nsun - sunshine number (dimensionless; 0 or 1)
c	vih	- direct solar irradiance on cloudy sky (W/m2)
c	vdh	- diffuse solar irradiance on cloudy sky (W/m2)
c	vgh	- global solar irradiance on cloudy sky (W/m2)
c
c
       if(pc.le.0.)pc=1.e-4
       sigma=1.-0.73*pc-0.27*pc*pc
       sigmalea=ran2(idum)
c
c      Sun covered by clouds
c
       if(sigmalea.le.sigma) goto 98
	nsun=0
       if(pc.ge.0.4) goto 1000
       ad= 0.9227
       bd= 1.4705
       cd= 0.6460
       dd= 1.1668
       goto 1001
1000   if(pc.ge.0.7) goto 1010
       ad=  1.1801
       bd=  1.0045
       cd=  0.5706
       dd=  1.3561
       goto 1001
1010   continue
       ad= 0.3272
       bd= 1.4871
       cd=-0.8051
       dd= 1.5142
1001   continue
       vdh=dsen*(ad+bd*pc**cd)*cosz**dd
       vgh=vdh
       vih=0.
       goto 999
98     continue
c
c      Sun not covered by clouds
c
	nsun=1
       if(pc.ge.0.4) goto 10001
       ag= 0.9609
       bg= 0.0909
       cg= 0.9963
       dg= 0.8943
       ad=    1.1592
       bd=    1.3461
       cd=    2.3561
       dd=    1.3503
       goto 10011
10001   if(pc.ge.0.7) goto 10101
       ag=  0.7803
       bg=  0.2702
       cg=  0.2594
       dg=  0.8583
       ad=    1.1229
       bd=    0.6995
       cd=    1.2216
       dd=    1.4792
       goto 10011
10101   continue
       ag= 0.6372
       bg= 0.3859
       cg= 0.0065
       dg= 0.8142
       ad=     0.8711
       bd=     0.8068
       cd=    -0.0370
       dd=     1.7597
10011   continue
       vgh=gsen*(ag+bg*pc**cg)*cosz**dg
       vdh=dsen*(ad+bd*pc**cd)*cosz**dd
       vih=vgh-vdh
999    continue
c
	return
	end