function [Bc,ier]=Bc_model5_irradiance(gamma,epsilon,m,deltaR,TLAM2)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                       HELIOSAT-2 METHOD
%
%  Estimation of beam irradiance for a clear sky model
%
%  [Bc,ier]=Bc_model5_irradiance(gamma,epsilon,m,deltaR,TLAM2)
%
%  INPUT: 
%           gamma       : elevation angle (radians)
%           epsilon     : eccentricity correction
%           m           : relative air optical mass
%           deltaR      : Rayleigh optical thickness
%           TLAM2       : Linke turbidity factor for air mass 2
%
%  OUTPUT:
%           Bc          : Beam irradiance for a clear sky (W/m2)
%           ier         : control FLAG : FLAG=0 OK, otherwise error ocurred
%
%  CALLS:
%           Bc_model5_direct
%__________________________________________________________________________________________________
% 
% Luis F. Zarzalejo, Jesus Polo and Lourdes Ramirez
% CIEMAT (Renewable Energy Department) 2004
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[Bc,ier]=Bc_model5_direct(epsilon,m,deltaR,TLAM2);
if( (ier==0) & (Bc > 0.0))
    if(gamma > 0.0)
        Bc=Bc*sin(gamma);
    else
        Bc=0.0;
    end
end

