function [m,ier]=air_mass_Kasten(gamma,z)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                       HELIOSAT-2 METHOD
%
%  Estimation of relative air mass based on Kasten parametrization
%
%  [m,ier]=air_mass_Kasten(gamma,z)
%
%  INPUT: 
%       gamma        : elevation angle (radians) (for the sun or for satellite)
%       z            : station elevation above sea level (m)
%  OUTPUT:
%       m           : relative air mass
%       ier         : control FLAG : FLAG=0 OK, otherwise error ocurred
%
%  CALLS:
%       station_height_correction2
%__________________________________________________________________________________________________
% 
% Luis F. Zarzalejo, Jesus Polo and Lourdes Ramirez
% CIEMAT (Renewable Energy Department) 2004
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
deg_rad=pi/180.0;
rad_deg=180.0/pi;
ier=1;
% sun elevation correction for refraction
c1=0.061359;
c2=0.1594;
c3=1.1230;
c4=0.065656;
c5=28.9344;
c6=277.3971;
if(gamma<=0.0)
    m=0.0; return;
else
    gamma_corr=c1*(c2+c3*gamma+c4*gamma*gamma)/(1.+c5*gamma+c6*gamma*gamma);
    gamma=gamma+gamma_corr;
end
gamma_deg=gamma*rad_deg;
a=0.50572;
b=6.07995; %degrees
c=-1.6364;
[height_corr,ier]=station_height_correction2(z);
if( (ier==0) & (gamma>0.0))
    ier=0;
    m=height_corr/(sin(gamma)+a*(gamma_deg+b)^c);
end
    