function [day_of_month,month_number,ier]=julian_to_date(year_number,julian_day)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
%
% Funcion inversa a make_julian_day. Computa el mes y el dia respectivos a un dia
% juliano dado. El flag de control ier devuelve 0 si opera bien y 1 en caso contrario
%
% [day_of_month,month_number,ier]=julian_to_date(year_number,julian_day)
%
% INPUT: 
%       year_number  : ao con cuatro digitos
%       julian_day   : dia juliano
% OUTPUT:
%       day_of_month : dia del mes (1..31)
%       month_number : numero de mes (1..12)
%       ier          : FLAG de control 
%-------------------------------------------------------------------------------
tab=[0,31,59,90,120,151,181,212,243,273,304,334]; % Dia juliano al comienzo de cada mes
jmax=365;

ier=1;
if ( ((mod(year_number,4)==0) & (mod(year_number,100)~=0)) | (mod(year_number,400)==0) ) % Ao bisiesto
    jmax=jmax+1;
    for m=1:12
        if m > 2 
           tab(m)=tab(m)+1; 
        end
    end
end

if ( (julian_day > 0) & (julian_day <= jmax) & (year_number >0) )
    ier=0;
    for m=1:11
        if ( (julian_day > tab(m)) & (julian_day <= tab(m+1)) )
            month_number=m;
            day_of_month=julian_day-tab(m);
            break;
        end
    end
    if (julian_day > tab(12))
                month_number=12;
                day_of_month=julian_day-tab(12);
    end
end