function [julian_day,ier]=make_julian_day(day_of_month,month_number,year_number)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
% Calculo del dia juliano. Convierte un dia dado por dia, mes y ao en el dia
% juliano. ier = 0 si lo hace bien y 1 en caso contrario.
%
% [julian_day,ier]=make_julian_day(day_of_month,month_number,year_number)
%
% INPUT: 
%       day_of_month : dia del mes (1..31)
%       month_number : numero de mes (1..12)
%       year_number  : ao con cuatro digitos
% OUTPUT:
%       julian_day   : dia juliano (1..366)
%       ier          : FLAG de control 
%-------------------------------------------------------------------------------
tab=[0,31,59,90,120,151,181,212,243,273,304,334]; % Dia juliano al comienzo de cada mes
ier=1;
if (day_of_month > 0) & (day_of_month < 32) & (month_number > 0) & (month_number < 13) & (year_number > 0)
    ier=0;
    julian_day=day_of_month + tab(month_number);
    if( ( ((mod(year_number,4)==0) & (mod(year_number,100)~=0)) | (mod(year_number,400)==0) ) & (month_number>2) )
       julian_day=julian_day+1; % En caso de ao bisiesto
    end
end    

