function [number_days_month,ier]=nbdays_month(year_number,month_number)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
%
% Calcula el numero de dias que tiene un mes dado. El FLAG ier devuelve 0 si
% el calculo es correcto y 1 en caso contrario.
%
% [number_days_month,ier]=nbdays_month(year_number,month_number)
%
% INPUT: 
%       year_number  : ao con cuatro digitos
%       month_number : numero de mes (1..12)
% OUTPUT:
%       number_days_month : numero de dias en un mes
%       ier          : FLAG de control 
%-------------------------------------------------------------------------------
tab_nbdays=[31,28,31,30,31,30,31,31,30,31,30,31];
ier=1;
if ( (year_number > 0) & (month_number > 0) & (month_number < 13) )
    ier=0;
    number_days_month=tab_nbdays(month_number);
    if( ( ((mod(year_number,4)==0) & (mod(year_number,100)~=0)) | (mod(year_number,400)==0) ) & (month_number==2) )
       number_days_month=number_days_month+1; % En caso de ao bisiesto
    end
end