function [day_angle_avg,delta_avg,omega_ss_avg,S0_avg,eccentricity_avg,G0d_avg,G0h_avg,ier]=...
    solar_parameters_avg(month_number,phi,lambda,gamma_riset)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
%
% Esta funcion calcula los parametros relacionados con la geometria solar promediados para un mes concreto
% El FLAG ier devuelve 0 si OK y 1 en caso contrario
%
%  [day_angle_avg,delta_avg,omega_ss_avg,S0_avg,eccentricity_avg,G0d_avg,G0h_avg,ier]=...
%    solar_parameters_avg(month_number,phi,lambda,gamma_riset)
%
% INPUT:
%       month_number        : numero del mes (1..12)
%       phi                 : latitud del lugar (rad, positivo al norte)
%       lambda              : longitud del lugar (rqad, positivo al este)
%       gamma_riset         : elevacion solar cerca de la salida/puesta del sol
%                               -  0.0 para salida/puesta astronomica
%                               - -1.0 para salida/puesta corregida por refraccion
%
% OUTPUT:
% promedio en el mes month_number de:
%       day_angle_avg       : angulo de dia (rad)
%       delta_avg           : declinacion solar (rad)
%       omega_ss_avg        : angulo horario de puesta (rad)
%       S0_avg              : duracion del dia (horas decimales)
%       eccentricity_avg    : excentricidad
%       G0d_avg             : irradiacion extraterrestre diaria (Wh/m2)
%       G0h_avg             : 24 valores de la irradiacion extraterrestre horaria (Wh/m2)
%       ier                 : FLAG de control
%-------------------------------------------------------------------------------   

% valores recomendados para el numero de dia para estimar la radiacion solar global mensual
tab_julian_day = [17,46,75,105,135,162,198,228,259,289,319,345];

ier=1;
type_use=0; % Para estimar la radiacion solar global media mensual

julian_day=tab_julian_day(month_number);

[day_angle_avg,ier]=Day_Angle(julian_day);
if (ier == 0)  [delta_avg,ier]=declination_sun_month(month_number,type_use); end
if (ier == 0)  [omega_sr,omega_ss_avg,ier]=sunrise_hour_angle(phi,delta_avg,gamma_riset); end
if (ier == 0)  [t_sr,t_ss,S0_avg,ier]=timerise_daylenght(omega_sr,omega_ss_avg); end
if (ier == 0)  [eccentricity_avg, ier]=corr_distance(day_angle_avg); end
if (ier == 0)  [G0d_avg,ier]=G0_day(phi,eccentricity_avg,delta_avg); end
if (ier == 0) 
    [G0h_avg,ier]=G0_hours_profile(phi,eccentricity_avg,delta_avg);
end
