#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#ifdef WIN32

#include <fox/xincs.h>

#include "fast_dc.h"

fast_dc::fast_dc(FXDrawable* drawable):FXDC(drawable->getApp())
{
  begin(drawable);
}

fast_dc::~fast_dc()
{
  end();
}

FXID fast_dc::pen=0;

void fast_dc::begin(FXDrawable *drawable)
{
  surface=drawable;
  visual=drawable->getVisual();
  ctx=drawable->GetDC();

  if(visual->colormap){oldpalette=SelectPalette((HDC)ctx,(HPALETTE)visual->colormap,FALSE);RealizePalette((HDC)ctx);}

  devfg=~0;

  if(pen==0) pen=CreatePen(PS_SOLID, 0, devfg);

  SelectObject((HDC)ctx,pen);
}

void fast_dc::end()
{
  if(ctx)
  {
    if(visual->colormap){SelectPalette((HDC)ctx,(HPALETTE)oldpalette,FALSE);}
    surface->ReleaseDC((HDC)ctx);
    ctx=NULL;
  }
  surface=NULL;
}

void fast_dc::setForeground(FXColor clr)
{
  devfg=visual->getPixel(clr);

  pen=CreatePen(PS_SOLID, 0, devfg);

  DeleteObject(SelectObject((HDC)ctx,pen));
}

void fast_dc::drawPoint(FXint x,FXint y)
{
  SetPixel((HDC)ctx,x,y,devfg);
}

void fast_dc::drawLine(FXint x1,FXint y1,FXint x2,FXint y2)
{
  MoveToEx((HDC)ctx,x1,y1,0); 
  LineTo(  (HDC)ctx,x2,y2);

    // Windows benutzt lineto/polyline zum linienzeichnen. dort gilt:
    // The pixel located at the starting point is always included in the
    // line, and the pixel located at the ending point is always
    // excluded. (This kind of line is sometimes called inclusive-exclusive.)
  
    // dieser hack hier ist so nur gltig fr linewidth=1
  
  SetPixel((HDC)ctx,x2,y2,devfg);
}

void fast_dc::setClipRectangle(FXint x,FXint y,FXint w,FXint h)
{
  HRGN hrgn=CreateRectRgn(x,y,x+w,y+h);
  SelectClipRgn((HDC)ctx,hrgn);
  DeleteObject(hrgn);
}

#endif // WIN32
