/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.digest;

import com.sun.security.sasl.digest.DigestSecurityCtx;
import com.sun.security.sasl.preview.SaslException;
import com.sun.security.sasl.util.SaslImpl;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class DigestUtils
extends SaslImpl {
    protected static final boolean debug = false;
    private static final String CIPHER_PROPERTY = "com.sun.security.sasl.digest.cipher";
    private static final String NOCHAIN_PROPERTY = "com.sun.security.sasl.digest.nochain";
    private static final boolean nochain = DigestUtils.noChaining();
    private final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    protected DigestSecurityCtx secCtx;
    protected byte[] H_A1;
    protected String encoding = "8859_1";
    protected String cipherSuite;
    protected String specifiedCipher;
    protected static final int DES3 = 0;
    protected static final int RC4 = 1;
    protected static final int DES = 2;
    protected static final int RC4_56 = 3;
    protected static final int RC4_40 = 4;
    protected static final String[] CIPHER_TOKENS = new String[]{"3des", "rc4", "des", "rc4-56", "rc4-40"};
    private static final byte[] PARITY_BIT_MASK = new byte[]{-128, 64, 32, 16, 8, 4, 2};
    private static final BigInteger MASK = new BigInteger("7f", 16);

    private static final boolean noChaining() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty(DigestUtils.NOCHAIN_PROPERTY);
                }
                catch (SecurityException securityException) {
                    return null;
                }
            }
        });
        return "true".equalsIgnoreCase(string);
    }

    DigestUtils(Map map) throws SaslException {
        super(map);
        if (map != null) {
            this.specifiedCipher = (String)map.get(CIPHER_PROPERTY);
        }
    }

    public String getMechanismName() {
        return "DIGEST-MD5";
    }

    public byte[] unwrap(byte[] byArray, int n, int n2) throws SaslException {
        if (!this.completed) {
            throw new SaslException("Not completed");
        }
        return this.secCtx.unwrap(byArray, n, n2);
    }

    public byte[] wrap(byte[] byArray, int n, int n2) throws SaslException {
        if (!this.completed) {
            throw new SaslException("Not completed");
        }
        return this.secCtx.wrap(byArray, n, n2);
    }

    public void dispose() throws SaslException {
        if (this.secCtx != null) {
            this.secCtx = null;
        }
    }

    private static void setParityBit(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            int n = 0;
            for (int j = 0; j < PARITY_BIT_MASK.length; ++j) {
                if ((byArray[i] & PARITY_BIT_MASK[j]) != PARITY_BIT_MASK[j]) continue;
                ++n;
            }
            byArray[i] = n & true ? (byte)(byArray[i] & 0xFFFFFFFE) : (byte)(byArray[i] | 1);
        }
    }

    private static byte[] addDesParity(byte[] byArray, int n, int n2) {
        if (n2 != 7) {
            throw new IllegalArgumentException("Invalid length of DES Key Value:" + n2);
        }
        byte[] byArray2 = new byte[7];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        byte[] byArray3 = new byte[8];
        BigInteger bigInteger = new BigInteger(byArray2);
        int n3 = byArray3.length - 1;
        while (n3 >= 0) {
            byArray3[n3] = bigInteger.and(MASK).toByteArray()[0];
            int n4 = n3--;
            byArray3[n4] = (byte)(byArray3[n4] << 1);
            bigInteger = bigInteger.shiftRight(7);
        }
        DigestUtils.setParityBit(byArray3);
        return byArray3;
    }

    private static SecretKey makeDesKeys(byte[] byArray, String string) throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        byte[] byArray2 = DigestUtils.addDesParity(byArray, 0, 7);
        KeySpec keySpec = null;
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string);
        if (string.equals("des")) {
            keySpec = new DESKeySpec(byArray2, 0);
        } else if (string.equals("desede")) {
            byte[] byArray3 = DigestUtils.addDesParity(byArray, 7, 7);
            byte[] byArray4 = new byte[byArray2.length * 2 + byArray3.length];
            System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
            System.arraycopy(byArray3, 0, byArray4, byArray2.length, byArray3.length);
            System.arraycopy(byArray2, 0, byArray4, byArray2.length + byArray3.length, byArray2.length);
            keySpec = new DESedeKeySpec(byArray4, 0);
        } else {
            throw new IllegalArgumentException("Invalid DES strength:" + string);
        }
        return secretKeyFactory.generateSecret(keySpec);
    }

    final class DigestPrivacy
    extends DigestIntegrity
    implements DigestSecurityCtx {
        private static final String CLIENT_CONF_MAGIC = "Digest H(A1) to client-to-server sealing key magic constant";
        private static final String SVR_CONF_MAGIC = "Digest H(A1) to server-to-client sealing key magic constant";
        private IvParameterSpec IVcc;
        private IvParameterSpec IVcs;
        private int seqNum;
        private Cipher cipherCc;
        private Cipher cipherCs;
        private SecretKey keyCc;
        private SecretKey keyCs;

        DigestPrivacy() throws SaslException {
            try {
                this.generatePrivacyKeyPair();
                this.cipherCc.init(1, (Key)this.keyCc, this.IVcc);
                this.cipherCs.init(2, (Key)this.keyCs, this.IVcs);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new SaslException("DIGEST-MD5: Invalid byte array used to create cipher keys", invalidKeyException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SaslException("DIGEST-MD5: Error encoding string value into UTF-8", unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new SaslException("DIGEST-MD5: Error accessing buffers required to generate cipher keys", iOException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SaslException("DIGEST-MD5: Error creating instance of required cipher", noSuchAlgorithmException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new SaslException("DIGEST-MD5: Invalid cipher algorithem parameter used to create cipher instance", invalidAlgorithmParameterException);
            }
        }

        private void generatePrivacyKeyPair() throws IOException, NoSuchAlgorithmException, UnsupportedEncodingException, SaslException {
            byte[] byArray = CLIENT_CONF_MAGIC.getBytes(DigestUtils.this.encoding);
            byte[] byArray2 = SVR_CONF_MAGIC.getBytes(DigestUtils.this.encoding);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            int n = DigestUtils.this.cipherSuite.equals(CIPHER_TOKENS[4]) ? 5 : (DigestUtils.this.cipherSuite.equals(CIPHER_TOKENS[3]) ? 7 : 16);
            byte[] byArray3 = new byte[n + byArray.length];
            System.arraycopy(DigestUtils.this.H_A1, 0, byArray3, 0, n);
            System.arraycopy(byArray, 0, byArray3, n, byArray.length);
            messageDigest.update(byArray3);
            byte[] byArray4 = messageDigest.digest();
            System.arraycopy(byArray2, 0, byArray3, n, byArray2.length);
            messageDigest.update(byArray3);
            byte[] byArray5 = messageDigest.digest();
            if (DigestUtils.this.cipherSuite.indexOf(CIPHER_TOKENS[1]) > -1) {
                try {
                    this.cipherCc = Cipher.getInstance("RC4");
                    this.cipherCs = Cipher.getInstance("RC4");
                    this.keyCc = new SecretKeySpec(byArray4, "RC4");
                    this.keyCs = new SecretKeySpec(byArray5, "RC4");
                }
                catch (NoSuchPaddingException noSuchPaddingException) {
                    throw new SaslException("DIGEST-MD5: Incorrect padding used for RC4 cipher", noSuchPaddingException);
                }
            }
            if (DigestUtils.this.cipherSuite.equals(CIPHER_TOKENS[2]) || DigestUtils.this.cipherSuite.equals(CIPHER_TOKENS[0])) {
                try {
                    String string;
                    String string2;
                    if (DigestUtils.this.cipherSuite.equals(CIPHER_TOKENS[2])) {
                        string2 = "DES/CBC/NoPadding";
                        string = "des";
                    } else {
                        string2 = "DESede/CBC/NoPadding";
                        string = "desede";
                    }
                    this.cipherCc = Cipher.getInstance(string2);
                    this.cipherCs = Cipher.getInstance(string2);
                    this.keyCc = DigestUtils.makeDesKeys(byArray4, string);
                    this.keyCs = DigestUtils.makeDesKeys(byArray5, string);
                    this.IVcc = new IvParameterSpec(byArray4, 8, 8);
                    this.IVcs = new IvParameterSpec(byArray5, 8, 8);
                }
                catch (NoSuchPaddingException noSuchPaddingException) {
                    throw new SaslException("DIGEST-MD5: Unsupported padding used for chosen cipher", noSuchPaddingException);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new SaslException("DIGEST-MD5: Invalid data used to initialize keys", invalidKeyException);
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    throw new SaslException("DIGEST-MD5: Unsupported key specification used.", invalidKeySpecException);
                }
            }
        }

        public byte[] wrap(byte[] byArray, int n, int n2) throws SaslException {
            byte[] byArray2;
            byte[] byArray3;
            if (n2 == 0) {
                return DigestUtils.this.EMPTY_BYTE_ARRAY;
            }
            this.incrementSeqNum(this.sequenceNum, 0, 4);
            byte[] byArray4 = this.getHMAC(this.Kic, this.sequenceNum, byArray, n, n2);
            int n3 = this.cipherCc.getBlockSize();
            if (n3 > 1) {
                int n4 = n3 - (n2 + 10) % n3;
                byArray3 = new byte[n4];
                for (int i = 0; i < n4; ++i) {
                    byArray3[i] = (byte)n4;
                }
            } else {
                byArray3 = DigestUtils.this.EMPTY_BYTE_ARRAY;
            }
            byte[] byArray5 = new byte[n2 + byArray3.length + 10];
            System.arraycopy(byArray, n, byArray5, 0, n2);
            System.arraycopy(byArray3, 0, byArray5, n2, byArray3.length);
            System.arraycopy(byArray4, 0, byArray5, n2 + byArray3.length, 10);
            try {
                byArray2 = nochain ? this.cipherCc.doFinal(byArray5) : this.cipherCc.update(byArray5);
                if (byArray2 == null) {
                    throw new IllegalBlockSizeException("" + byArray5.length);
                }
            }
            catch (BadPaddingException badPaddingException) {
                throw new SaslException("DIGEST-MD5: Invalid padding used for block cipher", badPaddingException);
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new SaslException("DIGEST-MD5: Invalid block size for cipher", illegalBlockSizeException);
            }
            byte[] byArray6 = new byte[byArray2.length + 2 + 4];
            System.arraycopy(byArray2, 0, byArray6, 0, byArray2.length);
            System.arraycopy(this.messageType, 0, byArray6, byArray2.length, 2);
            System.arraycopy(this.sequenceNum, 0, byArray6, byArray2.length + 2, 4);
            return byArray6;
        }

        public byte[] unwrap(byte[] byArray, int n, int n2) throws SaslException {
            byte[] byArray2;
            if (n2 == 0) {
                return DigestUtils.this.EMPTY_BYTE_ARRAY;
            }
            byte[] byArray3 = new byte[n2 - 6];
            byte[] byArray4 = new byte[2];
            byte[] byArray5 = new byte[4];
            System.arraycopy(byArray, n, byArray3, 0, byArray3.length);
            System.arraycopy(byArray, n + byArray3.length, byArray4, 0, 2);
            System.arraycopy(byArray, n + byArray3.length + 2, byArray5, 0, 4);
            try {
                byArray2 = nochain ? this.cipherCs.doFinal(byArray3) : this.cipherCs.update(byArray3);
                if (byArray2 == null) {
                    throw new IllegalBlockSizeException("" + byArray3.length);
                }
            }
            catch (BadPaddingException badPaddingException) {
                throw new SaslException("DIGEST-MD5: Incorrect padding used with chosen cipher", badPaddingException);
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new SaslException("DIGEST-MD5: Illegal block sizes used with chosen cipher", illegalBlockSizeException);
            }
            byte[] byArray6 = new byte[byArray2.length - 10];
            byte[] byArray7 = new byte[10];
            System.arraycopy(byArray2, 0, byArray6, 0, byArray6.length);
            System.arraycopy(byArray2, byArray6.length, byArray7, 0, 10);
            int n3 = byArray6.length;
            int n4 = this.cipherCs.getBlockSize();
            if (n4 > 1 && (n3 -= byArray6[byArray6.length - 1]) < 0) {
                return DigestUtils.this.EMPTY_BYTE_ARRAY;
            }
            byte[] byArray8 = this.getHMAC(this.Kis, byArray5, byArray6, 0, n3);
            if (!this.compareMACs(byArray7, byArray8)) {
                return DigestUtils.this.EMPTY_BYTE_ARRAY;
            }
            if (this.svrCltSeqNum != SaslImpl.networkByteOrderToInt(byArray5, 0, 4)) {
                throw new SaslException("DIGEST-MD5: Out of order sequencing of messages from server. Got: " + SaslImpl.networkByteOrderToInt(byArray5, 0, 4) + " Expected: " + this.svrCltSeqNum);
            }
            if (!Arrays.equals(this.messageType, byArray4)) {
                throw new SaslException("DIGEST-MD5: invalid message type: " + SaslImpl.networkByteOrderToInt(byArray4, 0, 2));
            }
            ++this.svrCltSeqNum;
            if (n3 == byArray6.length) {
                return byArray6;
            }
            byte[] byArray9 = new byte[n3];
            System.arraycopy(byArray6, 0, byArray9, 0, n3);
            return byArray9;
        }
    }

    class DigestIntegrity
    implements DigestSecurityCtx {
        private static final String CLIENT_INT_MAGIC = "Digest session key to client-to-server signing key magic constant";
        private static final String SVR_INT_MAGIC = "Digest session key to server-to-client signing key magic constant";
        protected byte[] Kic;
        protected byte[] Kis;
        protected int cltSvrSeqNum = 0;
        protected int svrCltSeqNum = 0;
        protected final byte[] messageType = new byte[2];
        protected byte[] sequenceNum = new byte[4];

        DigestIntegrity() throws SaslException {
            try {
                this.generateIntegrityKeyPair();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SaslException("DIGEST-MD5: Error encoding strings into UTF-8", unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new SaslException("DIGEST-MD5: Error accessing buffers required to create integrity key pairs", iOException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SaslException("DIGEST-MD5: Unsupported digest algorithm used to create integrity key pairs", noSuchAlgorithmException);
            }
            SaslImpl.intToNetworkByteOrder(1, this.messageType, 0, 2);
        }

        private void generateIntegrityKeyPair() throws UnsupportedEncodingException, IOException, NoSuchAlgorithmException {
            byte[] byArray = CLIENT_INT_MAGIC.getBytes(DigestUtils.this.encoding);
            byte[] byArray2 = SVR_INT_MAGIC.getBytes(DigestUtils.this.encoding);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray3 = new byte[DigestUtils.this.H_A1.length + byArray.length];
            System.arraycopy(DigestUtils.this.H_A1, 0, byArray3, 0, DigestUtils.this.H_A1.length);
            System.arraycopy(byArray, 0, byArray3, DigestUtils.this.H_A1.length, byArray.length);
            messageDigest.update(byArray3);
            this.Kic = messageDigest.digest();
            System.arraycopy(byArray2, 0, byArray3, DigestUtils.this.H_A1.length, byArray2.length);
            messageDigest.update(byArray3);
            this.Kis = messageDigest.digest();
        }

        public byte[] wrap(byte[] byArray, int n, int n2) throws SaslException {
            if (n2 == 0) {
                return DigestUtils.this.EMPTY_BYTE_ARRAY;
            }
            byte[] byArray2 = new byte[n2 + 10 + 2 + 4];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            this.incrementSeqNum(this.sequenceNum, 0, 4);
            byte[] byArray3 = this.getHMAC(this.Kic, this.sequenceNum, byArray, n, n2);
            System.arraycopy(byArray3, 0, byArray2, n2, 10);
            System.arraycopy(this.messageType, 0, byArray2, n2 + 10, 2);
            System.arraycopy(this.sequenceNum, 0, byArray2, n2 + 12, 4);
            return byArray2;
        }

        public byte[] unwrap(byte[] byArray, int n, int n2) throws SaslException {
            if (n2 == 0) {
                return DigestUtils.this.EMPTY_BYTE_ARRAY;
            }
            byte[] byArray2 = new byte[10];
            byte[] byArray3 = new byte[n2 - 16];
            byte[] byArray4 = new byte[2];
            byte[] byArray5 = new byte[4];
            System.arraycopy(byArray, n, byArray3, 0, byArray3.length);
            System.arraycopy(byArray, n + byArray3.length, byArray2, 0, 10);
            System.arraycopy(byArray, n + byArray3.length + 10, byArray4, 0, 2);
            System.arraycopy(byArray, n + byArray3.length + 12, byArray5, 0, 4);
            byte[] byArray6 = this.getHMAC(this.Kis, byArray5, byArray3, 0, byArray3.length);
            if (!this.compareMACs(byArray2, byArray6)) {
                return DigestUtils.this.EMPTY_BYTE_ARRAY;
            }
            if (this.svrCltSeqNum != SaslImpl.networkByteOrderToInt(byArray5, 0, 4)) {
                throw new SaslException("DIGEST-MD5: Out of order sequencing of messages from server. Got: " + SaslImpl.networkByteOrderToInt(byArray5, 0, 4) + " Expected: " + this.svrCltSeqNum);
            }
            if (!Arrays.equals(this.messageType, byArray4)) {
                throw new SaslException("DIGEST-MD5: invalid message type: " + SaslImpl.networkByteOrderToInt(byArray4, 0, 2));
            }
            ++this.svrCltSeqNum;
            return byArray3;
        }

        protected byte[] getHMAC(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2) throws SaslException {
            byte[] byArray4 = new byte[4 + n2];
            System.arraycopy(byArray2, 0, byArray4, 0, 4);
            System.arraycopy(byArray3, n, byArray4, 4, n2);
            try {
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HmacMD5");
                Mac mac = Mac.getInstance("HmacMD5");
                mac.init(secretKeySpec);
                mac.update(byArray4);
                byte[] byArray5 = mac.doFinal();
                byte[] byArray6 = new byte[10];
                System.arraycopy(byArray5, 0, byArray6, 0, 10);
                return byArray6;
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new SaslException("DIGEST-MD5: Invalid bytes used for key of HMAC-MD5 hash.", invalidKeyException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SaslException("DIGEST-MD5: Error creating instance of MD5 digest algorithm", noSuchAlgorithmException);
            }
        }

        protected boolean compareMACs(byte[] byArray, byte[] byArray2) {
            return Arrays.equals(byArray, byArray2);
        }

        protected void incrementSeqNum(byte[] byArray, int n, int n2) {
            SaslImpl.intToNetworkByteOrder(this.cltSvrSeqNum++, byArray, n, n2);
        }
    }
}

