/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.cache.DownloadProtocol;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.PackageDesc;
import com.sun.javaws.jnl.PropertyDesc;
import com.sun.javaws.jnl.ResourceType;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.util.URLUtil;
import com.sun.javaws.util.VersionString;
import com.sun.javaws.xml.XMLNode;
import com.sun.javaws.xml.XMLNodeBuilder;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;

public class ResourcesDesc
implements ResourceType {
    private ArrayList _list = new ArrayList();
    private LaunchDesc _parent = null;

    boolean isEmpty() {
        return this._list.isEmpty();
    }

    public ExtensionDesc[] getExtensionDescs() {
        final ArrayList arrayList = new ArrayList();
        ExtensionDesc[] extensionDescArray = new ExtensionDesc[]{};
        this.visit(new ResourceVisitor(){

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                arrayList.add(extensionDesc);
            }

            public void visitJARDesc(JARDesc jARDesc) {
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }
        });
        return arrayList.toArray(extensionDescArray);
    }

    public JARDesc[] getLocalJarDescs() {
        ArrayList arrayList = new ArrayList(this._list.size());
        for (int i = 0; i < this._list.size(); ++i) {
            Object e = this._list.get(i);
            if (!(e instanceof JARDesc)) continue;
            arrayList.add(e);
        }
        return this.toJARDescArray(arrayList);
    }

    public JARDesc getMainJar(boolean bl) {
        final JARDesc[] jARDescArray = new JARDesc[2];
        this.visit(new ResourceVisitor(){

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
            }

            public void visitJARDesc(JARDesc jARDesc) {
                if (jARDesc.isJavaFile()) {
                    if (jARDescArray[0] == null) {
                        jARDescArray[0] = jARDesc;
                    }
                    if (jARDesc.isMainJarFile()) {
                        jARDescArray[1] = jARDesc;
                    }
                }
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }
        });
        JARDesc jARDesc = jARDescArray[0];
        JARDesc jARDesc2 = jARDescArray[1];
        return jARDesc2 != null && bl ? jARDesc2 : jARDesc;
    }

    public JARDesc[] getEagerOrAllJarDescs(boolean bl) {
        final HashSet hashSet = new HashSet();
        if (!bl) {
            this.visit(new ResourceVisitor(){

                public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                }

                public void visitJARDesc(JARDesc jARDesc) {
                    if (!jARDesc.isLazyDownload() && jARDesc.getPartName() != null) {
                        hashSet.add(jARDesc.getPartName());
                    }
                }

                public void visitJREDesc(JREDesc jREDesc) {
                }

                public void visitPackageDesc(PackageDesc packageDesc) {
                }

                public void visitPropertyDesc(PropertyDesc propertyDesc) {
                }
            });
        }
        ArrayList arrayList = new ArrayList();
        this.addJarsToList(arrayList, hashSet, bl, true);
        return this.toJARDescArray(arrayList);
    }

    public JREDesc getSelectedJRE() {
        for (int i = 0; i < this._list.size(); ++i) {
            Object e = this._list.get(i);
            if (!(e instanceof JREDesc) || !((JREDesc)e).isSelected()) continue;
            return (JREDesc)e;
        }
        return null;
    }

    public LaunchDesc getParent() {
        return this._parent;
    }

    void setParent(LaunchDesc launchDesc) {
        this._parent = launchDesc;
        for (int i = 0; i < this._list.size(); ++i) {
            JREDesc jREDesc;
            Object e = this._list.get(i);
            if (!(e instanceof JREDesc) || (jREDesc = (JREDesc)e).getNestedResources() == null) continue;
            jREDesc.getNestedResources().setParent(launchDesc);
        }
    }

    void addResource(ResourceType resourceType) {
        if (resourceType != null) {
            this._list.add(resourceType);
        }
    }

    public void visit(ResourceVisitor resourceVisitor) {
        for (int i = 0; i < this._list.size(); ++i) {
            ResourceType resourceType = (ResourceType)this._list.get(i);
            resourceType.visit(resourceVisitor);
        }
    }

    public XMLNode asXML() {
        XMLNodeBuilder xMLNodeBuilder = new XMLNodeBuilder("resources", null);
        for (int i = 0; i < this._list.size(); ++i) {
            ResourceType resourceType = (ResourceType)this._list.get(i);
            xMLNodeBuilder.add(resourceType);
        }
        return xMLNodeBuilder.getNode();
    }

    public Properties getResourceProperties() {
        final Properties properties = new Properties();
        this.visit(new ResourceVisitor(){

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
            }

            public void visitJARDesc(JARDesc jARDesc) {
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
                properties.setProperty(propertyDesc.getKey(), propertyDesc.getValue());
            }
        });
        return properties;
    }

    public JARDesc[] getPart(final String string) {
        final ArrayList arrayList = new ArrayList();
        this.visit(new ResourceVisitor(){

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
            }

            public void visitJARDesc(JARDesc jARDesc) {
                if (string.equals(jARDesc.getPartName())) {
                    arrayList.add(jARDesc);
                }
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }
        });
        return this.toJARDescArray(arrayList);
    }

    public JARDesc[] getPartJars(String string) {
        return this.getPartJars(new String[]{string});
    }

    public JARDesc[] getPartJars(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        ArrayList arrayList = new ArrayList();
        this.addJarsToList(arrayList, hashSet, false, false);
        return this.toJARDescArray(arrayList);
    }

    private JARDesc[] toJARDescArray(ArrayList arrayList) {
        JARDesc[] jARDescArray = new JARDesc[arrayList.size()];
        return arrayList.toArray(jARDescArray);
    }

    public PackageInformation getPackageInformation(String string) {
        if ((string = string.replace('/', '.')).endsWith(".class")) {
            string = string.substring(0, string.length() - 6);
        }
        return ResourcesDesc.visitPackageElements(this.getParent(), string);
    }

    private void addJarsToList(final ArrayList arrayList, final HashSet hashSet, final boolean bl, final boolean bl2) {
        this.visit(new ResourceVisitor(){

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                Object object;
                HashSet hashSet2 = extensionDesc.getExtensionPackages(hashSet, bl2);
                if (extensionDesc.getExtensionDesc() == null) {
                    object = ConfigProperties.getInstance().getKnownPlatforms();
                    DiskCacheEntry diskCacheEntry = null;
                    try {
                        diskCacheEntry = DownloadProtocol.getCachedExtension(extensionDesc.getLocation(), extensionDesc.getVersion(), (String)object);
                        if (diskCacheEntry != null && diskCacheEntry.getFile() != null) {
                            LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(diskCacheEntry.getFile());
                            extensionDesc.setExtensionDesc(launchDesc);
                        }
                    }
                    catch (Exception exception) {
                        Debug.ignoredException(exception);
                    }
                }
                if (extensionDesc.getExtensionDesc() != null && (object = extensionDesc.getExtensionDesc().getResources()) != null) {
                    ((ResourcesDesc)object).addJarsToList(arrayList, hashSet2, bl, bl2);
                }
            }

            public void visitJARDesc(JARDesc jARDesc) {
                if (bl || bl2 && !jARDesc.isLazyDownload() || hashSet.contains(jARDesc.getPartName())) {
                    arrayList.add(jARDesc);
                }
            }

            public void visitJREDesc(JREDesc jREDesc) {
                if (jREDesc.isSelected()) {
                    ResourcesDesc resourcesDesc;
                    ResourcesDesc resourcesDesc2 = jREDesc.getNestedResources();
                    if (resourcesDesc2 != null) {
                        resourcesDesc2.addJarsToList(arrayList, hashSet, bl, bl2);
                    }
                    if (jREDesc.getExtensionDesc() != null && (resourcesDesc = jREDesc.getExtensionDesc().getResources()) != null) {
                        resourcesDesc.addJarsToList(arrayList, new HashSet(), bl, bl2);
                    }
                }
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }
        });
    }

    private ExtensionDesc findExtension(final URL uRL, final String string) {
        final ExtensionDesc[] extensionDescArray = new ExtensionDesc[1];
        this.visit(new ResourceVisitor(){

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                if (extensionDescArray[0] == null) {
                    if (URLUtil.equals(extensionDesc.getLocation(), uRL) && (string == null || new VersionString(string).contains(extensionDesc.getVersion()))) {
                        extensionDescArray[0] = extensionDesc;
                    } else {
                        LaunchDesc launchDesc = extensionDesc.getExtensionDesc();
                        if (launchDesc != null && launchDesc.getResources() != null) {
                            extensionDescArray[0] = launchDesc.getResources().findExtension(uRL, string);
                        }
                    }
                }
            }

            public void visitJARDesc(JARDesc jARDesc) {
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }
        });
        return extensionDescArray[0];
    }

    public JARDesc[] getResource(final URL uRL, String string) {
        final VersionString versionString = string != null ? new VersionString(string) : null;
        final JARDesc[] jARDescArray = new JARDesc[1];
        this.visit(new ResourceVisitor(){

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
            }

            public void visitJARDesc(JARDesc jARDesc) {
                if (URLUtil.equals(jARDesc.getLocation(), uRL)) {
                    if (versionString == null) {
                        jARDescArray[0] = jARDesc;
                    } else if (versionString.contains(jARDesc.getVersion())) {
                        jARDescArray[0] = jARDesc;
                    }
                }
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }
        });
        if (jARDescArray[0] == null) {
            return null;
        }
        if (jARDescArray[0].getPartName() != null) {
            return this.getPartJars(jARDescArray[0].getPartName());
        }
        return jARDescArray;
    }

    private static PackageInformation visitPackageElements(final LaunchDesc launchDesc, final String string) {
        final PackageInformation[] packageInformationArray = new PackageInformation[1];
        launchDesc.getResources().visit(new ResourceVisitor(){

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                if (!extensionDesc.isInstaller()) {
                    LaunchDesc launchDesc2 = extensionDesc.getExtensionDesc();
                    if (packageInformationArray[0] == null && launchDesc2.isLibrary() && launchDesc2.getResources() != null) {
                        packageInformationArray[0] = ResourcesDesc.visitPackageElements(launchDesc2, string);
                    }
                }
            }

            public void visitJARDesc(JARDesc jARDesc) {
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
                if (packageInformationArray[0] == null && packageDesc.match(string)) {
                    packageInformationArray[0] = new PackageInformation(launchDesc, packageDesc.getPart());
                }
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }
        });
        return packageInformationArray[0];
    }

    public JARDesc[] getExtensionPart(final URL uRL, final String string, final String string2) {
        final JARDesc[][] jARDescArray = new JARDesc[1][];
        this.visit(new ResourceVisitor(){

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                if (URLUtil.equals(extensionDesc.getLocation(), uRL)) {
                    if (string == null) {
                        if (extensionDesc.getVersion() == null && extensionDesc.getExtensionResources() != null) {
                            jARDescArray[0] = extensionDesc.getExtensionResources().getPart(string2);
                        }
                    } else if (string.equals(extensionDesc.getVersion()) && extensionDesc.getExtensionResources() != null) {
                        jARDescArray[0] = extensionDesc.getExtensionResources().getPart(string2);
                    }
                }
            }

            public void visitJARDesc(JARDesc jARDesc) {
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }
        });
        return jARDescArray[0];
    }

    public JARDesc[] getExtensionPart(URL uRL, String string, String[] stringArray) {
        ExtensionDesc extensionDesc = this.findExtension(uRL, string);
        if (extensionDesc == null) {
            return null;
        }
        ResourcesDesc resourcesDesc = extensionDesc.getExtensionResources();
        if (resourcesDesc == null) {
            return null;
        }
        return resourcesDesc.getPartJars(stringArray);
    }

    public static class PackageInformation {
        private LaunchDesc _launchDesc;
        private String _part;

        public LaunchDesc getLaunchDesc() {
            return this._launchDesc;
        }

        public String getPart() {
            return this._part;
        }

        PackageInformation(LaunchDesc launchDesc, String string) {
            this._launchDesc = launchDesc;
            this._part = string;
        }
    }
}

