/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import sun.plugin.AppletViewer;
import sun.plugin.ConsoleWindow;
import sun.plugin.DebugOutputStream;
import sun.plugin.MainConsoleWriter;
import sun.plugin.util.PluginSysUtil;
import sun.plugin.util.UserProfile;

public class JavaRunTime {
    private static OutputStream traceStream = null;
    private static MainConsoleWriter mainWriter = null;
    private static boolean traceInit = false;

    protected static void initEnvironment(String string, String string2, String string3) {
        Properties properties = System.getProperties();
        properties.put("java.home", string);
        if (string3 == null) {
            properties.put("user.home", string);
        } else {
            properties.put("user.home", string3);
        }
        AppletViewer.loadPropertiesFiles();
    }

    public static synchronized ConsoleWindow getJavaConsole() {
        JavaRunTime.initTraceEnvironment();
        return mainWriter.getJavaConsole();
    }

    public static synchronized void initTraceEnvironment() {
        if (traceInit) {
            return;
        }
        traceInit = true;
        mainWriter = new MainConsoleWriter(JavaRunTime.getTraceOutputStream());
        DebugOutputStream debugOutputStream = new DebugOutputStream(mainWriter);
        PrintStream printStream = new PrintStream(debugOutputStream, true);
        System.setErr(printStream);
        DebugOutputStream debugOutputStream2 = new DebugOutputStream(mainWriter);
        PrintStream printStream2 = new PrintStream(debugOutputStream2, true);
        System.setOut(printStream2);
        String string = ConsoleWindow.displayVersion();
        System.out.print(string);
    }

    public static boolean isJavaConsoleVisible() {
        ConsoleWindow consoleWindow = JavaRunTime.getJavaConsole();
        if (consoleWindow != null) {
            return consoleWindow.isConsoleVisible();
        }
        return false;
    }

    public static void showJavaConsole(final boolean bl) {
        final ConsoleWindow consoleWindow = JavaRunTime.getJavaConsole();
        if (consoleWindow != null) {
            try {
                PluginSysUtil.invokeAndWait(new Runnable(){

                    public void run() {
                        consoleWindow.showConsole(bl);
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void showJavaConsoleLater(final boolean bl) {
        final ConsoleWindow consoleWindow = JavaRunTime.getJavaConsole();
        if (consoleWindow != null) {
            try {
                PluginSysUtil.invokeLater(new Runnable(){

                    public void run() {
                        consoleWindow.showConsole(bl);
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void showJavaConsoleHelp() {
        JavaRunTime.initTraceEnvironment();
        String string = ConsoleWindow.displayHelp();
        System.out.print(string);
    }

    public static void showSystemProperties() {
        JavaRunTime.initTraceEnvironment();
        ConsoleWindow.displaySystemProperties();
    }

    public static void printToJavaConsole(String string) {
        ConsoleWindow consoleWindow = JavaRunTime.getJavaConsole();
        if (consoleWindow != null) {
            consoleWindow.append(string);
        }
    }

    public static OutputStream getTraceOutputStream() {
        if (traceStream != null) {
            return traceStream;
        }
        try {
            File file = new File(UserProfile.getTraceFile());
            if (file.exists()) {
                file.delete();
            }
            traceStream = new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return traceStream;
    }

    public static synchronized ThreadGroup getPluginThreadGroup() {
        return PluginSysUtil.getPluginThreadGroup();
    }

    public static native String dumpAllStacks();
}

