/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.Surrogate;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.JIS_X_0201;
import sun.nio.cs.ext.JIS_X_0208;

public class EUC_JP_LINUX
extends Charset
implements HistoricallyNamedCharset {
    static /* synthetic */ Class class$sun$nio$cs$ext$EUC_JP_LINUX;

    public EUC_JP_LINUX() {
        super("x-euc-jp-linux", ExtendedCharsets.aliasesFor("x-euc-jp-linux"));
    }

    public String historicalName() {
        return "EUC_JP_LINUX";
    }

    public boolean contains(Charset charset) {
        return charset instanceof JIS_X_0201 || charset.name().equals("US-ASCII") || charset instanceof JIS_X_0208 || charset instanceof EUC_JP_LINUX;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Decoder
    extends JIS_X_0208.Decoder {
        JIS_X_0201.Decoder decoderJ0201;
        short[] jis0208Index1;
        String[] jis0208Index2;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !(class$sun$nio$cs$ext$EUC_JP_LINUX == null ? (class$sun$nio$cs$ext$EUC_JP_LINUX = EUC_JP_LINUX.class$("sun.nio.cs.ext.EUC_JP_LINUX")) : class$sun$nio$cs$ext$EUC_JP_LINUX).desiredAssertionStatus();
        }

        protected char convSingleByte(int n) {
            if (n < 0 || n > 127) {
                return '\ufffd';
            }
            return this.decoderJ0201.decode(n);
        }

        protected char decodeDouble(int n, int n2) {
            if (n == 142) {
                return this.decoderJ0201.decode(n2 - 256);
            }
            if (n < 0 || n > this.jis0208Index1.length || n2 < this.start || n2 > this.end) {
                return '\ufffd';
            }
            int n3 = (this.jis0208Index1[n - 128] & 0xF) * (this.end - this.start + 1) + (n2 - this.start);
            return this.jis0208Index2[this.jis0208Index1[n - 128] >> 4].charAt(n3);
        }

        private Decoder(Charset charset) {
            super(charset);
            this.decoderJ0201 = new JIS_X_0201.Decoder(charset);
            this.start = 161;
            this.end = 254;
            this.jis0208Index1 = super.getIndex1();
            this.jis0208Index2 = super.getIndex2();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            CoderResult coderResult;
            int n;
            int n2;
            block17: {
                CoderResult coderResult2;
                block16: {
                    CoderResult coderResult3;
                    block15: {
                        CoderResult coderResult4;
                        block14: {
                            CoderResult coderResult5;
                            block13: {
                                CoderResult coderResult6;
                                block12: {
                                    byte[] byArray = byteBuffer.array();
                                    n2 = byteBuffer.arrayOffset() + byteBuffer.position();
                                    int n3 = byteBuffer.arrayOffset() + byteBuffer.limit();
                                    if (!$assertionsDisabled && n2 > n3) {
                                        throw new AssertionError();
                                    }
                                    char[] cArray = charBuffer.array();
                                    n = charBuffer.arrayOffset() + charBuffer.position();
                                    int n4 = charBuffer.arrayOffset() + charBuffer.limit();
                                    if (!$assertionsDisabled && n > n4) {
                                        throw new AssertionError();
                                    }
                                    n = n <= n4 ? n : n4;
                                    int n5 = 0;
                                    int n6 = 0;
                                    int n7 = 0;
                                    int n8 = 65533;
                                    try {
                                        for (n2 = n2 <= n3 ? n2 : n3; n2 < n3; n2 += n7) {
                                            n5 = byArray[n2] & 0xFF;
                                            n7 = 1;
                                            if ((n5 & 0x80) == 0) {
                                                n8 = (char)n5;
                                            } else {
                                                if ((n5 & 0xFF) == 143) {
                                                    if (n2 + 3 > n3) {
                                                        coderResult6 = CoderResult.UNDERFLOW;
                                                        Object var15_19 = null;
                                                        byteBuffer.position(n2 - byteBuffer.arrayOffset());
                                                        break block12;
                                                    }
                                                    coderResult5 = CoderResult.unmappableForLength(n7);
                                                    break block13;
                                                }
                                                if (n2 + 2 > n3) {
                                                    coderResult4 = CoderResult.UNDERFLOW;
                                                    break block14;
                                                }
                                                n6 = byArray[n2 + 1] & 0xFF;
                                                ++n7;
                                                n8 = this.decodeDouble(n5, n6);
                                            }
                                            if (n8 == 65533) {
                                                coderResult3 = CoderResult.malformedForLength(n7);
                                                break block15;
                                            }
                                            if (n + 1 > n4) {
                                                coderResult2 = CoderResult.OVERFLOW;
                                                break block16;
                                            }
                                            cArray[n++] = n8;
                                        }
                                        coderResult = CoderResult.UNDERFLOW;
                                        break block17;
                                    }
                                    catch (Throwable throwable) {
                                        Object var15_25 = null;
                                        byteBuffer.position(n2 - byteBuffer.arrayOffset());
                                        charBuffer.position(n - charBuffer.arrayOffset());
                                        throw throwable;
                                    }
                                }
                                charBuffer.position(n - charBuffer.arrayOffset());
                                return coderResult6;
                            }
                            Object var15_20 = null;
                            byteBuffer.position((n2 += (n7 += 2)) - byteBuffer.arrayOffset());
                            charBuffer.position(n - charBuffer.arrayOffset());
                            return coderResult5;
                        }
                        Object var15_21 = null;
                        byteBuffer.position(n2 - byteBuffer.arrayOffset());
                        charBuffer.position(n - charBuffer.arrayOffset());
                        return coderResult4;
                    }
                    Object var15_22 = null;
                    byteBuffer.position(n2 - byteBuffer.arrayOffset());
                    charBuffer.position(n - charBuffer.arrayOffset());
                    return coderResult3;
                }
                Object var15_23 = null;
                byteBuffer.position(n2 - byteBuffer.arrayOffset());
                charBuffer.position(n - charBuffer.arrayOffset());
                return coderResult2;
            }
            Object var15_24 = null;
            byteBuffer.position(n2 - byteBuffer.arrayOffset());
            charBuffer.position(n - charBuffer.arrayOffset());
            return coderResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            char c = '\ufffd';
            try {
                while (byteBuffer.hasRemaining()) {
                    n2 = byteBuffer.get() & 0xFF;
                    n4 = 1;
                    if ((n2 & 0x80) == 0) {
                        c = (char)n2;
                    } else {
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        if ((n2 & 0xFF) == 143) {
                            n3 = byteBuffer.get() & 0xFF;
                            n += ++n4;
                            CoderResult coderResult = CoderResult.unmappableForLength(n4);
                            return coderResult;
                        }
                        n3 = byteBuffer.get() & 0xFF;
                        ++n4;
                        c = this.decodeDouble(n2, n3);
                    }
                    if (c == '\ufffd') {
                        CoderResult coderResult = CoderResult.unmappableForLength(n4);
                        return coderResult;
                    }
                    if (charBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    charBuffer.put(c);
                    n += n4;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }
    }

    private static class Encoder
    extends JIS_X_0208.Encoder {
        JIS_X_0201.Encoder encoderJ0201;
        private final Surrogate.Parser sgp = new Surrogate.Parser();
        short[] jis0208Index1;
        String[] jis0208Index2;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !(class$sun$nio$cs$ext$EUC_JP_LINUX == null ? (class$sun$nio$cs$ext$EUC_JP_LINUX = EUC_JP_LINUX.class$("sun.nio.cs.ext.EUC_JP_LINUX")) : class$sun$nio$cs$ext$EUC_JP_LINUX).desiredAssertionStatus();
        }

        protected int encodeDouble(char c) {
            int n = this.jis0208Index1[(c & 0xFF00) >> 8] << 8;
            char c2 = this.jis0208Index2[n >> 12].charAt((n & 0xFFF) + (c & 0xFF));
            if (c2 != '\u0000') {
                return c2 + 32896;
            }
            return c2;
        }

        public boolean canEncode(char c) {
            byte[] byArray = new byte[2];
            return this.encodeSingle(c, byArray) != 0 || this.encodeDouble(c) != 0;
        }

        protected int encodeSingle(char c, byte[] byArray) {
            if (c == '\u0000') {
                byArray[0] = 0;
                return 1;
            }
            byte by = this.encoderJ0201.encode(c);
            if (by == 0) {
                return 0;
            }
            if (by > 0 && by < 128) {
                byArray[0] = by;
                return 1;
            }
            byArray[0] = -114;
            byArray[1] = by;
            return 2;
        }

        private Encoder(Charset charset) {
            super(charset, 2.0f, 2.0f);
            this.encoderJ0201 = new JIS_X_0201.Encoder(charset);
            this.jis0208Index1 = super.getIndex1();
            this.jis0208Index2 = super.getIndex2();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            CoderResult coderResult;
            int n;
            int n2;
            block15: {
                CoderResult coderResult2;
                block14: {
                    CoderResult coderResult3;
                    block13: {
                        CoderResult coderResult4;
                        block12: {
                            CoderResult coderResult5;
                            block11: {
                                char[] cArray = charBuffer.array();
                                n2 = charBuffer.arrayOffset() + charBuffer.position();
                                int n3 = charBuffer.arrayOffset() + charBuffer.limit();
                                if (!$assertionsDisabled && n2 > n3) {
                                    throw new AssertionError();
                                }
                                byte[] byArray = byteBuffer.array();
                                n = byteBuffer.arrayOffset() + byteBuffer.position();
                                int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
                                if (!$assertionsDisabled && n > n4) {
                                    throw new AssertionError();
                                }
                                n = n <= n4 ? n : n4;
                                int n5 = 0;
                                boolean bl = false;
                                byte[] byArray2 = new byte[2];
                                try {
                                    for (n2 = n2 <= n3 ? n2 : n3; n2 < n3; ++n2) {
                                        int n6;
                                        byte[] byArray3 = byArray2;
                                        char c = cArray[n2];
                                        if (Surrogate.is(c)) {
                                            if (this.sgp.parse(c, cArray, n2, n3) < 0) {
                                                coderResult5 = this.sgp.error();
                                                Object var17_19 = null;
                                                charBuffer.position(n2 - charBuffer.arrayOffset());
                                                break block11;
                                            }
                                            coderResult4 = this.sgp.unmappableResult();
                                            break block12;
                                        }
                                        n5 = this.encodeSingle(c, byArray3);
                                        if (n5 == 0) {
                                            n6 = this.encodeDouble(c);
                                            if (n6 == 0 || (n6 & 0xFF0000) != 0) {
                                                coderResult3 = CoderResult.unmappableForLength(1);
                                                break block13;
                                            }
                                            byArray3[0] = (byte)((n6 & 0xFF00) >> 8);
                                            byArray3[1] = (byte)(n6 & 0xFF);
                                            n5 = 2;
                                        }
                                        if (n4 - n < n5) {
                                            coderResult2 = CoderResult.OVERFLOW;
                                            break block14;
                                        }
                                        for (n6 = 0; n6 < n5; ++n6) {
                                            byArray[n++] = byArray3[n6];
                                        }
                                    }
                                    coderResult = CoderResult.UNDERFLOW;
                                    break block15;
                                }
                                catch (Throwable throwable) {
                                    Object var17_24 = null;
                                    charBuffer.position(n2 - charBuffer.arrayOffset());
                                    byteBuffer.position(n - byteBuffer.arrayOffset());
                                    throw throwable;
                                }
                            }
                            byteBuffer.position(n - byteBuffer.arrayOffset());
                            return coderResult5;
                        }
                        Object var17_20 = null;
                        charBuffer.position(n2 - charBuffer.arrayOffset());
                        byteBuffer.position(n - byteBuffer.arrayOffset());
                        return coderResult4;
                    }
                    Object var17_21 = null;
                    charBuffer.position(n2 - charBuffer.arrayOffset());
                    byteBuffer.position(n - byteBuffer.arrayOffset());
                    return coderResult3;
                }
                Object var17_22 = null;
                charBuffer.position(n2 - charBuffer.arrayOffset());
                byteBuffer.position(n - byteBuffer.arrayOffset());
                return coderResult2;
            }
            Object var17_23 = null;
            charBuffer.position(n2 - charBuffer.arrayOffset());
            byteBuffer.position(n - byteBuffer.arrayOffset());
            return coderResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = 0;
            boolean bl = false;
            byte[] byArray = new byte[4];
            int n2 = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    int n3;
                    byte[] byArray2 = byArray;
                    char c = charBuffer.get();
                    if (Surrogate.is(c)) {
                        if (this.sgp.parse(c, charBuffer) < 0) {
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    n = this.encodeSingle(c, byArray2);
                    if (n == 0) {
                        n3 = this.encodeDouble(c);
                        if (n3 != 0) {
                            if ((n3 & 0xFF0000) == 0) {
                                byArray2[0] = (byte)((n3 & 0xFF00) >> 8);
                                byArray2[1] = (byte)(n3 & 0xFF);
                                n = 2;
                            }
                        } else {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    if (byteBuffer.remaining() < n) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    for (n3 = 0; n3 < n; ++n3) {
                        byteBuffer.put(byArray2[n3]);
                        ++n2;
                    }
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n2);
            }
        }

        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }
    }
}

