/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import sun.plugin.ConsoleWindow;
import sun.plugin.util.PluginSysAction;
import sun.plugin.util.PluginSysUtil;

public class MainConsoleWriter
implements Runnable {
    private LinkedList queue = new LinkedList();
    private ByteArrayOutputStream consoleBuffer = null;
    private OutputStream traceOutputStream;
    private ConsoleWindow console = null;
    private Object consoleSyncObject = new Object();
    static final /* synthetic */ boolean $assertionsDisabled;

    MainConsoleWriter(OutputStream outputStream) {
        this.traceOutputStream = outputStream;
        Thread thread = PluginSysUtil.createPluginSysThread(this, "Main Console Writer");
        thread.setDaemon(false);
        thread.setPriority(6);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConsoleWindow getJavaConsole() {
        Object object = this.consoleSyncObject;
        synchronized (object) {
            if (this.console == null) {
                try {
                    this.console = (ConsoleWindow)PluginSysUtil.execute(new PluginSysAction(){

                        public Object execute() throws Exception {
                            return new ConsoleWindow();
                        }
                    });
                }
                catch (Exception exception) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    return null;
                }
                if (this.consoleBuffer != null) {
                    byte[] byArray = this.consoleBuffer.toByteArray();
                    this.console.append(new String(byArray));
                    this.consoleBuffer = null;
                }
            }
            return this.console;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            byte[] byArray = null;
            try {
                LinkedList linkedList = this.queue;
                synchronized (linkedList) {
                    if (this.queue.size() > 0) {
                        byArray = (byte[])this.queue.remove(0);
                    } else {
                        this.queue.wait();
                    }
                }
                if (byArray == null) continue;
                this.trace(byArray);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enQueue(byte[] byArray) {
        try {
            LinkedList linkedList = this.queue;
            synchronized (linkedList) {
                this.queue.addLast(byArray);
                this.queue.notifyAll();
            }
        }
        catch (Exception exception) {
            this.writeToConsole(exception.toString());
        }
    }

    private void writeToConsole(String string) {
        this.writeToConsole(string.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToConsole(byte[] byArray) {
        Object object = this.consoleSyncObject;
        synchronized (object) {
            if (this.console != null) {
                this.console.append(new String(byArray));
            } else {
                if (this.consoleBuffer == null) {
                    this.consoleBuffer = new ByteArrayOutputStream();
                }
                this.consoleBuffer.write(byArray, 0, byArray.length);
            }
        }
    }

    private void trace(byte[] byArray) {
        try {
            this.writeToConsole(byArray);
            this.traceOutputStream.write(byArray);
            this.traceOutputStream.flush();
        }
        catch (Exception exception) {
            this.console.append(exception.toString());
        }
    }

    static {
        $assertionsDisabled = !MainConsoleWriter.class.desiredAssertionStatus();
    }
}

