/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import sun.applet.AppletClassLoader;
import sun.net.www.ParseUtil;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.security.TrustDecider;
import sun.plugin.util.ProgressTracker;
import sun.plugin.util.Trace;

public final class PluginClassLoader
extends AppletClassLoader {
    private static RuntimePermission usePolicyPermission;
    private URL base;
    private HashMap JARJARtoJAR = new HashMap();

    public PluginClassLoader(URL uRL) {
        super(uRL);
        this.base = uRL;
    }

    public URL getBaseURL() {
        return this.base;
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Object object;
        Object object2;
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        URL uRL = codeSource.getLocation();
        if (uRL != null && uRL.getProtocol().equals("file") && (object2 = ParseUtil.decode(uRL.getFile())) != null) {
            object2 = ((String)object2).replace('/', File.separatorChar);
            object = File.separator + System.getProperty("java.home") + File.separator + "axbridge" + File.separator + "lib";
            try {
                object2 = new File((String)object2).getCanonicalPath();
                object = new File((String)object).getCanonicalPath();
                if (object2 != null && object != null && ((String)object2).startsWith((String)object)) {
                    permissionCollection.add(new AllPermission());
                    return permissionCollection;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object2 = null;
        object = (Policy)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Policy.getPolicy();
            }
        });
        object2 = ((Policy)object).getPermissions(codeSource);
        permissionCollection.add(new RuntimePermission("accessClassInPackage.sun.audio"));
        permissionCollection.add(new PropertyPermission("browser", "read"));
        permissionCollection.add(new PropertyPermission("browser.version", "read"));
        permissionCollection.add(new PropertyPermission("browser.vendor", "read"));
        permissionCollection.add(new PropertyPermission("http.agent", "read"));
        permissionCollection.add(new PropertyPermission("javaplugin.version", "read"));
        if (usePolicyPermission == null) {
            usePolicyPermission = new RuntimePermission("usePolicy");
        }
        if (!((PermissionCollection)object2).implies(usePolicyPermission) && codeSource.getCertificates() != null) {
            try {
                if (TrustDecider.isAllPermissionGranted(codeSource)) {
                    permissionCollection.add(new AllPermission());
                }
            }
            catch (CertificateExpiredException certificateExpiredException) {
                Trace.securityPrintException(certificateExpiredException, ResourceHandler.getMessage("rsa.cert_expired"), ResourceHandler.getMessage("security_dialog.caption"));
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                Trace.securityPrintException(certificateNotYetValidException, ResourceHandler.getMessage("rsa.cert_notyieldvalid"), ResourceHandler.getMessage("security_dialog.caption"));
            }
            catch (Exception exception) {
                Trace.securityPrintException(exception, ResourceHandler.getMessage("rsa.general_error"), ResourceHandler.getMessage("security_dialog.caption"));
            }
        }
        return permissionCollection;
    }

    public void addLocalJar(URL uRL) {
        this.addURL(uRL);
    }

    public Enumeration findResources(String string) throws IOException {
        return this.findResourcesByURLPath(string);
    }

    private Enumeration findResourcesByURLPath(String string) throws IOException {
        if (string != null && string.indexOf("META-INF/services/javax.sound") != -1) {
            return new Enumeration(){

                public Object nextElement() {
                    throw new NoSuchElementException();
                }

                public boolean hasMoreElements() {
                    return false;
                }
            };
        }
        return super.findResources(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addJar(String string) throws IOException {
        if (string.toUpperCase().endsWith(".JARJAR") && this.base.getProtocol().equalsIgnoreCase("file")) {
            String string2 = this.base.toString() + string;
            if (this.JARJARtoJAR.containsKey(string2)) return;
            ZipFile zipFile = null;
            File file = null;
            boolean bl = false;
            try {
                boolean bl2;
                FileOutputStream fileOutputStream;
                FilterOutputStream filterOutputStream;
                BufferedInputStream bufferedInputStream;
                block19: {
                    zipFile = new JarFile(this.base.getPath() + string, true);
                    Enumeration<JarEntry> enumeration = ((JarFile)zipFile).entries();
                    int n = 0;
                    if (!enumeration.hasMoreElements()) {
                        throw new IOException("Invalid jarjar file");
                    }
                    JarEntry jarEntry = null;
                    while (enumeration.hasMoreElements()) {
                        jarEntry = enumeration.nextElement();
                        if (jarEntry.toString().toUpperCase().startsWith("META-INF/")) continue;
                        if (!jarEntry.toString().toUpperCase().endsWith(".JAR")) {
                            throw new IOException("Invalid entry in jarjar file.");
                        }
                        if (++n <= 1) continue;
                    }
                    if (n > 1) {
                        jarEntry = null;
                        throw new IOException("Multiple JAR files inside JARJAR file");
                    }
                    byte[] byArray = new byte[8192];
                    bufferedInputStream = null;
                    filterOutputStream = null;
                    fileOutputStream = null;
                    InputStream inputStream = ((JarFile)zipFile).getInputStream(jarEntry);
                    bl2 = false;
                    try {
                        URL uRL;
                        int n2;
                        file = File.createTempFile(jarEntry.toString().substring(0, jarEntry.toString().lastIndexOf(46)), ".jar");
                        Trace.msgPrintln("pluginclassloader.created_file", new Object[]{file.getPath()});
                        ProgressTracker.onProgressComplete(this.base.toString() + string);
                        bufferedInputStream = new BufferedInputStream(inputStream);
                        fileOutputStream = new FileOutputStream(file);
                        filterOutputStream = new BufferedOutputStream(fileOutputStream);
                        while ((n2 = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
                            ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n2);
                        }
                        ((BufferedOutputStream)filterOutputStream).flush();
                        this.JARJARtoJAR.put(this.base.toString() + string, file);
                        bl2 = true;
                        try {
                            uRL = file.toURL();
                        }
                        catch (MalformedURLException malformedURLException) {
                            throw new IllegalArgumentException("name");
                        }
                        this.addURL(uRL);
                        Object var19_18 = null;
                        if (bufferedInputStream == null) break block19;
                    }
                    catch (Throwable throwable) {
                        Object var19_19 = null;
                        if (bufferedInputStream != null) {
                            bufferedInputStream.close();
                        }
                        if (filterOutputStream != null) {
                            filterOutputStream.close();
                        }
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        bufferedInputStream = null;
                        filterOutputStream = null;
                        fileOutputStream = null;
                        if (bl2) throw throwable;
                        Trace.msgPrintln("pluginclassloader.empty_file", new Object[]{file.getName()});
                        if (file == null) throw throwable;
                        file.delete();
                        throw throwable;
                    }
                    bufferedInputStream.close();
                }
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                bufferedInputStream = null;
                filterOutputStream = null;
                fileOutputStream = null;
                if (bl2) return;
                Trace.msgPrintln("pluginclassloader.empty_file", new Object[]{file.getName()});
                if (file == null) return;
                file.delete();
                return;
            }
            finally {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
        }
        super.addJar(string);
        if (!this.base.getProtocol().equalsIgnoreCase("file")) return;
        ProgressTracker.onProgressComplete(this.base.toString() + string);
    }

    protected void release() {
        if (!this.JARJARtoJAR.isEmpty()) {
            Trace.msgPrintln("pluginclassloader.deleting_files");
            Set set = this.JARJARtoJAR.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                File file = (File)this.JARJARtoJAR.get(k);
                if (file == null) continue;
                Trace.msgPrintln("pluginclassloader.file", new Object[]{file.getPath()});
                file.delete();
            }
            this.JARJARtoJAR.clear();
        }
        super.release();
    }
}

