/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui.player;

import com.sun.javaws.LocalApplicationProperties;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.Resources;
import com.sun.javaws.cache.CachedApplication;
import com.sun.javaws.cache.InstallCache;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.ui.player.EntryManager;
import com.sun.javaws.ui.player.JNLEntry;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.SwingUtilities;

public class CacheEntryManager
extends EntryManager {
    private ArrayList _entries = new ArrayList();
    private static final int SLEEP_DELAY = 10000;

    public int size() {
        return this._entries.size();
    }

    public CacheEntryManager() {
        new Thread(new CacheChecker()).start();
    }

    public void refresh() {
        Iterator iterator;
        JNLEntry jNLEntry = this.getSelectedEntry();
        URL uRL = jNLEntry != null ? jNLEntry.getCodebase() : null;
        this.setSelectedIndex(-1);
        this._entries.clear();
        InstallCache installCache = InstallCache.getCache();
        if (installCache != null && (iterator = installCache.getCachedApplications()) != null) {
            while (iterator.hasNext()) {
                InformationDesc informationDesc;
                CachedApplication cachedApplication = (CachedApplication)iterator.next();
                LaunchDesc launchDesc = cachedApplication.getLaunchDescriptor();
                if (launchDesc == null || launchDesc.getLaunchType() != 1 && launchDesc.getLaunchType() != 2 || (informationDesc = launchDesc.getInformation()) == null) continue;
                URL uRL2 = cachedApplication.getCodebase();
                LocalApplicationProperties localApplicationProperties = cachedApplication.getLocalApplicationProperties();
                localApplicationProperties.refreshIfNecessary();
                this._entries.add(new JNLEntry(launchDesc, informationDesc, localApplicationProperties, uRL2, 0L));
            }
            Collections.sort(this._entries);
        }
        this.fireStateChanged();
        if (uRL != null) {
            this.selectEntryWithCodebase(uRL);
        }
        if (this.getSelectedIndex() == -1 && this.size() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public boolean canRemove() {
        return true;
    }

    public void remove(int n) {
        if (n >= 0 && n < this._entries.size()) {
            JNLEntry jNLEntry = this.get(n);
            LocalApplicationProperties localApplicationProperties = jNLEntry.getLocalApplicationProperties();
            LaunchDesc launchDesc = jNLEntry.getLaunchDescriptor();
            LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
            if (localApplicationProperties.isLocallyInstalled() && localInstallHandler != null) {
                localInstallHandler.uninstall(launchDesc, localApplicationProperties);
                try {
                    localApplicationProperties.store();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            InstallCache.getCache().remove(localApplicationProperties, launchDesc);
            this._entries.remove(n);
            super.remove(n);
        }
    }

    public JNLEntry get(int n) {
        return (JNLEntry)this._entries.get(n);
    }

    public String getRemoveString() {
        return Resources.getString("player.CacheEntryManager.remove");
    }

    private class CacheChecker
    implements Runnable {
        private long _lastTime = InstallCache.getCache().getLastAccessed();

        public void run() {
            boolean bl = false;
            while (!bl) {
                long l;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
                if ((l = InstallCache.getCache().getLastAccessed()) == this._lastTime) continue;
                this._lastTime = l;
                if (Globals.TraceCacheEntryManager) {
                    Debug.println("Date stamp changed: updating");
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ CacheChecker this$1;

                    public void run() {
                        CacheChecker.access$000(this.this$1).refresh();
                    }
                    {
                        this.this$1 = cacheChecker;
                    }
                });
            }
        }

        CacheChecker() {
        }

        static /* synthetic */ CacheEntryManager access$000(CacheChecker cacheChecker) {
            return cacheChecker.CacheEntryManager.this;
        }
    }
}

