/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.xml;

import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.exceptions.JNLParseException;
import com.sun.javaws.xml.XMLAttribute;
import com.sun.javaws.xml.XMLNode;

public class XMLParser {
    public XMLNode _root;
    public String _source;
    public String _current;
    public int _tokenType;
    public String _tokenData;
    public static final int TOKEN_EOF = 1;
    public static final int TOKEN_END_TAG = 2;
    public static final int TOKEN_BEGIN_TAG = 3;
    public static final int TOKEN_CLOSE_TAG = 4;
    public static final int TOKEN_EMPTY_CLOSE_TAG = 5;
    public static final int TOKEN_PCDATA = 6;
    private static final String PCDStart = "<![CDATA[";
    private static final String PCDEnd = "]]>";

    private int getLineNumber() {
        int n = this._current == null ? this._source.length() : this._source.indexOf(this._current);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n && n3 != -1) {
            if ((n3 = this._source.indexOf("\n", n3)) < 0) continue;
            ++n3;
            ++n2;
        }
        return n2;
    }

    private boolean legalTokenChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == ':' || c == '.' || c == '-';
    }

    private boolean legalTokenStartChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'a' && c <= 'Z' || c == '_' || c == ':';
    }

    public XMLNode parse() throws JNLParseException {
        try {
            this.nextToken(this._current);
            this._root = this.parseXMLElement(this._current);
        }
        catch (NullPointerException nullPointerException) {
            if (Globals.TraceXMLParsing) {
                Debug.println("NULL Pointer Exception: " + nullPointerException);
            }
            throw new JNLParseException(this._source, nullPointerException, "wrong kind of token found", this.getLineNumber());
        }
        catch (JNLParseException jNLParseException) {
            if (Globals.TraceXMLParsing) {
                Debug.println("JNLP Parse Exception: " + jNLParseException);
            }
            throw jNLParseException;
        }
        if (Globals.TraceXMLParsing) {
            Debug.println("\n\nreturning ROOT as follows:\n" + this._root);
        }
        return this._root;
    }

    public XMLParser(String string) {
        if (Globals.TraceXMLParsing) {
            Debug.println("new XMLParser with source:");
            Debug.println(string);
        }
        this._source = this._current = string;
        this._root = null;
        this._tokenData = null;
    }

    private void nextToken(String string) {
        this._current = this.skipFilling(string);
        if (this._current == null) {
            this._tokenType = 1;
        } else if (this._current.startsWith("</")) {
            this._tokenType = 2;
            this._current = this.skipXMLName(this.skipForward(this._current, 2, 0));
        } else if (this._current.startsWith("<")) {
            this._tokenType = 3;
            this._current = this.skipXMLName(this.skipForward(this._current, 1, 0));
        } else if (this._current.startsWith(">")) {
            this._tokenType = 4;
            this._current = this.skipForward(this._current, 1, 0);
        } else if (this._current.startsWith("/>")) {
            this._tokenType = 5;
            this._current = this.skipForward(this._current, 2, 0);
        } else {
            this._tokenType = 6;
            this._current = this.skipPCData(string, '<');
        }
    }

    private XMLAttribute parseXMLAttribute(String string) throws JNLParseException {
        String string2;
        if (string == null) {
            return null;
        }
        this._current = this.skipFilling(string);
        if (this._current == null || this._current.startsWith(">") || this._current.startsWith("/>")) {
            return null;
        }
        this._current = this.skipAttributeName(this._current);
        String string3 = this._tokenData;
        this._current = this.skipFilling(this._current);
        if (!this._current.startsWith("=")) {
            if (string.equals(this._current)) {
                this._current = this.skipForward(this._current, 1, 0);
            }
            return this.parseXMLAttribute(this._current);
        }
        this._current = this.skipForward(this._current, 1, 0);
        this._current = this.skipWhitespace(this._current);
        if (this._current.startsWith("\"") || this._current.startsWith("'")) {
            char c = this._current.charAt(0);
            this._current = this.skipForward(this._current, 1, 0);
            this._current = this.skipPCData(this._current, c);
            string2 = this._tokenData;
            this._current = this.skipForward(this._current, 1, 0);
        } else {
            this._current = this.skipNonSpace(this._current);
            string2 = this._tokenData;
        }
        if (string2 != null) {
            string2 = string2.trim();
        }
        return new XMLAttribute(string3, string2);
    }

    private XMLNode parseXMLElement(String string) throws JNLParseException {
        if (this._tokenType == 3) {
            XMLAttribute xMLAttribute;
            String string2 = this._tokenData;
            XMLAttribute xMLAttribute2 = xMLAttribute = this.parseXMLAttribute(this._current);
            while (xMLAttribute2 != null) {
                XMLAttribute xMLAttribute3 = this.parseXMLAttribute(this._current);
                xMLAttribute2.setNext(xMLAttribute3);
                xMLAttribute2 = xMLAttribute3;
            }
            XMLNode xMLNode = new XMLNode(string2, xMLAttribute);
            this.nextToken(this._current);
            if (this._tokenType != 5 && this._tokenType != 4 && this._tokenType != 1) {
                throw new JNLParseException(this._source, null, "wrong kind of token found", this.getLineNumber());
            }
            if (this._tokenType == 5) {
                this.nextToken(this._current);
            } else if (this._tokenType == 4) {
                this.nextToken(this._current);
                XMLNode xMLNode2 = this.parseXMLElement(this._current);
                if (xMLNode2 != null) {
                    xMLNode.setNested(xMLNode2);
                    xMLNode2.setParent(xMLNode);
                }
                if (this._tokenType == 2) {
                    do {
                        this.nextToken(this._current);
                    } while (this._tokenType != 1 && this._tokenType != 4);
                    this.nextToken(this._current);
                }
            }
            if (this._tokenType != 1) {
                XMLNode xMLNode3 = this.parseXMLElement(this._current);
                xMLNode.setNext(xMLNode3);
            }
            return xMLNode;
        }
        if (this._tokenType == 6) {
            XMLNode xMLNode = new XMLNode(this._tokenData);
            this.nextToken(this._current);
            return xMLNode;
        }
        return null;
    }

    private String skipAttributeName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("=");
        if (n >= 0) {
            this._tokenData = string.substring(0, n);
            if (this._tokenData != null) {
                this._tokenData = this._tokenData.trim();
            }
        } else {
            this._tokenData = null;
        }
        return this.skipForward(string, n, 0);
    }

    private String skipFilling(String string) {
        String string2;
        String string3 = string;
        do {
            string2 = string3;
            string3 = this.skipWhitespace(string3);
            string3 = this.skipXMLComment(string3);
            string3 = this.skipXMLDocType(string3);
        } while ((string3 = this.skipXMLProlog(string3)) != string2);
        return string3;
    }

    private String skipNonSpace(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        for (n = 0; n < n2 && !Character.isWhitespace(string.charAt(n)); ++n) {
        }
        return this.skipPCData(string, string.charAt(n));
    }

    private String skipWhitespace(String string) {
        int n;
        if (string == null) {
            return null;
        }
        for (n = 0; n < string.length() && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        return string.substring(n);
    }

    private String skipXMLComment(String string) {
        if (string != null && string.startsWith("<!--")) {
            int n = string.indexOf("-->", 4);
            return this.skipForward(string, n, 3);
        }
        return string;
    }

    private String skipXMLDocType(String string) {
        if (string != null && string.startsWith("<!")) {
            int n = string.indexOf(">", 2);
            return this.skipForward(string, n, 1);
        }
        return string;
    }

    private String skipXMLName(String string) {
        int n = 0;
        if (string == null) {
            return null;
        }
        if (this.legalTokenStartChar(string.charAt(0))) {
            for (n = 1; n < string.length() && this.legalTokenChar(string.charAt(n)); ++n) {
            }
        }
        this._tokenData = string.substring(0, n);
        if (this._tokenData != null) {
            this._tokenData = this._tokenData.trim();
        }
        return this.skipForward(string, n, 0);
    }

    private String skipXMLProlog(String string) {
        if (string != null && string.startsWith("<?")) {
            int n = string.indexOf("?>", 2);
            return this.skipForward(string, n, 2);
        }
        return string;
    }

    private String skipPCData(String string, char c) {
        int n = string.indexOf(c);
        int n2 = string.indexOf(PCDStart);
        if (n >= 0) {
            if (n2 >= 0 && n2 <= n) {
                int n3;
                String string2 = string.substring(0, n2);
                String string3 = string.substring(n2 + PCDStart.length());
                if (string3 != null && (n3 = string3.indexOf(PCDEnd)) >= 0) {
                    String string4 = this.skipPCData(string3.substring(n3 + PCDEnd.length()), c);
                    this._tokenData = string2 + string3.substring(0, n3) + this._tokenData;
                    return string4;
                }
            }
            this._tokenData = string.substring(0, n);
            String string5 = n < string.length() ? string.substring(n) : null;
            return string5;
        }
        this._tokenData = this._current;
        return null;
    }

    private String skipForward(String string, int n, int n2) {
        if (n < 0 || n + n2 >= string.length()) {
            return null;
        }
        return string.substring(n + n2);
    }
}

