/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.BindingEnumeration;
import com.sun.jndi.dns.CT;
import com.sun.jndi.dns.DnsName;
import com.sun.jndi.dns.DnsNameParser;
import com.sun.jndi.dns.NameClassPairEnumeration;
import com.sun.jndi.dns.NameNode;
import com.sun.jndi.dns.Resolver;
import com.sun.jndi.dns.ResourceRecord;
import com.sun.jndi.dns.ResourceRecords;
import com.sun.jndi.dns.ZoneNode;
import com.sun.jndi.toolkit.ctx.ComponentDirContext;
import com.sun.jndi.toolkit.ctx.Continuation;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.spi.DirectoryManager;

public class DnsContext
extends ComponentDirContext {
    DnsName domain;
    Hashtable environment;
    private boolean envShared;
    private boolean parentIsDns;
    private String[] servers;
    private Resolver resolver;
    private boolean authoritative;
    private boolean recursion;
    private int timeout;
    private int retries;
    static final NameParser nameParser = new DnsNameParser();
    private static final int DEFAULT_INIT_TIMEOUT = 1000;
    private static final int DEFAULT_RETRIES = 4;
    private static final String INIT_TIMEOUT = "com.sun.jndi.dns.timeout.initial";
    private static final String RETRIES = "com.sun.jndi.dns.timeout.retries";
    private CT lookupCT;
    private static final String LOOKUP_ATTR = "com.sun.jndi.dns.lookup.attr";
    private static final String RECURSION = "com.sun.jndi.dns.recursion";
    private static final int ANY = 255;
    private static final ZoneNode zoneTree = new ZoneNode(null);
    public static boolean debug = false;

    public void close() {
    }

    private void initFromEnvironment() throws InvalidAttributeIdentifierException {
        this.lookupCT = this.getLookupCT((String)this.environment.get(LOOKUP_ATTR));
        this.authoritative = "true".equalsIgnoreCase((String)this.environment.get("java.naming.authoritative"));
        String string = (String)this.environment.get(RECURSION);
        this.recursion = string == null || "true".equalsIgnoreCase(string);
        string = (String)this.environment.get(INIT_TIMEOUT);
        this.timeout = string == null ? 1000 : Integer.parseInt(string);
        string = (String)this.environment.get(RETRIES);
        this.retries = string == null ? 4 : Integer.parseInt(string);
    }

    private static boolean classAndTypeMatch(int n2, int n3, CT[] cTArray) {
        if (cTArray == null) {
            return true;
        }
        for (int i2 = 0; i2 < cTArray.length; ++i2) {
            boolean bl2;
            CT cT = cTArray[i2];
            boolean bl3 = cT.rrclass == 255 || cT.rrclass == n2;
            boolean bl4 = bl2 = cT.rrtype == 255 || cT.rrtype == n3;
            if (!bl3 || !bl2) continue;
            return true;
        }
        return false;
    }

    private DnsContext(DnsContext dnsContext) {
        this.environment = dnsContext.environment;
        dnsContext.envShared = true;
        this.envShared = true;
        this.parentIsDns = dnsContext.parentIsDns;
        this.domain = dnsContext.domain;
        this.servers = dnsContext.servers;
        this.resolver = dnsContext.resolver;
        this.authoritative = dnsContext.authoritative;
        this.recursion = dnsContext.recursion;
        this.timeout = dnsContext.timeout;
        this.retries = dnsContext.retries;
        this.lookupCT = dnsContext.lookupCT;
    }

    private Resolver getResolver() throws NamingException {
        if (this.resolver == null) {
            this.resolver = new Resolver(this.servers, this.timeout, this.retries);
        }
        return this.resolver;
    }

    public String getNameInNamespace() {
        return this.domain.toString();
    }

    private static String toAttrId(int n2, int n3) {
        String string = ResourceRecord.getTypeName(n3);
        if (n2 != 1) {
            string = ResourceRecord.getRrclassName(n2) + " " + string;
        }
        return string;
    }

    private static final void dprint(String string) {
        if (debug) {
            System.err.println("** " + string);
        }
    }

    void setProviderUrl(String string) {
        this.environment.put("java.naming.provider.url", string);
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)this.environment.clone();
    }

    protected Hashtable p_getEnvironment() {
        return this.environment;
    }

    private static CT getClassAndTypeToQuery(CT[] cTArray) {
        int n2;
        int n3;
        if (cTArray == null) {
            n3 = 255;
            n2 = 255;
        } else if (cTArray.length == 0) {
            n3 = 1;
            n2 = 255;
        } else {
            n3 = cTArray[0].rrclass;
            n2 = cTArray[0].rrtype;
            for (int i2 = 1; i2 < cTArray.length; ++i2) {
                if (n3 != cTArray[i2].rrclass) {
                    n3 = 255;
                }
                if (n2 == cTArray[i2].rrtype) continue;
                n2 = 255;
            }
        }
        return new CT(n3, n2);
    }

    private static CT fromAttrId(String string) throws InvalidAttributeIdentifierException {
        String string2;
        int n2;
        if (string.equals("")) {
            throw new InvalidAttributeIdentifierException("Attribute ID cannot be empty");
        }
        int n3 = string.indexOf(32);
        if (n3 < 0) {
            n2 = 1;
        } else {
            string2 = string.substring(0, n3);
            n2 = ResourceRecord.getRrclass(string2);
            if (n2 < 0) {
                throw new InvalidAttributeIdentifierException("Unknown resource record class '" + string2 + '\'');
            }
        }
        string2 = string.substring(n3 + 1);
        int n4 = ResourceRecord.getType(string2);
        if (n4 < 0) {
            throw new InvalidAttributeIdentifierException("Unknown resource record type '" + string2 + '\'');
        }
        return new CT(n2, n4);
    }

    private CT getLookupCT(String string) throws InvalidAttributeIdentifierException {
        return string == null ? new CT(1, 16) : DnsContext.fromAttrId(string);
    }

    private static CT[] attrIdsToClassesAndTypes(String[] stringArray) throws InvalidAttributeIdentifierException {
        if (stringArray == null) {
            return null;
        }
        CT[] cTArray = new CT[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            cTArray[i2] = DnsContext.fromAttrId(stringArray[i2]);
        }
        return cTArray;
    }

    DnsContext(DnsContext dnsContext, DnsName dnsName) {
        this(dnsContext);
        this.domain = dnsName;
        this.parentIsDns = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isZoneCurrent(ZoneNode zoneNode, DnsName dnsName) throws NamingException {
        if (!zoneNode.isPopulated()) {
            return false;
        }
        ResourceRecord resourceRecord = this.getResolver().findSoa(dnsName, 1, this.recursion);
        ZoneNode zoneNode2 = zoneNode;
        synchronized (zoneNode2) {
            if (resourceRecord == null) {
                zoneNode.depopulate();
            }
            return zoneNode.isPopulated() && zoneNode.compareSerialNumberTo(resourceRecord) >= 0;
        }
    }

    DnsName fullyQualify(Name name) throws NamingException {
        DnsName dnsName;
        if (name.isEmpty()) {
            return this.domain;
        }
        DnsName dnsName2 = dnsName = name instanceof CompositeName ? new DnsName(name.get(0)) : (DnsName)new DnsName().addAll(name);
        if (dnsName.hasRootLabel()) {
            if (this.domain.size() == 1) {
                return dnsName;
            }
            throw new InvalidNameException("DNS name " + dnsName + " not relative to " + this.domain);
        }
        return (DnsName)dnsName.addAll(0, this.domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NameNode getNameNode(DnsName dnsName) throws NamingException {
        DnsName dnsName2;
        NameNode nameNode;
        ZoneNode zoneNode;
        ZoneNode zoneNode2;
        DnsContext.dprint("getNameNode(" + dnsName + ")");
        NameNode nameNode2 = zoneTree;
        synchronized (nameNode2) {
            zoneNode2 = zoneTree.getDeepestPopulated(dnsName);
        }
        DnsContext.dprint("Deepest related zone in zone tree: " + (zoneNode2 != null ? zoneNode2.getLabel() : "[none]"));
        if (zoneNode2 != null) {
            zoneNode = zoneNode2;
            synchronized (zoneNode) {
                nameNode2 = zoneNode2.getContents();
            }
            if (nameNode2 != null && (nameNode = nameNode2.get(dnsName, zoneNode2.depth() + 1)) != null && !nameNode.isZoneCut()) {
                DnsContext.dprint("Found node " + dnsName + " in zone tree");
                dnsName2 = (DnsName)dnsName.getPrefix(zoneNode2.depth() + 1);
                boolean bl2 = this.isZoneCurrent(zoneNode2, dnsName2);
                boolean bl3 = false;
                ZoneNode zoneNode3 = zoneNode2;
                synchronized (zoneNode3) {
                    if (nameNode2 != zoneNode2.getContents()) {
                        bl3 = true;
                    } else if (!bl2) {
                        zoneNode2.depopulate();
                    } else {
                        return nameNode;
                    }
                }
                DnsContext.dprint("Zone not current; discarding node");
                if (bl3) {
                    return this.getNameNode(dnsName);
                }
            }
        }
        DnsContext.dprint("Adding node " + dnsName + " to zone tree");
        dnsName2 = this.getResolver().findZoneName(dnsName, 1, this.recursion);
        DnsContext.dprint("Node's zone is " + dnsName2);
        zoneNode = zoneTree;
        synchronized (zoneNode) {
            zoneNode2 = (ZoneNode)zoneTree.add(dnsName2, 1);
        }
        zoneNode = zoneNode2;
        synchronized (zoneNode) {
            nameNode2 = zoneNode2.isPopulated() ? zoneNode2.getContents() : this.populateZone(zoneNode2, dnsName2);
        }
        nameNode = nameNode2.get(dnsName, dnsName2.size());
        if (nameNode == null) {
            throw new ConfigurationException("DNS error: node not found in its own zone");
        }
        DnsContext.dprint("Found node in newly-populated zone");
        return nameNode;
    }

    public void c_destroySubcontext(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public void c_unbind(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        if (string.equals(LOOKUP_ATTR)) {
            this.lookupCT = this.getLookupCT(null);
        } else if (string.equals("java.naming.authoritative")) {
            this.authoritative = false;
        } else if (string.equals(RECURSION)) {
            this.recursion = true;
        } else if (string.equals(INIT_TIMEOUT)) {
            if (this.timeout != 1000) {
                this.timeout = 1000;
                this.resolver = null;
            }
        } else if (string.equals(RETRIES) && this.retries != 4) {
            this.retries = 4;
            this.resolver = null;
        }
        if (!this.envShared) {
            return this.environment.remove(string);
        }
        if (this.environment.get(string) != null) {
            this.environment = (Hashtable)this.environment.clone();
            this.envShared = false;
            return this.environment.remove(string);
        }
        return null;
    }

    private NameNode populateZone(ZoneNode zoneNode, DnsName dnsName) throws NamingException {
        DnsContext.dprint("Populating zone " + dnsName);
        ResourceRecords resourceRecords = this.getResolver().queryZone(dnsName, 1, this.recursion);
        DnsContext.dprint("zone xfer complete: " + resourceRecords.answer.size() + " records");
        return zoneNode.populate(dnsName, resourceRecords);
    }

    public void c_bind(Name name, Object object, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public void c_rebind(Name name, Object object, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public void c_rename(Name name, Name name2, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public void c_modifyAttributes(Name name, int n2, Attributes attributes, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public void c_modifyAttributes(Name name, ModificationItem[] modificationItemArray, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public Object c_lookup(Name name, Continuation continuation) throws NamingException {
        continuation.setSuccess();
        if (name.isEmpty()) {
            DnsContext dnsContext = new DnsContext(this);
            dnsContext.resolver = new Resolver(this.servers, this.timeout, this.retries);
            return dnsContext;
        }
        try {
            DnsName dnsName = this.fullyQualify(name);
            ResourceRecords resourceRecords = this.getResolver().query(dnsName, this.lookupCT.rrclass, this.lookupCT.rrtype, this.recursion, this.authoritative);
            Attributes attributes = DnsContext.rrsToAttrs(resourceRecords, null);
            DnsContext dnsContext = new DnsContext(this, dnsName);
            return DirectoryManager.getObjectInstance(dnsContext, name, this, this.environment, attributes);
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, name);
            throw continuation.fillInException(namingException);
        }
        catch (Exception exception) {
            continuation.setError((Object)this, name);
            NamingException namingException = new NamingException("Problem generating object using object factory");
            namingException.setRootCause(exception);
            throw continuation.fillInException(namingException);
        }
    }

    public Object c_lookupLink(Name name, Continuation continuation) throws NamingException {
        return this.c_lookup(name, continuation);
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        int n2;
        if (string.equals(LOOKUP_ATTR)) {
            this.lookupCT = this.getLookupCT((String)object);
        } else if (string.equals("java.naming.authoritative")) {
            this.authoritative = "true".equalsIgnoreCase((String)object);
        } else if (string.equals(RECURSION)) {
            this.recursion = "true".equalsIgnoreCase((String)object);
        } else if (string.equals(INIT_TIMEOUT)) {
            int n3 = Integer.parseInt((String)object);
            if (this.timeout != n3) {
                this.timeout = n3;
                this.resolver = null;
            }
        } else if (string.equals(RETRIES) && this.retries != (n2 = Integer.parseInt((String)object))) {
            this.retries = n2;
            this.resolver = null;
        }
        if (!this.envShared) {
            return this.environment.put(string, object);
        }
        if (this.environment.get(string) != object) {
            this.environment = (Hashtable)this.environment.clone();
            this.envShared = false;
            return this.environment.put(string, object);
        }
        return object;
    }

    public DnsContext(String string, String[] stringArray, Hashtable hashtable) throws NamingException {
        this.domain = new DnsName(string.endsWith(".") ? string : string + ".");
        this.servers = stringArray;
        this.environment = (Hashtable)hashtable.clone();
        this.envShared = false;
        this.parentIsDns = false;
        this.resolver = null;
        this.initFromEnvironment();
    }

    public Context c_createSubcontext(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        if (!(name2 instanceof DnsName) && !(name2 instanceof CompositeName)) {
            name2 = new DnsName().addAll(name2);
        }
        if (!(name instanceof DnsName) && !(name instanceof CompositeName)) {
            name = new DnsName().addAll(name);
        }
        if (name2 instanceof DnsName && name instanceof DnsName) {
            DnsName dnsName = (DnsName)name2.clone();
            dnsName.addAll(name);
            return new CompositeName().add(((Object)dnsName).toString());
        }
        Name name3 = name2 instanceof CompositeName ? name2 : new CompositeName().add(name2.toString());
        Name name4 = name instanceof CompositeName ? name : new CompositeName().add(name.toString());
        int n2 = name3.size() - 1;
        if (name4.isEmpty() || name4.get(0).equals("") || name3.isEmpty() || name3.get(n2).equals("")) {
            return super.composeName(name4, name3);
        }
        Name name5 = name2 == name3 ? (CompositeName)name3.clone() : name3;
        name5.addAll(name4);
        if (this.parentIsDns) {
            DnsName dnsName = name2 instanceof DnsName ? (DnsName)name2.clone() : new DnsName(name3.get(n2));
            dnsName.addAll(name instanceof DnsName ? name : new DnsName(name4.get(0)));
            name5.remove(n2 + 1);
            name5.remove(n2);
            name5.add(n2, dnsName.toString());
        }
        return name5;
    }

    public NameParser c_getNameParser(Name name, Continuation continuation) throws NamingException {
        continuation.setSuccess();
        return nameParser;
    }

    public NamingEnumeration c_list(Name name, Continuation continuation) throws NamingException {
        continuation.setSuccess();
        try {
            DnsName dnsName = this.fullyQualify(name);
            NameNode nameNode = this.getNameNode(dnsName);
            return new NameClassPairEnumeration(nameNode.getChildren());
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, name);
            throw continuation.fillInException(namingException);
        }
    }

    public NamingEnumeration c_listBindings(Name name, Continuation continuation) throws NamingException {
        continuation.setSuccess();
        try {
            DnsName dnsName = this.fullyQualify(name);
            NameNode nameNode = this.getNameNode(dnsName);
            DnsContext dnsContext = new DnsContext(this, dnsName);
            return new BindingEnumeration(dnsContext, nameNode.getChildren());
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, name);
            throw continuation.fillInException(namingException);
        }
    }

    private static Attributes rrsToAttrs(ResourceRecords resourceRecords, CT[] cTArray) {
        BasicAttributes basicAttributes = new BasicAttributes(true);
        for (int i2 = 0; i2 < resourceRecords.answer.size(); ++i2) {
            ResourceRecord resourceRecord = (ResourceRecord)resourceRecords.answer.elementAt(i2);
            int n2 = resourceRecord.getType();
            int n3 = resourceRecord.getRrclass();
            if (!DnsContext.classAndTypeMatch(n3, n2, cTArray)) continue;
            String string = DnsContext.toAttrId(n3, n2);
            Attribute attribute = basicAttributes.get(string);
            if (attribute == null) {
                attribute = new BasicAttribute(string);
                basicAttributes.put(attribute);
            }
            attribute.add(resourceRecord.getRdata());
        }
        return basicAttributes;
    }

    public DirContext c_getSchema(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public DirContext c_getSchemaClassDefinition(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public void c_bind(Name name, Object object, Attributes attributes, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public void c_rebind(Name name, Object object, Attributes attributes, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public Attributes c_getAttributes(Name name, String[] stringArray, Continuation continuation) throws NamingException {
        continuation.setSuccess();
        try {
            DnsName dnsName = this.fullyQualify(name);
            CT[] cTArray = DnsContext.attrIdsToClassesAndTypes(stringArray);
            CT cT = DnsContext.getClassAndTypeToQuery(cTArray);
            ResourceRecords resourceRecords = this.getResolver().query(dnsName, cT.rrclass, cT.rrtype, this.recursion, this.authoritative);
            return DnsContext.rrsToAttrs(resourceRecords, cTArray);
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, name);
            throw continuation.fillInException(namingException);
        }
    }

    public DirContext c_createSubcontext(Name name, Attributes attributes, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public NamingEnumeration c_search(Name name, Attributes attributes, String[] stringArray, Continuation continuation) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration c_search(Name name, String string, SearchControls searchControls, Continuation continuation) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration c_search(Name name, String string, Object[] objectArray, SearchControls searchControls, Continuation continuation) throws NamingException {
        throw new OperationNotSupportedException();
    }
}

