/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SMFParser;
import com.sun.media.sound.SunMidiFileReader;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.Sequence;

public class StandardMidiFileReader
extends SunMidiFileReader {
    private static final int MThd_MAGIC = 1297377380;
    private static final int MIDI_TYPE_0 = 0;
    private static final int MIDI_TYPE_1 = 1;
    private static final int bisBufferSize = 1024;
    public static final int[] types = new int[]{0, 1};

    public MidiFileFormat getMidiFileFormat(File file) throws InvalidMidiDataException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 1024);
        long l2 = file.length();
        if (l2 > Integer.MAX_VALUE) {
            l2 = -1L;
        }
        MidiFileFormat midiFileFormat = this.getMidiFileFormatFromStream(bufferedInputStream, (int)l2, null);
        bufferedInputStream.close();
        return midiFileFormat;
    }

    public MidiFileFormat getMidiFileFormat(InputStream inputStream) throws InvalidMidiDataException, IOException {
        return this.getMidiFileFormatFromStream(inputStream, -1, null);
    }

    public MidiFileFormat getMidiFileFormat(URL uRL) throws InvalidMidiDataException, IOException {
        InputStream inputStream = uRL.openStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 1024);
        MidiFileFormat midiFileFormat = this.getMidiFileFormat(bufferedInputStream);
        bufferedInputStream.close();
        return midiFileFormat;
    }

    public Sequence getSequence(File file) throws InvalidMidiDataException, IOException {
        InputStream inputStream = new FileInputStream(file);
        inputStream = new BufferedInputStream(inputStream, 1024);
        Sequence sequence = this.getSequence(inputStream);
        inputStream.close();
        return sequence;
    }

    public Sequence getSequence(InputStream inputStream) throws InvalidMidiDataException, IOException {
        SMFParser sMFParser = new SMFParser(inputStream);
        MidiFileFormat midiFileFormat = this.getMidiFileFormatFromStream(inputStream, -1, sMFParser);
        if (midiFileFormat.getType() != 0 && midiFileFormat.getType() != 1) {
            throw new InvalidMidiDataException("Invalid or unsupported file type: " + midiFileFormat.getType());
        }
        Sequence sequence = new Sequence(midiFileFormat.getDivisionType(), midiFileFormat.getResolution());
        for (int i2 = 0; i2 < sMFParser.tracks; ++i2) {
            sMFParser.nextTrack();
            sMFParser.readTrack(sequence.createTrack());
        }
        return sequence;
    }

    public Sequence getSequence(URL uRL) throws InvalidMidiDataException, IOException {
        InputStream inputStream = uRL.openStream();
        inputStream = new BufferedInputStream(inputStream, 1024);
        Sequence sequence = this.getSequence(inputStream);
        inputStream.close();
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MidiFileFormat getMidiFileFormatFromStream(InputStream inputStream, int n2, SMFParser sMFParser) throws InvalidMidiDataException, IOException {
        int n3;
        float f2;
        short s2;
        int n4 = 16;
        int n5 = -1;
        DataInputStream dataInputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        if (sMFParser == null) {
            dataInputStream.mark(n4);
        }
        try {
            int n6 = dataInputStream.readInt();
            if (n6 != 1297377380) {
                throw new InvalidMidiDataException("not a valid MIDI file");
            }
            int n7 = dataInputStream.readInt() - 6;
            s2 = dataInputStream.readShort();
            short s3 = dataInputStream.readShort();
            int n8 = dataInputStream.readShort();
            if (n8 > 0) {
                f2 = 0.0f;
                n3 = n8;
            } else {
                int n9 = -1 * n8 >> 8;
                switch (n9) {
                    case 24: {
                        f2 = 24.0f;
                        break;
                    }
                    case 25: {
                        f2 = 25.0f;
                        break;
                    }
                    case 29: {
                        f2 = 29.97f;
                        break;
                    }
                    case 30: {
                        f2 = 30.0f;
                        break;
                    }
                    default: {
                        throw new InvalidMidiDataException("Unknown frame code: " + n9);
                    }
                }
                n3 = n8 & 0xFF;
            }
            if (sMFParser != null) {
                dataInputStream.skip(n7);
                sMFParser.tracks = s3;
            }
        }
        finally {
            if (sMFParser == null) {
                dataInputStream.reset();
            }
        }
        MidiFileFormat midiFileFormat = new MidiFileFormat(s2, f2, n3, n2, n5);
        return midiFileFormat;
    }
}

