/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SunMidiFileWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.SequenceInputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;

public class StandardMidiFileWriter
extends SunMidiFileWriter {
    private static final int MThd_MAGIC = 1297377380;
    private static final int MTrk_MAGIC = 1297379947;
    private static final int ONE_BYTE = 1;
    private static final int TWO_BYTE = 2;
    private static final int SYSEX = 3;
    private static final int META = 4;
    private static final int MIDI_TYPE_0 = 0;
    private static final int MIDI_TYPE_1 = 1;
    private static final int bufferSize = 16384;
    private DataOutputStream tddos;
    public static final int[] types = new int[]{0, 1};
    private static final long mask = 127L;

    public int[] getMidiFileTypes() {
        int[] nArray = new int[types.length];
        System.arraycopy(types, 0, nArray, 0, types.length);
        return nArray;
    }

    private int getType(int n2) throws InvalidMidiDataException {
        if ((n2 & 0xF0) == 240) {
            switch (n2) {
                case 240: 
                case 247: {
                    return 3;
                }
                case 255: {
                    return 4;
                }
            }
            throw new InvalidMidiDataException("Invalid status byte: " + n2);
        }
        switch (n2 & 0xF0) {
            case 128: 
            case 144: 
            case 160: 
            case 176: 
            case 224: {
                return 2;
            }
            case 192: 
            case 208: {
                return 1;
            }
        }
        throw new InvalidMidiDataException("Invalid status byte: " + n2);
    }

    public boolean isFileTypeSupported(int n2) {
        for (int i2 = 0; i2 < types.length; ++i2) {
            if (n2 != types[i2]) continue;
            return true;
        }
        return false;
    }

    private int writeVarInt(long l2) throws IOException {
        int n2;
        int n3 = 1;
        for (n2 = 63; n2 > 0 && (l2 & 127L << n2) == 0L; n2 -= 7) {
        }
        while (n2 > 0) {
            this.tddos.writeByte((int)((l2 & 127L << n2) >> n2 | 0x80L));
            n2 -= 7;
            ++n3;
        }
        this.tddos.writeByte((int)(l2 & 0x7FL));
        return n3;
    }

    public int[] getMidiFileTypes(Sequence sequence) {
        Track[] trackArray = sequence.getTracks();
        int[] nArray = trackArray.length == 1 ? new int[]{0, 1} : new int[]{1};
        return nArray;
    }

    public int write(Sequence sequence, int n2, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        int n3 = this.write(sequence, n2, fileOutputStream);
        fileOutputStream.close();
        return n3;
    }

    private InputStream getFileStream(int n2, Sequence sequence) throws IOException {
        int n3;
        int n4;
        Track[] trackArray = sequence.getTracks();
        int n5 = 0;
        int n6 = 14;
        int n7 = 0;
        PipedOutputStream pipedOutputStream = null;
        DataOutputStream dataOutputStream = null;
        PipedInputStream pipedInputStream = null;
        InputStream[] inputStreamArray = null;
        InputStream inputStream = null;
        SequenceInputStream sequenceInputStream = null;
        if (n2 == 0) {
            if (trackArray.length != 1) {
                return null;
            }
        } else if (n2 == 1) {
            if (trackArray.length < 1) {
                return null;
            }
        } else if (trackArray.length == 1) {
            n2 = 0;
        } else if (trackArray.length > 1) {
            n2 = 1;
        } else {
            return null;
        }
        inputStreamArray = new InputStream[trackArray.length];
        for (n4 = 0; n4 < trackArray.length; ++n4) {
            try {
                inputStreamArray[n4] = this.writeTrack(trackArray[n4], n2);
                continue;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                // empty catch block
            }
        }
        if (trackArray.length == 1) {
            inputStream = inputStreamArray[0];
        } else if (trackArray.length > 1) {
            inputStream = inputStreamArray[0];
            for (n4 = 1; n4 < trackArray.length; ++n4) {
                inputStream = new SequenceInputStream(inputStream, inputStreamArray[n4]);
            }
        }
        pipedOutputStream = new PipedOutputStream();
        dataOutputStream = new DataOutputStream(pipedOutputStream);
        pipedInputStream = new PipedInputStream(pipedOutputStream);
        dataOutputStream.writeInt(1297377380);
        dataOutputStream.writeInt(n6 - 8);
        if (n2 == 0) {
            dataOutputStream.writeShort(0);
        } else {
            dataOutputStream.writeShort(1);
        }
        dataOutputStream.writeShort((short)trackArray.length);
        float f2 = sequence.getDivisionType();
        if (f2 == 0.0f) {
            n3 = sequence.getResolution();
        } else if (f2 == 24.0f) {
            n3 = -6144;
            n3 += sequence.getResolution() & 0xFF;
        } else if (f2 == 25.0f) {
            n3 = -6400;
            n3 += sequence.getResolution() & 0xFF;
        } else if (f2 == 29.97f) {
            n3 = -7424;
            n3 += sequence.getResolution() & 0xFF;
        } else if (f2 == 30.0f) {
            n3 = -7680;
            n3 += sequence.getResolution() & 0xFF;
        } else {
            return null;
        }
        dataOutputStream.writeShort(n3);
        sequenceInputStream = new SequenceInputStream(pipedInputStream, inputStream);
        dataOutputStream.close();
        n7 = n5 + n6;
        return sequenceInputStream;
    }

    private InputStream writeTrack(Track track, int n2) throws IOException, InvalidMidiDataException {
        int n3 = 0;
        boolean bl2 = false;
        int n4 = track.size();
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(pipedOutputStream);
        PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.tddos = new DataOutputStream(byteArrayOutputStream);
        ByteArrayInputStream byteArrayInputStream = null;
        SequenceInputStream sequenceInputStream = null;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n5 = -1;
        block6: for (int i2 = 0; i2 < n4; ++i2) {
            MidiEvent midiEvent = track.get(i2);
            byte[] byArray = null;
            ShortMessage shortMessage = null;
            MetaMessage metaMessage = null;
            SysexMessage sysexMessage = null;
            l4 = midiEvent.getTick();
            l3 = midiEvent.getTick() - l2;
            l2 = midiEvent.getTick();
            int n6 = midiEvent.getMessage().getStatus();
            int n7 = this.getType(n6);
            switch (n7) {
                case 1: {
                    shortMessage = (ShortMessage)midiEvent.getMessage();
                    int n8 = shortMessage.getData1();
                    n3 += this.writeVarInt(l3);
                    if (n6 != n5) {
                        n5 = n6;
                        this.tddos.writeByte(n6);
                        ++n3;
                    }
                    this.tddos.writeByte(n8);
                    ++n3;
                    continue block6;
                }
                case 2: {
                    shortMessage = (ShortMessage)midiEvent.getMessage();
                    int n8 = shortMessage.getData1();
                    int n9 = shortMessage.getData2();
                    n3 += this.writeVarInt(l3);
                    if (n6 != n5) {
                        n5 = n6;
                        this.tddos.writeByte(n6);
                        ++n3;
                    }
                    this.tddos.writeByte(n8);
                    ++n3;
                    this.tddos.writeByte(n9);
                    ++n3;
                    continue block6;
                }
                case 3: {
                    sysexMessage = (SysexMessage)midiEvent.getMessage();
                    int n10 = sysexMessage.getLength();
                    byArray = sysexMessage.getMessage();
                    n3 += this.writeVarInt(l3);
                    n5 = n6;
                    this.tddos.writeByte(byArray[0]);
                    ++n3;
                    n3 += this.writeVarInt(byArray.length - 1);
                    this.tddos.write(byArray, 1, byArray.length - 1);
                    n3 += byArray.length - 1;
                    continue block6;
                }
                case 4: {
                    metaMessage = (MetaMessage)midiEvent.getMessage();
                    int n10 = metaMessage.getLength();
                    byArray = metaMessage.getMessage();
                    n3 += this.writeVarInt(l3);
                    n5 = n6;
                    this.tddos.write(byArray, 0, byArray.length);
                    n3 += byArray.length;
                    continue block6;
                }
                default: {
                    throw new InvalidMidiDataException("Invalid midi event");
                }
            }
        }
        dataOutputStream.writeInt(1297379947);
        dataOutputStream.writeInt(n3);
        n3 += 8;
        byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        sequenceInputStream = new SequenceInputStream(pipedInputStream, byteArrayInputStream);
        dataOutputStream.close();
        this.tddos.close();
        return sequenceInputStream;
    }

    public int write(Sequence sequence, int n2, OutputStream outputStream) throws IOException {
        byte[] byArray = null;
        int n3 = 0;
        long l2 = 0L;
        if (!this.isFileTypeSupported(n2, sequence)) {
            throw new IllegalArgumentException("Could not write MIDI file");
        }
        InputStream inputStream = this.getFileStream(n2, sequence);
        if (inputStream == null) {
            throw new IllegalArgumentException("Could not write MIDI file");
        }
        byArray = new byte[16384];
        while ((n3 = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n3);
            l2 += (long)n3;
        }
        return (int)l2;
    }
}

