/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import sun.reflect.ConstructorAccessor;
import sun.reflect.Reflection;

public final class Constructor
extends AccessibleObject
implements Member {
    private Class clazz;
    private int slot;
    private Class[] parameterTypes;
    private Class[] exceptionTypes;
    private int modifiers;
    private volatile ConstructorAccessor constructorAccessor;
    private Constructor root;

    public int getModifiers() {
        return this.modifiers;
    }

    int getSlot() {
        return this.slot;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode();
    }

    private void acquireConstructorAccessor() {
        ConstructorAccessor constructorAccessor = null;
        if (this.root != null) {
            constructorAccessor = this.root.getConstructorAccessor();
        }
        if (constructorAccessor != null) {
            this.constructorAccessor = constructorAccessor;
            return;
        }
        constructorAccessor = reflectionFactory.newConstructorAccessor(this);
        this.setConstructorAccessor(constructorAccessor);
    }

    public Class getDeclaringClass() {
        return this.clazz;
    }

    public Class[] getExceptionTypes() {
        return Method.copy(this.exceptionTypes);
    }

    public Class[] getParameterTypes() {
        return Method.copy(this.parameterTypes);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Constructor) {
            Class[] classArray;
            Class[] classArray2;
            Constructor constructor = (Constructor)object;
            if (this.getDeclaringClass() == constructor.getDeclaringClass() && (classArray2 = this.parameterTypes).length == (classArray = constructor.parameterTypes).length) {
                for (int i2 = 0; i2 < classArray2.length; ++i2) {
                    if (classArray2[i2] == classArray[i2]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return this.getDeclaringClass().getName();
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = this.getModifiers();
            if (n2 != 0) {
                stringBuffer.append(Modifier.toString(n2) + " ");
            }
            stringBuffer.append(Field.getTypeName(this.getDeclaringClass()));
            stringBuffer.append("(");
            Class[] classArray = this.parameterTypes;
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                stringBuffer.append(Field.getTypeName(classArray[i2]));
                if (i2 >= classArray.length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(")");
            Class[] classArray2 = this.exceptionTypes;
            if (classArray2.length > 0) {
                stringBuffer.append(" throws ");
                for (int i3 = 0; i3 < classArray2.length; ++i3) {
                    stringBuffer.append(classArray2[i3].getName());
                    if (i3 >= classArray2.length - 1) continue;
                    stringBuffer.append(",");
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "<" + exception + ">";
        }
    }

    Constructor copy() {
        Constructor constructor = new Constructor(this.clazz, this.parameterTypes, this.exceptionTypes, this.modifiers, this.slot);
        constructor.root = this;
        constructor.constructorAccessor = this.constructorAccessor;
        return constructor;
    }

    ConstructorAccessor getConstructorAccessor() {
        return this.constructorAccessor;
    }

    void setConstructorAccessor(ConstructorAccessor constructorAccessor) {
        this.constructorAccessor = constructorAccessor;
        if (this.root != null) {
            this.root.setConstructorAccessor(constructorAccessor);
        }
    }

    public Object newInstance(Object[] objectArray) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class clazz;
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers) && this.securityCheckCache != (clazz = Reflection.getCallerClass(2))) {
            Reflection.ensureMemberAccess(clazz, this.clazz, null, this.modifiers);
            this.securityCheckCache = clazz;
        }
        if (this.constructorAccessor == null) {
            this.acquireConstructorAccessor();
        }
        return this.constructorAccessor.newInstance(objectArray);
    }

    Constructor(Class clazz, Class[] classArray, Class[] classArray2, int n2, int n3) {
        this.clazz = clazz;
        this.parameterTypes = classArray;
        this.exceptionTypes = classArray2;
        this.modifiers = n2;
        this.slot = n3;
    }
}

