/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import sun.io.CharToByteConverter;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcBatchUpdateException;
import sun.jdbc.odbc.JdbcOdbcBoundArrayOfParams;
import sun.jdbc.odbc.JdbcOdbcBoundParam;
import sun.jdbc.odbc.JdbcOdbcConnectionInterface;
import sun.jdbc.odbc.JdbcOdbcResultSet;
import sun.jdbc.odbc.JdbcOdbcResultSetMetaData;
import sun.jdbc.odbc.JdbcOdbcSQLWarning;
import sun.jdbc.odbc.JdbcOdbcStatement;
import sun.jdbc.odbc.JdbcOdbcUtils;

public class JdbcOdbcPreparedStatement
extends JdbcOdbcStatement
implements PreparedStatement {
    protected int numParams;
    protected JdbcOdbcBoundParam[] boundParams;
    protected JdbcOdbcBoundArrayOfParams arrayParams;
    protected Vector batchSqlVec;
    protected boolean batchSupport;
    protected boolean batchParamsOn;
    protected int batchSize;
    protected int arrayDef;
    protected int arrayScale;
    protected int StringDef;
    protected int NumberDef;
    protected int NumberScale;
    protected int batchRCFlag;
    protected int[] paramsProcessed;
    protected int[] paramStatusArray;
    protected long[] pA1;
    protected long[] pA2;
    protected int binaryPrec;
    protected JdbcOdbcUtils utils = new JdbcOdbcUtils();

    public int executeUpdate() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*PreparedStatement.executeUpdate");
        }
        int n2 = -1;
        if (this.execute()) {
            throw new SQLException("No row count was produced");
        }
        n2 = this.getUpdateCount();
        return n2;
    }

    public int getParamCount() {
        return this.numParams;
    }

    public synchronized void FreeIntParams() {
        if (this.pA1 != null && this.pA1[0] != 0L) {
            JdbcOdbc.ReleaseStoredIntegers(this.pA1[0], this.pA1[1]);
            this.pA1[0] = 0L;
            this.pA1[1] = 0L;
        }
        if (this.pA2 != null && this.pA2[0] != 0L) {
            JdbcOdbc.ReleaseStoredIntegers(this.pA2[0], this.pA2[1]);
            this.pA2[0] = 0L;
            this.pA2[1] = 0L;
        }
    }

    public synchronized void FreeParams() throws NullPointerException {
        try {
            for (int i2 = 1; i2 <= this.boundParams.length; ++i2) {
                if (this.boundParams[i2 - 1].pA1 != 0L) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundParams[i2 - 1].pA1, this.boundParams[i2 - 1].pA2);
                    this.boundParams[i2 - 1].pA1 = 0L;
                    this.boundParams[i2 - 1].pA2 = 0L;
                }
                if (this.boundParams[i2 - 1].pB1 != 0L) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundParams[i2 - 1].pB1, this.boundParams[i2 - 1].pB2);
                    this.boundParams[i2 - 1].pB1 = 0L;
                    this.boundParams[i2 - 1].pB2 = 0L;
                }
                if (this.boundParams[i2 - 1].pC1 != 0L) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundParams[i2 - 1].pC1, this.boundParams[i2 - 1].pC2);
                    this.boundParams[i2 - 1].pC1 = 0L;
                    this.boundParams[i2 - 1].pC2 = 0L;
                }
                if (this.boundParams[i2 - 1].pS1 == 0L) continue;
                JdbcOdbc.ReleaseStoredChars(this.boundParams[i2 - 1].pS1, this.boundParams[i2 - 1].pS2);
                this.boundParams[i2 - 1].pS1 = 0L;
                this.boundParams[i2 - 1].pS2 = 0L;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void addBatch() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*PreparedStatement.addBatch");
        }
        try {
            int n2;
            this.batchSqlVec = this.myConnection.getBatchVector(this);
            if (this.batchSqlVec == null) {
                this.batchSqlVec = new Vector(5, 10);
                n2 = 0;
            } else {
                n2 = this.batchSqlVec.size();
            }
            Object[] objectArray = this.arrayParams.getStoredParameterSet();
            int[] nArray = this.arrayParams.getStoredIndexSet();
            int n3 = objectArray.length;
            int n4 = nArray.length;
            if (n4 == this.numParams) {
                this.batchSqlVec.addElement(objectArray);
                this.myConnection.setBatchVector(this.batchSqlVec, this);
                this.arrayParams.storeRowIndex(n2, nArray);
                this.batchOn = true;
            } else {
                if (n2 == 0) {
                    throw new SQLException("Parameter-Set has missing values.");
                }
                this.batchOn = true;
            }
        }
        catch (NullPointerException nullPointerException) {
            this.batchOn = false;
        }
    }

    protected void cleanUpBatch() {
        this.myConnection.removeBatchVector(this);
        if (this.batchSqlVec != null) {
            this.batchSqlVec.setSize(0);
            this.batchSize = 0;
        }
    }

    public void clearBatch() {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*PreparedStatement.clearBatch");
        }
        try {
            if (this.batchSqlVec != null) {
                this.cleanUpBatch();
                this.batchOn = false;
                this.batchParamsOn = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void clearParameters() throws SQLException {
        if (this.hStmt != 0L) {
            this.OdbcApi.SQLFreeStmt(this.hStmt, 3);
            this.FreeParams();
            for (int i2 = 1; this.boundParams != null && i2 <= this.boundParams.length; ++i2) {
                this.boundParams[i2 - 1].binaryData = null;
                this.boundParams[i2 - 1].initialize();
                this.boundParams[i2 - 1].paramInputStream = null;
                this.boundParams[i2 - 1].inputParameter = false;
            }
        }
    }

    public synchronized void close() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*PreparedStatement.close");
        }
        this.clearMyResultSet();
        try {
            this.clearWarnings();
            if (this.hStmt != 0L) {
                if (this.closeCalledFromFinalize) {
                    if (!this.myConnection.isFreeStmtsFromConnectionOnly()) {
                        this.OdbcApi.SQLFreeStmt(this.hStmt, 1);
                    }
                } else {
                    this.OdbcApi.SQLFreeStmt(this.hStmt, 1);
                }
                this.hStmt = 0L;
                this.FreeParams();
                for (int i2 = 1; this.boundParams != null && i2 <= this.boundParams.length; ++i2) {
                    this.boundParams[i2 - 1].binaryData = null;
                    this.boundParams[i2 - 1].initialize();
                    this.boundParams[i2 - 1].paramInputStream = null;
                    this.boundParams[i2 - 1].inputParameter = false;
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.FreeIntParams();
        this.myConnection.deregisterStatement(this);
        if (this.batchOn) {
            this.clearBatch();
        }
    }

    public void initBoundParam() throws SQLException {
        this.numParams = this.OdbcApi.SQLNumParams(this.hStmt);
        if (this.numParams > 0) {
            this.boundParams = new JdbcOdbcBoundParam[this.numParams];
            for (int i2 = 0; i2 < this.numParams; ++i2) {
                this.boundParams[i2] = new JdbcOdbcBoundParam();
                this.boundParams[i2].initialize();
            }
            this.arrayParams = new JdbcOdbcBoundArrayOfParams(this.numParams);
            this.batchRCFlag = this.myConnection.getBatchRowCountFlag(1);
            this.batchSupport = this.batchRCFlag > 0 && this.batchRCFlag == 1;
            this.StringDef = 0;
            this.NumberDef = 0;
            this.NumberDef = 0;
            this.binaryPrec = 0;
        }
    }

    public synchronized boolean execute() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*PreparedStatement.execute");
        }
        boolean bl2 = false;
        SQLWarning sQLWarning = null;
        boolean bl3 = false;
        this.clearWarnings();
        this.reset();
        try {
            bl3 = this.OdbcApi.SQLExecute(this.hStmt);
            while (bl3) {
                int n2 = this.OdbcApi.SQLParamData(this.hStmt);
                if (n2 == -1) {
                    bl3 = false;
                    continue;
                }
                if (this.batchParamsOn) {
                    InputStream inputStream = null;
                    int n3 = this.paramsProcessed[0];
                    inputStream = this.arrayParams.getInputStreamElement(n2, n3);
                    this.boundParams[n2 - 1].setInputStream(inputStream, this.arrayParams.getElementLength(n2, n3));
                }
                this.putParamData(n2);
            }
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        if (this.getColumnCount() > 0) {
            bl2 = true;
        }
        return bl2;
    }

    protected int[] emulateExecuteBatch() throws BatchUpdateException {
        int[] nArray = new int[this.batchSize];
        int[] nArray2 = new int[]{};
        int n2 = 0;
        for (int i2 = 0; i2 < this.batchSize; ++i2) {
            int n3;
            int n4;
            Object[] objectArray = (Object[])this.batchSqlVec.elementAt(i2);
            int[] nArray3 = this.arrayParams.getStoredRowIndex(i2);
            try {
                for (n4 = 0; n4 < objectArray.length; ++n4) {
                    n3 = 1111;
                    int n5 = 0;
                    int n6 = 0;
                    int n7 = n4 + 1;
                    InputStream inputStream = null;
                    n3 = JdbcOdbcPreparedStatement.getTypeFromObject(objectArray[n4]);
                    int n8 = this.getSqlType(n7);
                    if (n3 == -4) {
                        inputStream = (InputStream)objectArray[n4];
                        n5 = nArray3[n4];
                        switch (n8) {
                            case -4: {
                                n6 = 3;
                                break;
                            }
                            case -1: {
                                n6 = this.boundParams[n4].getStreamType();
                            }
                        }
                    }
                    if (n5 > 0 && 0 < n6) {
                        switch (n6) {
                            case 1: 
                            case 2: {
                                this.setStream(n7, inputStream, n5, -1, n6);
                                break;
                            }
                            case 3: {
                                this.setStream(n7, inputStream, n5, -4, n6);
                            }
                        }
                        continue;
                    }
                    if (n3 == 1111) continue;
                    if (n3 != 0) {
                        this.setObject(n7, objectArray[n4], n8);
                        continue;
                    }
                    this.setNull(n7, n8);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                if (!this.execute()) {
                    this.myConnection.removeBatchVector(this);
                    nArray[i2] = this.getUpdateCount();
                    ++n2;
                    continue;
                }
                for (n4 = 0; n4 < i2 - 1; ++n4) {
                    nArray2 = new int[n2];
                    nArray2[n4] = nArray[n4];
                }
                this.cleanUpBatch();
                throw new JdbcOdbcBatchUpdateException("SQL Attempt to produce a ResultSet from executeBatch", nArray2);
            }
            catch (SQLException sQLException) {
                for (n3 = 0; n3 < i2 - 1; ++n3) {
                    nArray2 = new int[n2];
                    nArray2[n3] = nArray[n3];
                }
                this.cleanUpBatch();
                throw new JdbcOdbcBatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), nArray2);
            }
        }
        this.cleanUpBatch();
        return nArray;
    }

    public int[] executeBatchUpdate() throws BatchUpdateException {
        int[] nArray = new int[]{};
        if (this.numParams <= 0) {
            this.batchSize = 0;
            this.batchOn = false;
            this.batchParamsOn = false;
            return this.executeNoParametersBatch();
        }
        this.batchSqlVec = this.myConnection.getBatchVector(this);
        if (this.batchSqlVec == null) {
            nArray = new int[]{};
            return nArray;
        }
        this.batchSize = this.batchSqlVec.size();
        if (this.batchSize > 0) {
            nArray = new int[this.batchSize];
            this.FreeIntParams();
            this.paramStatusArray = new int[this.batchSize];
            this.paramsProcessed = new int[this.batchSize];
            boolean bl2 = true;
            int n2 = 0;
            try {
                if (!bl2) {
                    this.OdbcApi.SQLSetStmtAttr(this.hStmt, 18, 0, 0);
                    try {
                        this.setStmtParameterSize(this.batchSize);
                        n2 = this.getStmtParameterAttr(22);
                    }
                    catch (SQLException sQLException) {
                        this.batchSupport = false;
                    }
                }
                if (n2 != this.batchSize) {
                    this.batchSupport = false;
                    try {
                        this.setStmtParameterSize(1);
                    }
                    catch (SQLException sQLException) {}
                } else {
                    this.pA2 = new long[2];
                    this.pA2[0] = 0L;
                    this.pA2[1] = 0L;
                    this.OdbcApi.SQLSetStmtAttrPtr(this.hStmt, 20, this.paramStatusArray, 0, this.pA2);
                    this.pA1 = new long[2];
                    this.pA1[0] = 0L;
                    this.pA1[1] = 0L;
                    this.OdbcApi.SQLSetStmtAttrPtr(this.hStmt, 21, this.paramsProcessed, 0, this.pA1);
                    this.batchSupport = true;
                }
            }
            catch (SQLException sQLException) {
                this.batchSupport = false;
            }
            if (this.batchSupport) {
                this.batchParamsOn = true;
                int[] nArray2 = new int[]{};
                this.arrayParams.builtColumWiseParameteSets(this.batchSize, this.batchSqlVec);
                for (int i2 = 0; i2 < this.numParams; ++i2) {
                    this.arrayDef = 0;
                    this.arrayScale = 0;
                    int n3 = 0;
                    int n4 = i2 + 1;
                    try {
                        Object[] objectArray = this.arrayParams.getColumnWiseParamSet(n4);
                        int[] nArray3 = this.arrayParams.getColumnWiseIndexArray(n4);
                        this.setPrecisionScaleArgs(objectArray, nArray3);
                        n3 = this.getSqlType(n4);
                        this.bindArrayOfParameters(n4, n3, this.arrayDef, this.arrayScale, objectArray, nArray3);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                try {
                    if (this.execute()) {
                        this.cleanUpBatch();
                        throw new JdbcOdbcBatchUpdateException("SQL Attempt to produce a ResultSet from executeBatch", this.paramStatusArray);
                    }
                    this.paramStatusArray[0] = this.getUpdateCount();
                    this.arrayParams.clearStoredRowIndexs();
                    nArray = this.paramStatusArray;
                    this.batchOn = false;
                    this.batchParamsOn = false;
                    this.cleanUpBatch();
                }
                catch (SQLException sQLException) {
                    try {
                        this.paramStatusArray[0] = this.getUpdateCount();
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    nArray2 = new int[this.paramsProcessed[0] - 1];
                    this.cleanUpBatch();
                    throw new JdbcOdbcBatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), nArray2);
                }
            }
            if (!this.batchSupport) {
                this.batchOn = false;
                this.batchParamsOn = false;
                return this.emulateExecuteBatch();
            }
        }
        return nArray;
    }

    protected int[] executeNoParametersBatch() throws BatchUpdateException {
        int[] nArray = new int[1];
        try {
            if (this.execute()) {
                this.cleanUpBatch();
                throw new JdbcOdbcBatchUpdateException("SQL Attempt to produce a ResultSet from executeBatch", nArray);
            }
            this.cleanUpBatch();
            nArray[0] = this.getUpdateCount();
        }
        catch (SQLException sQLException) {
            try {
                nArray[0] = this.getUpdateCount();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            this.cleanUpBatch();
            throw new JdbcOdbcBatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), nArray);
        }
        return nArray;
    }

    public int[] getObjectTypes() {
        int[] nArray = new int[this.numParams];
        for (int i2 = 0; i2 < this.numParams; ++i2) {
            nArray[i2] = this.boundParams[i2].getSqlType();
        }
        return nArray;
    }

    public int getParamLength(int n2) {
        int n3 = -1;
        if (n2 >= 1 && n2 <= this.numParams) {
            n3 = this.OdbcApi.bufferToInt(this.boundParams[n2 - 1].getBindLengthBuffer());
        }
        return n3;
    }

    protected int getSqlType(int n2) {
        int n3 = 1111;
        if (n2 >= 1 && n2 <= this.numParams) {
            n3 = this.boundParams[n2 - 1].getSqlType();
        }
        return n3;
    }

    protected int getStmtParameterAttr(int n2) throws SQLException {
        try {
            this.clearWarnings();
            return this.OdbcApi.SQLGetStmtAttr(this.hStmt, n2);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return -1;
        }
    }

    public void clearParameter(int n2) throws SQLException {
        if (this.hStmt != 0L) {
            if (this.boundParams[n2 - 1].pA1 != 0L) {
                JdbcOdbc.ReleaseStoredBytes(this.boundParams[n2 - 1].pA1, this.boundParams[n2 - 1].pA2);
                this.boundParams[n2 - 1].pA1 = 0L;
                this.boundParams[n2 - 1].pA2 = 0L;
            }
            if (this.boundParams[n2 - 1].pB1 != 0L) {
                JdbcOdbc.ReleaseStoredBytes(this.boundParams[n2 - 1].pB1, this.boundParams[n2 - 1].pB2);
                this.boundParams[n2 - 1].pB1 = 0L;
                this.boundParams[n2 - 1].pB2 = 0L;
            }
            if (this.boundParams[n2 - 1].pC1 != 0L) {
                JdbcOdbc.ReleaseStoredBytes(this.boundParams[n2 - 1].pC1, this.boundParams[n2 - 1].pC2);
                this.boundParams[n2 - 1].pC1 = 0L;
                this.boundParams[n2 - 1].pC2 = 0L;
            }
            if (this.boundParams[n2 - 1].pS1 != 0L) {
                JdbcOdbc.ReleaseStoredChars(this.boundParams[n2 - 1].pS1, this.boundParams[n2 - 1].pS2);
                this.boundParams[n2 - 1].pS1 = 0L;
                this.boundParams[n2 - 1].pS2 = 0L;
            }
            this.boundParams[n2 - 1].binaryData = null;
            this.boundParams[n2 - 1].initialize();
            this.boundParams[n2 - 1].paramInputStream = null;
            this.boundParams[n2 - 1].inputParameter = false;
        }
    }

    protected void putParamData(int n2) throws SQLException, JdbcOdbcSQLWarning {
        int n3 = 2000;
        byte[] byArray = new byte[n3];
        boolean bl2 = false;
        if (n2 < 1 || n2 > this.numParams) {
            if (this.OdbcApi.getTracer().isTracing()) {
                this.OdbcApi.getTracer().trace("Invalid index for putParamData()");
            }
            return;
        }
        InputStream inputStream = this.boundParams[n2 - 1].getInputStream();
        int n4 = this.boundParams[n2 - 1].getInputStreamLen();
        int n5 = this.boundParams[n2 - 1].getStreamType();
        while (!bl2) {
            int n6;
            try {
                if (this.OdbcApi.getTracer().isTracing()) {
                    this.OdbcApi.getTracer().trace("Reading from input stream");
                }
                n6 = inputStream.read(byArray);
                if (this.OdbcApi.getTracer().isTracing()) {
                    this.OdbcApi.getTracer().trace("Bytes read: " + n6);
                }
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
            if (n6 == -1) {
                if (n4 != 0) {
                    throw new SQLException("End of InputStream reached before satisfying length specified when InputStream was set");
                }
                bl2 = true;
                break;
            }
            if (n6 > n4) {
                n6 = n4;
                bl2 = true;
            }
            int n7 = n6;
            if (n5 == 2) {
                n7 = n6 / 2;
                for (int i2 = 0; i2 < n7; ++i2) {
                    byArray[i2] = byArray[i2 * 2 + 1];
                }
            }
            this.OdbcApi.SQLPutData(this.hStmt, byArray, n7);
            n4 -= n6;
            if (this.OdbcApi.getTracer().isTracing()) {
                this.OdbcApi.getTracer().trace("" + n4 + " bytes remaining");
            }
            if (n4 != 0) continue;
            bl2 = true;
        }
    }

    protected void setStmtParameterSize(int n2) throws SQLException {
        try {
            this.clearWarnings();
            this.OdbcApi.SQLSetStmtAttr(this.hStmt, 22, n2, 0);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    protected byte[] getDataBuf(int n2) {
        byte[] byArray = null;
        if (n2 >= 1 && n2 <= this.numParams) {
            byArray = this.boundParams[n2 - 1].getBindDataBuffer();
        }
        return byArray;
    }

    protected byte[] getLengthBuf(int n2) {
        byte[] byArray = null;
        if (n2 >= 1 && n2 <= this.numParams) {
            byArray = this.boundParams[n2 - 1].getBindLengthBuffer();
        }
        return byArray;
    }

    public void setByte(int n2, byte by) throws SQLException {
        this.clearParameter(n2);
        this.setInputParameter(n2, true);
        byte[] byArray = this.allocBindBuf(n2, 4);
        long[] lArray = new long[]{0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterInteger(this.hStmt, n2, -6, by, byArray, lArray);
        }
        this.boundParams[n2 - 1].pA1 = lArray[0];
        this.boundParams[n2 - 1].pA2 = lArray[1];
        this.boundParams[n2 - 1].boundType = -6;
        this.boundParams[n2 - 1].boundValue = new Byte(by);
        this.arrayParams.storeValue(n2 - 1, new Byte(by), 0);
        this.setSqlType(n2, -6);
    }

    public void setDouble(int n2, double d2) throws SQLException {
        this.clearParameter(n2);
        this.setInputParameter(n2, true);
        byte[] byArray = this.allocBindBuf(n2, 8);
        long[] lArray = new long[]{0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterDouble(this.hStmt, n2, 8, 0, d2, byArray, lArray);
        }
        this.boundParams[n2 - 1].pA1 = lArray[0];
        this.boundParams[n2 - 1].pA2 = lArray[1];
        this.boundParams[n2 - 1].boundType = 8;
        this.boundParams[n2 - 1].boundValue = new Double(d2);
        this.arrayParams.storeValue(n2 - 1, new Double(d2), 0);
        this.setSqlType(n2, 8);
    }

    public void setFloat(int n2, float f2) throws SQLException {
        this.setDouble(n2, f2);
    }

    public void setReal(int n2, float f2) throws SQLException {
        this.clearParameter(n2);
        this.setInputParameter(n2, true);
        byte[] byArray = this.allocBindBuf(n2, 8);
        long[] lArray = new long[]{0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterFloat(this.hStmt, n2, 7, 0, f2, byArray, lArray);
        }
        this.boundParams[n2 - 1].pA1 = lArray[0];
        this.boundParams[n2 - 1].pA2 = lArray[1];
        this.arrayParams.storeValue(n2 - 1, new Float(f2), 0);
        this.setSqlType(n2, 7);
    }

    public void setInt(int n2, int n3) throws SQLException {
        this.clearParameter(n2);
        this.setInputParameter(n2, true);
        byte[] byArray = this.allocBindBuf(n2, 4);
        long[] lArray = new long[]{0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterInteger(this.hStmt, n2, 4, n3, byArray, lArray);
        }
        this.boundParams[n2 - 1].pA1 = lArray[0];
        this.boundParams[n2 - 1].pA2 = lArray[1];
        this.boundParams[n2 - 1].boundType = 4;
        this.boundParams[n2 - 1].boundValue = new Integer(n3);
        this.arrayParams.storeValue(n2 - 1, new Integer(n3), 0);
        this.setSqlType(n2, 4);
    }

    public void setNull(int n2, int n3) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*PreparedStatement.setNull (" + n2 + "," + n3 + ")");
        }
        this.clearParameter(n2);
        this.setInputParameter(n2, true);
        byte[] byArray = this.getLengthBuf(n2);
        long[] lArray = new long[]{0L, 0L};
        int n4 = 0;
        int n5 = 0;
        if (n3 == 1 || n3 == 12) {
            n4 = this.StringDef;
        } else if (n3 == 2 || n3 == 3) {
            n4 = this.NumberDef;
            n5 = this.NumberScale;
        } else if (n3 == -2 || n3 == -3 || n3 == -4) {
            n3 = this.boundParams[n2 - 1].boundType;
            n4 = this.binaryPrec;
        }
        if (n4 <= 0) {
            n4 = this.getPrecision(n3);
        }
        if (n4 <= 0) {
            n4 = 1;
        }
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterNull(this.hStmt, n2, n3, n4, n5, byArray, lArray);
        }
        this.boundParams[n2 - 1].pA1 = lArray[0];
        this.boundParams[n2 - 1].pA2 = lArray[1];
        this.boundParams[n2 - 1].scale = n5;
        this.boundParams[n2 - 1].boundType = n3;
        this.boundParams[n2 - 1].boundValue = null;
        this.arrayParams.storeValue(n2 - 1, null, -1);
        this.setSqlType(n2, n3);
    }

    protected void setSqlType(int n2, int n3) {
        if (n2 >= 1 && n2 <= this.numParams) {
            this.boundParams[n2 - 1].setSqlType(n3);
        }
    }

    protected byte[] allocBindBuf(int n2, int n3) {
        byte[] byArray = null;
        if (n2 >= 1 && n2 <= this.numParams) {
            byArray = this.boundParams[n2 - 1].allocBindDataBuffer(n3);
        }
        return byArray;
    }

    protected void setBinary(int n2, int n3, byte[] byArray) throws SQLException {
        this.clearParameter(n2);
        this.setInputParameter(n2, true);
        byte[] byArray2 = this.allocBindBuf(n2, byArray.length);
        byte[] byArray3 = this.getLengthBuf(n2);
        long[] lArray = new long[]{0L, 0L, 0L, 0L, 0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterBinary(this.hStmt, n2, n3, byArray, byArray2, byArray3, lArray);
        }
        this.boundParams[n2 - 1].pA1 = lArray[0];
        this.boundParams[n2 - 1].pA2 = lArray[1];
        this.boundParams[n2 - 1].pB1 = lArray[2];
        this.boundParams[n2 - 1].pB2 = lArray[3];
        this.boundParams[n2 - 1].pC1 = lArray[4];
        this.boundParams[n2 - 1].pC2 = lArray[5];
        this.boundParams[n2 - 1].boundType = n3;
        this.boundParams[n2 - 1].boundValue = byArray;
        this.binaryPrec = byArray.length;
        this.arrayParams.storeValue(n2 - 1, byArray, -3);
        this.setSqlType(n2, n3);
    }

    public void setLong(int n2, long l2) throws SQLException {
        this.clearParameter(n2);
        if (this.myConnection.getODBCVer() == 2) {
            this.setChar(n2, -5, new Long(l2).intValue(), String.valueOf(l2));
        } else if (this.myConnection.getODBCVer() >= 3) {
            this.setInputParameter(n2, true);
            byte[] byArray = this.allocBindBuf(n2, 8);
            long[] lArray = new long[]{0L, 0L};
            if (!this.batchOn) {
                this.OdbcApi.SQLBindInParameterBigint(this.hStmt, n2, -5, 0, l2, byArray, lArray);
            }
            this.boundParams[n2 - 1].pA1 = lArray[0];
            this.boundParams[n2 - 1].pA2 = lArray[1];
            this.arrayParams.storeValue(n2 - 1, new BigInteger(String.valueOf(l2)), 0);
            this.setSqlType(n2, -5);
        }
        this.boundParams[n2 - 1].boundType = -5;
        this.boundParams[n2 - 1].boundValue = new BigInteger(String.valueOf(l2));
    }

    public void setShort(int n2, short s2) throws SQLException {
        this.clearParameter(n2);
        this.setInputParameter(n2, true);
        byte[] byArray = this.allocBindBuf(n2, 4);
        long[] lArray = new long[]{0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterInteger(this.hStmt, n2, 5, s2, byArray, lArray);
        }
        this.boundParams[n2 - 1].pA1 = lArray[0];
        this.boundParams[n2 - 1].pA2 = lArray[1];
        this.boundParams[n2 - 1].boundType = 5;
        this.boundParams[n2 - 1].boundValue = new Short(s2);
        this.arrayParams.storeValue(n2 - 1, new Short(s2), 0);
        this.setSqlType(n2, 5);
    }

    public void setBoolean(int n2, boolean bl2) throws SQLException {
        int n3 = 0;
        if (bl2) {
            n3 = 1;
        }
        this.clearParameter(n2);
        this.setInputParameter(n2, true);
        byte[] byArray = this.allocBindBuf(n2, 4);
        long[] lArray = new long[]{0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterInteger(this.hStmt, n2, -7, n3, byArray, lArray);
        }
        this.boundParams[n2 - 1].pA1 = lArray[0];
        this.boundParams[n2 - 1].pA2 = lArray[1];
        this.boundParams[n2 - 1].boundType = -7;
        this.boundParams[n2 - 1].boundValue = new Boolean(bl2);
        this.arrayParams.storeValue(n2 - 1, new Boolean(bl2), 0);
        this.setSqlType(n2, -7);
    }

    protected void setInputParameter(int n2, boolean bl2) {
        if (n2 >= 1 && n2 <= this.numParams) {
            this.boundParams[n2 - 1].setInputParameter(bl2);
        }
    }

    public void setBytes(int n2, byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.setNull(n2, -2);
        } else if (byArray.length > 8000) {
            this.setBinaryStream(n2, new ByteArrayInputStream(byArray), byArray.length);
        } else {
            this.setBinary(n2, -2, byArray);
        }
        this.boundParams[n2 - 1].boundType = -2;
        this.boundParams[n2 - 1].boundValue = byArray;
    }

    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.setStream(n2, inputStream, n3, -1, 1);
    }

    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.setStream(n2, inputStream, n3, -4, 3);
        this.binaryPrec = n3;
    }

    public void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.setStream(n2, inputStream, n3, -1, 2);
    }

    public void setStream(int n2, InputStream inputStream, int n3, int n4, int n5) throws SQLException {
        this.clearParameter(n2);
        this.setInputParameter(n2, true);
        byte[] byArray = this.getLengthBuf(n2);
        byte[] byArray2 = this.allocBindBuf(n2, 4);
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterAtExec(this.hStmt, n2, n4, n3, byArray2, byArray, lArray);
        }
        this.boundParams[n2 - 1].pA1 = lArray[0];
        this.boundParams[n2 - 1].pA2 = lArray[1];
        this.boundParams[n2 - 1].pB1 = lArray[2];
        this.boundParams[n2 - 1].pB2 = lArray[3];
        this.boundParams[n2 - 1].boundType = n4;
        this.boundParams[n2 - 1].boundValue = inputStream;
        this.boundParams[n2 - 1].setInputStream(inputStream, n3);
        this.boundParams[n2 - 1].setStreamType(n5);
        this.arrayParams.storeValue(n2 - 1, inputStream, n3);
        this.setSqlType(n2, n4);
    }

    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.clearParameter(n2);
        BufferedReader bufferedReader = null;
        BufferedOutputStream bufferedOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ByteArrayInputStream byteArrayInputStream = null;
        String string = this.OdbcApi.charSet;
        int n4 = 300;
        if (n3 < n4) {
            n4 = n3;
        }
        int n5 = 0;
        int n6 = 0;
        try {
            CharToByteConverter charToByteConverter = CharToByteConverter.getConverter(string);
            n6 = charToByteConverter.getMaxBytesPerChar();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (n6 == 0) {
            n6 = 1;
        }
        try {
            if (reader != null) {
                boolean bl2 = false;
                int n7 = 0;
                bufferedReader = new BufferedReader(reader);
                byteArrayOutputStream = new ByteArrayOutputStream();
                bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                char[] cArray = new char[n4];
                while (n7 != -1) {
                    int n8;
                    byte[] byArray = new byte[]{};
                    n7 = bufferedReader.read(cArray);
                    if (n7 == -1) continue;
                    char[] cArray2 = new char[n7];
                    for (n8 = 0; n8 < n7; ++n8) {
                        cArray2[n8] = cArray[n8];
                    }
                    byArray = this.CharsToBytes(string, cArray2);
                    n8 = byArray.length - 1;
                    bufferedOutputStream.write(byArray, 0, n8);
                    bufferedOutputStream.flush();
                }
                n5 = byteArrayOutputStream.size();
                byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
        }
        catch (IOException iOException) {
            throw new SQLException("CharsToBytes Reader Conversion: " + iOException.getMessage());
        }
        this.setStream(n2, byteArrayInputStream, n5, -1, 3);
    }

    public Object[] getObjects() {
        Object[] objectArray = new Object[this.numParams];
        Object[] objectArray2 = this.arrayParams.getStoredParameterSet();
        if (objectArray2 != null) {
            try {
                for (int i2 = 0; i2 < this.numParams; ++i2) {
                    objectArray[i2] = objectArray2[i2];
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("Exception, while calculating row count: " + arrayIndexOutOfBoundsException.getMessage());
                arrayIndexOutOfBoundsException.printStackTrace();
            }
        }
        return objectArray;
    }

    protected void bindArrayOfParameters(int n2, int n3, int n4, int n5, Object[] objectArray, int[] nArray) throws SQLException {
        switch (n3) {
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                this.OdbcApi.SQLBindInParameterStringArray(this.hStmt, n2, n3, objectArray, n4, n5, nArray);
                break;
            }
            case -1: {
                if (this.getTypeFromObjectArray(objectArray) == -4) {
                    this.arrayParams.setInputStreamElements(n2, objectArray);
                    this.OdbcApi.SQLBindInParameterAtExecArray(this.hStmt, n2, n3, n4, nArray);
                    break;
                }
                this.OdbcApi.SQLBindInParameterStringArray(this.hStmt, n2, n3, objectArray, n4, n5, nArray);
                break;
            }
            case -7: 
            case -6: 
            case 4: 
            case 5: {
                this.OdbcApi.SQLBindInParameterIntegerArray(this.hStmt, n2, n3, objectArray, nArray);
                break;
            }
            case 8: {
                this.OdbcApi.SQLBindInParameterDoubleArray(this.hStmt, n2, n3, objectArray, nArray);
                break;
            }
            case -5: 
            case 6: 
            case 7: {
                this.OdbcApi.SQLBindInParameterFloatArray(this.hStmt, n2, n3, objectArray, nArray);
                break;
            }
            case 91: {
                this.OdbcApi.SQLBindInParameterDateArray(this.hStmt, n2, objectArray, nArray);
                break;
            }
            case 92: {
                this.OdbcApi.SQLBindInParameterTimeArray(this.hStmt, n2, objectArray, nArray);
                break;
            }
            case 93: {
                this.OdbcApi.SQLBindInParameterTimestampArray(this.hStmt, n2, objectArray, nArray);
                break;
            }
            case -3: 
            case -2: {
                this.OdbcApi.SQLBindInParameterBinaryArray(this.hStmt, n2, n3, objectArray, n4, nArray);
                break;
            }
            case -4: {
                this.arrayParams.setInputStreamElements(n2, objectArray);
                this.OdbcApi.SQLBindInParameterAtExecArray(this.hStmt, n2, n3, n4, nArray);
            }
        }
    }

    public void setObject(int n2, Object object) throws SQLException {
        this.setObject(n2, object, JdbcOdbcPreparedStatement.getTypeFromObject(object));
    }

    public void setObject(int n2, Object object, int n3) throws SQLException {
        this.setObject(n2, object, n3, 0);
    }

    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        if (object == null) {
            this.setNull(n2, n3);
            return;
        }
        String string = null;
        string = object instanceof byte[] ? new String("byte[]") : new String(object.getClass().getName());
        int n5 = 0;
        BigInteger bigInteger = null;
        if (string.equalsIgnoreCase("java.lang.Boolean")) {
            if (object.toString().equalsIgnoreCase("true")) {
                n5 = 1;
                bigInteger = BigInteger.ONE;
            } else {
                n5 = 0;
                bigInteger = BigInteger.ZERO;
            }
        }
        try {
            switch (n3) {
                case 1: {
                    if (string.equalsIgnoreCase("java.lang.String") || string.equalsIgnoreCase("java.math.BigDecimal") || string.equalsIgnoreCase("java.lang.Boolean") || string.equalsIgnoreCase("java.lang.Integer") || string.equalsIgnoreCase("java.lang.Short") || string.equalsIgnoreCase("java.lang.Long") || string.equalsIgnoreCase("java.lang.Float") || string.equalsIgnoreCase("java.lang.Double") || string.equalsIgnoreCase("java.sql.Date") || string.equalsIgnoreCase("java.sql.Time") || string.equalsIgnoreCase("java.sql.Timestamp")) {
                        this.setString(n2, object.toString());
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case 12: {
                    if (string.equalsIgnoreCase("java.lang.String") || string.equalsIgnoreCase("java.math.BigDecimal") || string.equalsIgnoreCase("java.lang.Boolean") || string.equalsIgnoreCase("java.lang.Integer") || string.equalsIgnoreCase("java.lang.Short") || string.equalsIgnoreCase("java.lang.Long") || string.equalsIgnoreCase("java.lang.Float") || string.equalsIgnoreCase("java.lang.Double") || string.equalsIgnoreCase("java.sql.Date") || string.equalsIgnoreCase("java.sql.Time") || string.equalsIgnoreCase("java.sql.Timestamp")) {
                        this.setChar(n2, n3, 0, object.toString());
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case -1: {
                    if (string.equalsIgnoreCase("java.lang.String") || string.equalsIgnoreCase("java.math.BigDecimal") || string.equalsIgnoreCase("java.lang.Boolean") || string.equalsIgnoreCase("java.lang.Integer") || string.equalsIgnoreCase("java.lang.Short") || string.equalsIgnoreCase("java.lang.Long") || string.equalsIgnoreCase("java.lang.Float") || string.equalsIgnoreCase("java.lang.Double") || string.equalsIgnoreCase("java.sql.Date") || string.equalsIgnoreCase("java.sql.Time") || string.equalsIgnoreCase("java.sql.Timestamp")) {
                        this.setChar(n2, n3, 0, object.toString());
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case 2: {
                    if (string.equalsIgnoreCase("java.lang.Integer") || string.equalsIgnoreCase("java.lang.Long") || string.equalsIgnoreCase("java.lang.Short")) {
                        BigDecimal bigDecimal = new BigDecimal(new BigInteger(object.toString()), 0);
                        BigDecimal bigDecimal2 = bigDecimal.movePointRight(n4);
                        BigDecimal bigDecimal3 = bigDecimal2.movePointLeft(n4);
                        this.setBigDecimal(n2, bigDecimal3);
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Float") || string.equalsIgnoreCase("java.lang.Double") || string.equalsIgnoreCase("java.lang.String") || string.equalsIgnoreCase("java.math.BigDecimal")) {
                        this.setBigDecimal(n2, new BigDecimal(object.toString()));
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Boolean")) {
                        this.setBigDecimal(n2, new BigDecimal(bigInteger.toString()));
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case 3: {
                    if (string.equalsIgnoreCase("java.lang.Integer") || string.equalsIgnoreCase("java.lang.Long") || string.equalsIgnoreCase("java.lang.Short")) {
                        BigDecimal bigDecimal = new BigDecimal(new BigInteger(object.toString()), 0);
                        BigDecimal bigDecimal4 = bigDecimal.movePointRight(n4);
                        BigDecimal bigDecimal5 = bigDecimal4.movePointLeft(n4);
                        this.setDecimal(n2, bigDecimal5);
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Float") || string.equalsIgnoreCase("java.lang.Double") || string.equalsIgnoreCase("java.lang.String") || string.equalsIgnoreCase("java.math.BigDecimal")) {
                        this.setDecimal(n2, new BigDecimal(object.toString()));
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Boolean")) {
                        this.setDecimal(n2, new BigDecimal(bigInteger.toString()));
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case -7: {
                    if (string.equalsIgnoreCase("java.lang.String") || string.equalsIgnoreCase("java.lang.Boolean")) {
                        if (object.toString().equalsIgnoreCase("true")) {
                            this.setBoolean(n2, true);
                            break;
                        }
                        this.setBoolean(n2, false);
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Integer") || string.equalsIgnoreCase("java.lang.Long") || string.equalsIgnoreCase("java.lang.Short") || string.equalsIgnoreCase("java.math.BigDecimal")) {
                        if (object.toString().equalsIgnoreCase("1")) {
                            this.setBoolean(n2, true);
                            break;
                        }
                        this.setBoolean(n2, false);
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Float")) {
                        if (new Float(0.0f).compareTo(object) == 0) {
                            this.setBoolean(n2, false);
                            break;
                        }
                        this.setBoolean(n2, true);
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Double")) {
                        if (new Double(0.0).compareTo(object) == 0) {
                            this.setBoolean(n2, false);
                            break;
                        }
                        this.setBoolean(n2, true);
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case -6: {
                    if (string.equalsIgnoreCase("java.lang.Float")) {
                        this.setByte(n2, new Float(object.toString()).byteValue());
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Double")) {
                        this.setByte(n2, new Double(object.toString()).byteValue());
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Boolean")) {
                        this.setByte(n2, (byte)n5);
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.String") || string.equalsIgnoreCase("java.lang.Integer") || string.equalsIgnoreCase("java.lang.Short") || string.equalsIgnoreCase("java.lang.Long") || string.equalsIgnoreCase("java.math.BigDecimal")) {
                        this.setByte(n2, new Byte(object.toString()));
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case 5: {
                    if (string.equalsIgnoreCase("java.lang.Float")) {
                        this.setShort(n2, new Float(object.toString()).shortValue());
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Double")) {
                        this.setShort(n2, new Double(object.toString()).shortValue());
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Boolean")) {
                        this.setShort(n2, (short)n5);
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.String") || string.equalsIgnoreCase("java.lang.Integer") || string.equalsIgnoreCase("java.lang.Short") || string.equalsIgnoreCase("java.lang.Long") || string.equalsIgnoreCase("java.math.BigDecimal")) {
                        this.setShort(n2, new Short(object.toString()));
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case 4: {
                    if (string.equalsIgnoreCase("java.lang.Float")) {
                        this.setInt(n2, new Float(object.toString()).intValue());
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Double")) {
                        this.setInt(n2, new Double(object.toString()).intValue());
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Boolean")) {
                        this.setInt(n2, n5);
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.String") || string.equalsIgnoreCase("java.lang.Integer") || string.equalsIgnoreCase("java.lang.Short") || string.equalsIgnoreCase("java.lang.Long") || string.equalsIgnoreCase("java.math.BigDecimal")) {
                        this.setInt(n2, new Integer(object.toString()));
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case -5: {
                    if (string.equalsIgnoreCase("java.lang.Float")) {
                        this.setLong(n2, new Float(object.toString()).longValue());
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Double")) {
                        this.setLong(n2, new Double(object.toString()).longValue());
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Boolean")) {
                        this.setLong(n2, n5);
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.String") || string.equalsIgnoreCase("java.lang.Integer") || string.equalsIgnoreCase("java.lang.Short") || string.equalsIgnoreCase("java.lang.Long") || string.equalsIgnoreCase("java.math.BigDecimal")) {
                        this.setLong(n2, new Long(object.toString()));
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case 6: 
                case 7: 
                case 8: {
                    if (string.equalsIgnoreCase("java.lang.Boolean")) {
                        this.setDouble(n2, n5);
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.String") || string.equalsIgnoreCase("java.lang.Integer") || string.equalsIgnoreCase("java.lang.Short") || string.equalsIgnoreCase("java.lang.Long") || string.equalsIgnoreCase("java.math.BigDecimal") || string.equalsIgnoreCase("java.lang.Float") || string.equalsIgnoreCase("java.lang.Double")) {
                        this.setDouble(n2, new Double(object.toString()));
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case -2: {
                    if (string.equalsIgnoreCase("java.lang.String")) {
                        this.setBytes(n2, ((String)object).getBytes());
                        break;
                    }
                    if (string.equalsIgnoreCase("byte[]")) {
                        this.setBytes(n2, (byte[])object);
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case -4: 
                case -3: {
                    byte[] byArray = null;
                    if (string.equalsIgnoreCase("java.lang.String")) {
                        byArray = ((String)object).getBytes();
                    } else if (string.equalsIgnoreCase("byte[]")) {
                        byArray = (byte[])object;
                    } else {
                        throw new SQLException("Conversion not supported by setObject!!");
                    }
                    if (byArray.length > 8000) {
                        this.setBinaryStream(n2, new ByteArrayInputStream(byArray), byArray.length);
                        break;
                    }
                    this.setBinary(n2, n3, byArray);
                    break;
                }
                case 91: {
                    if (string.equalsIgnoreCase("java.lang.String")) {
                        this.setDate(n2, Date.valueOf(object.toString()));
                        break;
                    }
                    if (string.equalsIgnoreCase("java.sql.Timestamp")) {
                        this.setDate(n2, new Date(Timestamp.valueOf(object.toString()).getTime()));
                        break;
                    }
                    if (string.equalsIgnoreCase("java.sql.Date")) {
                        this.setDate(n2, (Date)object);
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case 92: {
                    if (string.equalsIgnoreCase("java.lang.String")) {
                        this.setTime(n2, Time.valueOf(object.toString()));
                        break;
                    }
                    if (string.equalsIgnoreCase("java.sql.Timestamp")) {
                        this.setTime(n2, new Time(Timestamp.valueOf(object.toString()).getTime()));
                        break;
                    }
                    if (string.equalsIgnoreCase("java.sql.Time")) {
                        this.setTime(n2, (Time)object);
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case 93: {
                    if (string.equalsIgnoreCase("java.lang.String")) {
                        this.setTimestamp(n2, Timestamp.valueOf(object.toString()));
                        break;
                    }
                    if (string.equalsIgnoreCase("java.sql.Date")) {
                        this.setTimestamp(n2, new Timestamp(Date.valueOf(object.toString()).getTime()));
                        break;
                    }
                    if (string.equalsIgnoreCase("java.sql.Timestamp")) {
                        this.setTimestamp(n2, (Timestamp)object);
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                default: {
                    throw new SQLException("Unknown SQL Type for PreparedStatement.setObject (SQL Type=" + n3);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new SQLException("SQL Exception : " + sQLException.getMessage());
        }
        catch (Exception exception) {
            throw new SQLException("Unexpected exception : " + exception.getMessage());
        }
    }

    protected int getTypeFromObjectArray(Object[] objectArray) {
        int n2 = 1111;
        for (int i2 = 0; i2 < this.batchSize && (n2 = JdbcOdbcPreparedStatement.getTypeFromObject(objectArray[i2])) == 0; ++i2) {
        }
        return n2;
    }

    protected void setPrecisionScaleArgs(Object[] objectArray, int[] nArray) {
        int n2 = this.getTypeFromObjectArray(objectArray);
        for (int i2 = 0; i2 < this.batchSize; ++i2) {
            byte[] byArray = null;
            String string = null;
            BigDecimal bigDecimal = null;
            int n3 = 0;
            try {
                if (n2 == 3 || n2 == 2) {
                    if (objectArray[i2] != null) {
                        int n4 = 0;
                        bigDecimal = (BigDecimal)objectArray[i2];
                        string = bigDecimal.toString();
                        n3 = string.indexOf(46);
                        if (n3 == -1) {
                            n3 = string.length();
                        } else {
                            n4 = bigDecimal.scale();
                            n3 += n4 + 1;
                        }
                        if (n4 > this.arrayScale) {
                            this.arrayScale = n4;
                        }
                    }
                } else if (n2 == 1 || n2 == 12) {
                    if (objectArray[i2] != null) {
                        string = (String)objectArray[i2];
                        n3 = string.length();
                    }
                } else if (n2 == -4) {
                    if (nArray[i2] > this.arrayDef) {
                        this.arrayDef = nArray[i2];
                    }
                } else if ((n2 == -2 || n2 == -3) && objectArray[i2] != null) {
                    byArray = (byte[])objectArray[i2];
                    n3 = byArray.length;
                }
                if (n3 <= this.arrayDef) continue;
                this.arrayDef = n3;
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void setChar(int n2, int n3, int n4, String string) throws SQLException {
        this.clearParameter(n2);
        this.setInputParameter(n2, true);
        int n5 = 0;
        boolean bl2 = false;
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[]{};
        try {
            byArray = this.CharsToBytes(this.OdbcApi.charSet, cArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byte[] byArray2 = this.allocBindBuf(n2, byArray.length);
        n5 = this.getPrecision(n3);
        if (n5 < 0 || n5 > 8000) {
            n5 = byArray.length;
        }
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterString(this.hStmt, n2, n3, n5, n4, byArray, byArray2, lArray);
        }
        this.boundParams[n2 - 1].pA1 = lArray[0];
        this.boundParams[n2 - 1].pA2 = lArray[1];
        this.boundParams[n2 - 1].pB1 = lArray[2];
        this.boundParams[n2 - 1].pB2 = lArray[3];
        this.boundParams[n2 - 1].scale = n4;
        this.boundParams[n2 - 1].boundType = n3;
        this.boundParams[n2 - 1].boundValue = string;
        if (n3 == 2 || n3 == 3) {
            this.arrayParams.storeValue(n2 - 1, new BigDecimal(string.trim()), -3);
            this.NumberDef = n5;
            if (n4 > this.NumberScale) {
                this.NumberScale = n4;
            }
        } else if (n3 == -5) {
            this.arrayParams.storeValue(n2 - 1, new BigInteger(string.trim()), -3);
            this.NumberDef = n5;
            if (n4 > this.NumberScale) {
                this.NumberScale = n4;
            }
        } else {
            this.arrayParams.storeValue(n2 - 1, string, -3);
            this.StringDef = n5;
        }
        this.setSqlType(n2, n3);
    }

    public void setNull(int n2, int n3, String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setString(int n2, String string) throws SQLException {
        if (string == null) {
            this.setNull(n2, 1);
        } else if (string.length() >= 254) {
            this.setChar(n2, -1, 0, string);
        } else {
            this.setChar(n2, 1, 0, string);
        }
    }

    public int executeUpdate(String string) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*PreparedStatement.executeUpdate (" + string + ")");
        }
        throw new SQLException("Driver does not support this function", "IM001");
    }

    public void addBatch(String string) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*PreparedStatement.addBatch (" + string + ")");
        }
        throw new SQLException("Driver does not support this function", "IM001");
    }

    public void setSql(String string) {
        this.mySql = string.toUpperCase();
    }

    public boolean execute(String string) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*PreparedStatement.execute (" + string + ")");
        }
        throw new SQLException("Driver does not support this function", "IM001");
    }

    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.clearParameter(n2);
        if (bigDecimal == null) {
            this.setNull(n2, 2);
        } else {
            this.setChar(n2, 2, bigDecimal.scale(), bigDecimal.toString());
        }
        this.boundParams[n2 - 1].boundType = 2;
        this.boundParams[n2 - 1].boundValue = bigDecimal;
    }

    public void setDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.clearParameter(n2);
        if (bigDecimal == null) {
            this.setNull(n2, 3);
        } else {
            this.setChar(n2, 3, bigDecimal.scale(), bigDecimal.toString());
        }
        this.boundParams[n2 - 1].boundType = 3;
        this.boundParams[n2 - 1].boundValue = bigDecimal;
    }

    public void setURL(int n2, URL uRL) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setArray(int n2, Array array) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setBlob(int n2, Blob blob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setClob(int n2, Clob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setDate(int n2, Date date) throws SQLException {
        if (date == null) {
            this.setNull(n2, 91);
            return;
        }
        this.clearParameter(n2);
        this.setInputParameter(n2, true);
        byte[] byArray = this.allocBindBuf(n2, 32);
        long[] lArray = new long[]{0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterDate(this.hStmt, n2, date, byArray, lArray);
        }
        this.boundParams[n2 - 1].pA1 = lArray[0];
        this.boundParams[n2 - 1].pA2 = lArray[1];
        this.boundParams[n2 - 1].boundType = 91;
        this.boundParams[n2 - 1].boundValue = date;
        this.arrayParams.storeValue(n2 - 1, date, -3);
        this.setSqlType(n2, 91);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setRef(int n2, Ref ref) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*PreparedStatement.executeQuery");
        }
        ResultSet resultSet = null;
        if (!this.execute()) {
            throw new SQLException("No ResultSet was produced");
        }
        resultSet = this.getResultSet(false);
        return resultSet;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*PreparedStatement.getMetaData");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        if (this.hStmt == 0L) {
            throw new SQLException("Statement is closed");
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, this.hStmt, true, null);
        return new JdbcOdbcResultSetMetaData(this.OdbcApi, jdbcOdbcResultSet);
    }

    public void setTime(int n2, Time time) throws SQLException {
        if (time == null) {
            this.setNull(n2, 92);
            return;
        }
        this.clearParameter(n2);
        this.setInputParameter(n2, true);
        byte[] byArray = this.allocBindBuf(n2, 32);
        long[] lArray = new long[]{0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterTime(this.hStmt, n2, time, byArray, lArray);
        }
        this.boundParams[n2 - 1].pA1 = lArray[0];
        this.boundParams[n2 - 1].pA2 = lArray[1];
        this.boundParams[n2 - 1].boundType = 92;
        this.boundParams[n2 - 1].boundValue = time;
        this.arrayParams.storeValue(n2 - 1, time, -3);
        this.setSqlType(n2, 92);
    }

    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.setNull(n2, 93);
            return;
        }
        this.clearParameter(n2);
        this.setInputParameter(n2, true);
        byte[] byArray = this.allocBindBuf(n2, 32);
        long[] lArray = new long[]{0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterTimestamp(this.hStmt, n2, timestamp, byArray, lArray);
        }
        this.boundParams[n2 - 1].pA1 = lArray[0];
        this.boundParams[n2 - 1].pA2 = lArray[1];
        this.boundParams[n2 - 1].boundValue = timestamp;
        this.boundParams[n2 - 1].boundType = 93;
        this.arrayParams.storeValue(n2 - 1, timestamp, -3);
        this.setSqlType(n2, 93);
    }

    public JdbcOdbcPreparedStatement(JdbcOdbcConnectionInterface jdbcOdbcConnectionInterface) {
        super(jdbcOdbcConnectionInterface);
    }

    public ResultSet executeQuery(String string) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*PreparedStatement.executeQuery (" + string + ")");
        }
        throw new SQLException("Driver does not support this function", "IM001");
    }

    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        if (date == null) {
            this.setNull(n2, 91);
            return;
        }
        long l2 = this.utils.convertToGMT(date, calendar);
        date = new Date(l2);
        calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.clearParameter(n2);
        this.setInputParameter(n2, true);
        byte[] byArray = this.allocBindBuf(n2, 32);
        long[] lArray = new long[]{0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterCalendarDate(this.hStmt, n2, calendar, byArray, lArray);
        }
        this.boundParams[n2 - 1].pA1 = lArray[0];
        this.boundParams[n2 - 1].pA2 = lArray[1];
        this.boundParams[n2 - 1].boundType = 91;
        this.boundParams[n2 - 1].boundValue = date;
        this.arrayParams.storeValue(n2 - 1, calendar, -3);
        this.setSqlType(n2, 91);
    }

    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        if (time == null) {
            this.setNull(n2, 92);
            return;
        }
        long l2 = this.utils.convertToGMT(time, calendar);
        time = new Time(l2);
        calendar = Calendar.getInstance();
        calendar.setTime(time);
        this.clearParameter(n2);
        this.setInputParameter(n2, true);
        byte[] byArray = this.allocBindBuf(n2, 32);
        long[] lArray = new long[]{0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterCalendarTime(this.hStmt, n2, calendar, byArray, lArray);
        }
        this.boundParams[n2 - 1].pA1 = lArray[0];
        this.boundParams[n2 - 1].pA2 = lArray[1];
        this.boundParams[n2 - 1].boundType = 92;
        this.boundParams[n2 - 1].boundValue = time;
        this.arrayParams.storeValue(n2 - 1, calendar, -3);
        this.setSqlType(n2, 92);
    }

    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (timestamp == null) {
            this.setNull(n2, 93);
            return;
        }
        long l2 = this.utils.convertToGMT(timestamp, calendar);
        timestamp = new Timestamp(l2);
        calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        this.clearParameter(n2);
        this.setInputParameter(n2, true);
        byte[] byArray = this.allocBindBuf(n2, 32);
        long[] lArray = new long[]{0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterCalendarTimestamp(this.hStmt, n2, calendar, byArray, lArray);
        }
        this.boundParams[n2 - 1].pA1 = lArray[0];
        this.boundParams[n2 - 1].pA2 = lArray[1];
        this.boundParams[n2 - 1].boundType = 93;
        this.boundParams[n2 - 1].boundValue = timestamp;
        this.arrayParams.storeValue(n2 - 1, calendar, -3);
        this.setSqlType(n2, 93);
    }

    public void initialize(JdbcOdbc jdbcOdbc, long l2, long l3, Hashtable hashtable, int n2, int n3) throws SQLException {
        super.initialize(jdbcOdbc, l2, l3, hashtable, n2, n3);
    }
}

