/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyEventPostProcessor;
import java.awt.Window;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;
import javax.swing.plaf.basic.ComboPopup;

public class WindowsRootPaneUI
extends BasicRootPaneUI {
    private static final WindowsRootPaneUI windowsRootPaneUI = new WindowsRootPaneUI();
    static final AltProcessor altProcessor = new AltProcessor();

    public static ComponentUI createUI(JComponent jComponent) {
        return windowsRootPaneUI;
    }

    static class AltProcessor
    implements KeyEventPostProcessor {
        static boolean altKeyPressed = false;
        static boolean menuCanceledOnPress = false;
        static JRootPane root = null;
        static Window winAncestor = null;

        AltProcessor() {
        }

        void repaintMnemonicsInComponents(Component[] componentArray) {
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                if (componentArray[i2] instanceof AbstractButton && ((AbstractButton)componentArray[i2]).getMnemonic() != 0) {
                    componentArray[i2].repaint();
                    continue;
                }
                if (!(componentArray[i2] instanceof Container)) continue;
                this.repaintMnemonicsInComponents(((Container)componentArray[i2]).getComponents());
            }
        }

        void repaintMnemonicsInWindow(Window window) {
            if (window == null || !window.isShowing()) {
                return;
            }
            Window[] windowArray = window.getOwnedWindows();
            for (int i2 = 0; i2 < windowArray.length; ++i2) {
                this.repaintMnemonicsInWindow(windowArray[i2]);
            }
            this.repaintMnemonicsInComponents(window.getComponents());
        }

        void altPressed(KeyEvent keyEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length > 0 && !(menuElementArray[0] instanceof ComboPopup)) {
                menuSelectionManager.clearSelectedPath();
                menuCanceledOnPress = true;
                keyEvent.consume();
            } else if (menuElementArray.length > 0) {
                menuCanceledOnPress = false;
                WindowsLookAndFeel.setMnemonicHidden(false);
                this.repaintMnemonicsInWindow(winAncestor);
                keyEvent.consume();
            } else {
                JMenu jMenu;
                JMenuBar jMenuBar;
                menuCanceledOnPress = false;
                WindowsLookAndFeel.setMnemonicHidden(false);
                this.repaintMnemonicsInWindow(winAncestor);
                JMenuBar jMenuBar2 = jMenuBar = root != null ? root.getJMenuBar() : null;
                if (jMenuBar == null && winAncestor instanceof JFrame) {
                    jMenuBar = ((JFrame)winAncestor).getJMenuBar();
                }
                JMenu jMenu2 = jMenu = jMenuBar != null ? jMenuBar.getMenu(0) : null;
                if (jMenu != null) {
                    keyEvent.consume();
                }
            }
        }

        void altReleased(KeyEvent keyEvent) {
            if (menuCanceledOnPress) {
                WindowsLookAndFeel.setMnemonicHidden(true);
                this.repaintMnemonicsInWindow(winAncestor);
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (menuSelectionManager.getSelectedPath().length == 0) {
                JMenu jMenu;
                JMenuBar jMenuBar;
                JMenuBar jMenuBar2 = jMenuBar = root != null ? root.getJMenuBar() : null;
                if (jMenuBar == null && winAncestor instanceof JFrame) {
                    jMenuBar = ((JFrame)winAncestor).getJMenuBar();
                }
                JMenu jMenu2 = jMenu = jMenuBar != null ? jMenuBar.getMenu(0) : null;
                if (jMenu != null) {
                    MenuElement[] menuElementArray = new MenuElement[]{jMenuBar, jMenu};
                    menuSelectionManager.setSelectedPath(menuElementArray);
                } else if (!WindowsLookAndFeel.isMnemonicHidden()) {
                    WindowsLookAndFeel.setMnemonicHidden(true);
                    this.repaintMnemonicsInWindow(winAncestor);
                }
            } else if (menuSelectionManager.getSelectedPath()[0] instanceof ComboPopup) {
                WindowsLookAndFeel.setMnemonicHidden(true);
                this.repaintMnemonicsInWindow(winAncestor);
            }
        }

        public boolean postProcessKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 18) {
                root = SwingUtilities.getRootPane(keyEvent.getComponent());
                winAncestor = SwingUtilities.getWindowAncestor(root);
                if (keyEvent.getID() == 401) {
                    if (!altKeyPressed) {
                        this.altPressed(keyEvent);
                    }
                    altKeyPressed = true;
                    return true;
                }
                if (keyEvent.getID() == 402) {
                    if (altKeyPressed) {
                        this.altReleased(keyEvent);
                    } else {
                        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                        if (menuElementArray.length <= 0) {
                            WindowsLookAndFeel.setMnemonicHidden(true);
                            this.repaintMnemonicsInWindow(winAncestor);
                        }
                    }
                    altKeyPressed = false;
                }
            } else {
                altKeyPressed = false;
            }
            return false;
        }
    }
}

