/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import sun.awt.color.ICC_Transform;
import sun.awt.color.ProfileDeferralMgr;

public class ColorConvertOp
implements BufferedImageOp,
RasterOp {
    ICC_Profile[] profileList;
    ColorSpace[] CSList;
    ICC_Transform thisTransform;
    ICC_Transform thisRasterTransform;
    ICC_Profile thisSrcProfile;
    ICC_Profile thisDestProfile;
    RenderingHints hints;
    boolean gotProfiles;
    float[] srcMinVals;
    float[] srcMaxVals;
    float[] dstMinVals;
    float[] dstMaxVals;

    static {
        if (ProfileDeferralMgr.deferring) {
            ProfileDeferralMgr.activateProfiles();
        }
    }

    private void setMinMax(int n2, int n3, float[] fArray, float[] fArray2) {
        if (n2 == 1) {
            fArray[0] = 0.0f;
            fArray2[0] = 100.0f;
            fArray[1] = -128.0f;
            fArray2[1] = 127.0f;
            fArray[2] = -128.0f;
            fArray2[2] = 127.0f;
        } else if (n2 == 0) {
            fArray[2] = 0.0f;
            fArray[1] = 0.0f;
            fArray[0] = 0.0f;
            fArray2[2] = 1.9999695f;
            fArray2[1] = 1.9999695f;
            fArray2[0] = 1.9999695f;
        } else {
            for (int i2 = 0; i2 < n3; ++i2) {
                fArray[i2] = 0.0f;
                fArray2[i2] = 1.0f;
            }
        }
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public ColorConvertOp(RenderingHints renderingHints) {
        this.profileList = new ICC_Profile[0];
        this.hints = renderingHints;
    }

    public final ICC_Profile[] getICC_Profiles() {
        if (this.gotProfiles) {
            ICC_Profile[] iCC_ProfileArray = new ICC_Profile[this.profileList.length];
            for (int i2 = 0; i2 < this.profileList.length; ++i2) {
                iCC_ProfileArray[i2] = this.profileList[i2];
            }
            return iCC_ProfileArray;
        }
        return null;
    }

    private int getRenderingIntent(ICC_Profile iCC_Profile) {
        byte[] byArray = iCC_Profile.getData(1751474532);
        int n2 = 64;
        return (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    public ColorConvertOp(ColorSpace colorSpace, RenderingHints renderingHints) {
        if (colorSpace == null) {
            throw new NullPointerException("ColorSpace cannot be null");
        }
        if (colorSpace instanceof ICC_ColorSpace) {
            this.profileList = new ICC_Profile[1];
            this.profileList[0] = ((ICC_ColorSpace)colorSpace).getProfile();
        } else {
            this.CSList = new ColorSpace[1];
            this.CSList[0] = colorSpace;
        }
        this.hints = renderingHints;
    }

    public ColorConvertOp(ICC_Profile[] iCC_ProfileArray, RenderingHints renderingHints) {
        if (iCC_ProfileArray == null) {
            throw new NullPointerException("Profiles cannot be null");
        }
        this.gotProfiles = true;
        this.profileList = new ICC_Profile[iCC_ProfileArray.length];
        for (int i2 = 0; i2 < iCC_ProfileArray.length; ++i2) {
            this.profileList[i2] = iCC_ProfileArray[i2];
        }
        this.hints = renderingHints;
    }

    private void getMinMaxValsFromColorSpaces(ColorSpace colorSpace, ColorSpace colorSpace2) {
        int n2;
        int n3 = colorSpace.getNumComponents();
        this.srcMinVals = new float[n3];
        this.srcMaxVals = new float[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.srcMinVals[n2] = colorSpace.getMinValue(n2);
            this.srcMaxVals[n2] = colorSpace.getMaxValue(n2);
        }
        n3 = colorSpace2.getNumComponents();
        this.dstMinVals = new float[n3];
        this.dstMaxVals = new float[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.dstMinVals[n2] = colorSpace2.getMinValue(n2);
            this.dstMaxVals[n2] = colorSpace2.getMaxValue(n2);
        }
    }

    private void getMinMaxValsFromProfiles(ICC_Profile iCC_Profile, ICC_Profile iCC_Profile2) {
        int n2 = iCC_Profile.getColorSpaceType();
        int n3 = iCC_Profile.getNumComponents();
        this.srcMinVals = new float[n3];
        this.srcMaxVals = new float[n3];
        this.setMinMax(n2, n3, this.srcMinVals, this.srcMaxVals);
        n2 = iCC_Profile2.getColorSpaceType();
        n3 = iCC_Profile2.getNumComponents();
        this.dstMinVals = new float[n3];
        this.dstMaxVals = new float[n3];
        this.setMinMax(n2, n3, this.dstMinVals, this.dstMaxVals);
    }

    private void updateBITransform(ICC_Profile iCC_Profile, ICC_Profile iCC_Profile2) {
        int n2;
        int n3;
        boolean bl2 = false;
        boolean bl3 = false;
        int n4 = n3 = this.profileList.length;
        if (n3 == 0 || iCC_Profile != this.profileList[0]) {
            ++n4;
            bl2 = true;
        }
        if (n3 == 0 || iCC_Profile2 != this.profileList[n3 - 1] || n4 < 2) {
            ++n4;
            bl3 = true;
        }
        ICC_Profile[] iCC_ProfileArray = new ICC_Profile[n4];
        int n5 = 0;
        if (bl2) {
            iCC_ProfileArray[n5++] = iCC_Profile;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            iCC_ProfileArray[n5++] = this.profileList[n2];
        }
        if (bl3) {
            iCC_ProfileArray[n5] = iCC_Profile2;
        }
        ICC_Transform[] iCC_TransformArray = new ICC_Transform[n4];
        int n6 = iCC_ProfileArray[0].getProfileClass() == 2 ? 1 : 0;
        int n7 = 1;
        for (n2 = 0; n2 < n4; ++n2) {
            if (n2 == n4 - 1) {
                n7 = 2;
            } else if (n7 == 4 && iCC_ProfileArray[n2].getProfileClass() == 5) {
                n6 = 0;
                n7 = 1;
            }
            iCC_TransformArray[n2] = new ICC_Transform(iCC_ProfileArray[n2], n6, n7);
            n6 = this.getRenderingIntent(iCC_ProfileArray[n2]);
            n7 = 4;
        }
        this.thisTransform = new ICC_Transform(iCC_TransformArray);
        this.thisSrcProfile = iCC_Profile;
        this.thisDestProfile = iCC_Profile2;
    }

    public final Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return this.getBounds2D(bufferedImage.getRaster());
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        return raster.getBounds();
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        int n2;
        if (this.CSList != null) {
            if (this.CSList.length != 2) {
                throw new IllegalArgumentException("Destination ColorSpace is undefined");
            }
            n2 = this.CSList[1].getNumComponents();
        } else {
            int n3 = this.profileList.length;
            if (n3 < 2) {
                throw new IllegalArgumentException("Destination ColorSpace is undefined");
            }
            n2 = this.profileList[n3 - 1].getNumComponents();
        }
        WritableRaster writableRaster = Raster.createInterleavedRaster(0, raster.getWidth(), raster.getHeight(), n2, new Point(raster.getMinX(), raster.getMinY()));
        return writableRaster;
    }

    public ColorConvertOp(ColorSpace colorSpace, ColorSpace colorSpace2, RenderingHints renderingHints) {
        if (colorSpace == null || colorSpace2 == null) {
            throw new NullPointerException("ColorSpaces cannot be null");
        }
        if (colorSpace instanceof ICC_ColorSpace && colorSpace2 instanceof ICC_ColorSpace) {
            this.profileList = new ICC_Profile[2];
            this.profileList[0] = ((ICC_ColorSpace)colorSpace).getProfile();
            this.profileList[1] = ((ICC_ColorSpace)colorSpace2).getProfile();
            this.getMinMaxValsFromColorSpaces(colorSpace, colorSpace2);
        } else {
            this.CSList = new ColorSpace[2];
            this.CSList[0] = colorSpace;
            this.CSList[1] = colorSpace2;
        }
        this.hints = renderingHints;
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Float();
        }
        point2D2.setLocation(point2D.getX(), point2D.getY());
        return point2D2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        ColorSpace colorSpace;
        Object object;
        BufferedImage bufferedImage3 = null;
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            object = (IndexColorModel)bufferedImage.getColorModel();
            bufferedImage = ((IndexColorModel)object).convertToIntDiscrete(bufferedImage.getRaster(), true);
        }
        ColorSpace colorSpace2 = bufferedImage.getColorModel().getColorSpace();
        if (bufferedImage2 != null) {
            if (bufferedImage2.getColorModel() instanceof IndexColorModel) {
                bufferedImage3 = bufferedImage2;
                bufferedImage2 = null;
                colorSpace = null;
            } else {
                colorSpace = bufferedImage2.getColorModel().getColorSpace();
            }
        } else {
            colorSpace = null;
        }
        bufferedImage2 = this.CSList != null || !(colorSpace2 instanceof ICC_ColorSpace) || bufferedImage2 != null && !(colorSpace instanceof ICC_ColorSpace) ? this.nonICCBIFilter(bufferedImage, colorSpace2, bufferedImage2, colorSpace) : this.ICCBIFilter(bufferedImage, colorSpace2, bufferedImage2, colorSpace);
        if (bufferedImage3 != null) {
            object = bufferedImage3.createGraphics();
            try {
                ((Graphics)object).drawImage(bufferedImage2, 0, 0, null);
            }
            finally {
                ((Graphics)object).dispose();
            }
            return bufferedImage3;
        }
        return bufferedImage2;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        ColorSpace colorSpace = null;
        if (colorModel == null) {
            if (this.CSList == null) {
                int n2 = this.profileList.length;
                if (n2 == 0) {
                    throw new IllegalArgumentException("Destination ColorSpace is undefined");
                }
                ICC_Profile iCC_Profile = this.profileList[n2 - 1];
                colorSpace = new ICC_ColorSpace(iCC_Profile);
            } else {
                int n3 = this.CSList.length;
                colorSpace = this.CSList[n3 - 1];
            }
        }
        return this.createCompatibleDestImage(bufferedImage, colorModel, colorSpace);
    }

    public final WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        int n2;
        int n3;
        if (this.CSList != null) {
            return this.nonICCRasterFilter(raster, writableRaster);
        }
        int n4 = this.profileList.length;
        if (n4 < 2) {
            throw new IllegalArgumentException("Source or Destination ColorSpace is undefined");
        }
        if (raster.getNumBands() != this.profileList[0].getNumComponents()) {
            throw new IllegalArgumentException("Numbers of source Raster bands and source color space components do not match");
        }
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        } else {
            if (raster.getHeight() != writableRaster.getHeight() || raster.getWidth() != writableRaster.getWidth()) {
                throw new IllegalArgumentException("Width or height of Rasters do not match");
            }
            if (writableRaster.getNumBands() != this.profileList[n4 - 1].getNumComponents()) {
                throw new IllegalArgumentException("Numbers of destination Raster bands and destination color space components do not match");
            }
        }
        if (this.thisRasterTransform == null) {
            ICC_Transform[] iCC_TransformArray = new ICC_Transform[n4];
            int n5 = this.profileList[0].getProfileClass() == 2 ? 1 : 0;
            n3 = 1;
            for (n2 = 0; n2 < n4; ++n2) {
                if (n2 == n4 - 1) {
                    n3 = 2;
                } else if (n3 == 4 && this.profileList[n2].getProfileClass() == 5) {
                    n5 = 0;
                    n3 = 1;
                }
                iCC_TransformArray[n2] = new ICC_Transform(this.profileList[n2], n5, n3);
                n5 = this.getRenderingIntent(this.profileList[n2]);
                n3 = 4;
            }
            this.thisRasterTransform = new ICC_Transform(iCC_TransformArray);
        }
        n2 = raster.getTransferType();
        n3 = writableRaster.getTransferType();
        if (n2 == 4 || n2 == 5 || n3 == 4 || n3 == 5) {
            if (this.srcMinVals == null) {
                this.getMinMaxValsFromProfiles(this.profileList[0], this.profileList[n4 - 1]);
            }
            this.thisRasterTransform.colorConvert(raster, writableRaster, this.srcMinVals, this.srcMaxVals, this.dstMinVals, this.dstMaxVals);
        } else {
            this.thisRasterTransform.colorConvert(raster, writableRaster);
        }
        return writableRaster;
    }

    private final WritableRaster nonICCRasterFilter(Raster raster, WritableRaster writableRaster) {
        int n2;
        if (this.CSList.length != 2) {
            throw new IllegalArgumentException("Destination ColorSpace is undefined");
        }
        if (raster.getNumBands() != this.CSList[0].getNumComponents()) {
            throw new IllegalArgumentException("Numbers of source Raster bands and source color space components do not match");
        }
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        } else {
            if (raster.getHeight() != writableRaster.getHeight() || raster.getWidth() != writableRaster.getWidth()) {
                throw new IllegalArgumentException("Width or height of Rasters do not match");
            }
            if (writableRaster.getNumBands() != this.CSList[1].getNumComponents()) {
                throw new IllegalArgumentException("Numbers of destination Raster bands and destination color space components do not match");
            }
        }
        if (this.srcMinVals == null) {
            this.getMinMaxValsFromColorSpaces(this.CSList[0], this.CSList[1]);
        }
        SampleModel sampleModel = raster.getSampleModel();
        SampleModel sampleModel2 = writableRaster.getSampleModel();
        int n3 = raster.getTransferType();
        int n4 = writableRaster.getTransferType();
        boolean bl2 = n3 == 4 || n3 == 5;
        boolean bl3 = n4 == 4 || n4 == 5;
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        int n7 = raster.getNumBands();
        int n8 = writableRaster.getNumBands();
        float[] fArray = null;
        float[] fArray2 = null;
        if (!bl2) {
            fArray = new float[n7];
            for (n2 = 0; n2 < n7; ++n2) {
                fArray[n2] = n3 == 2 ? (this.srcMaxVals[n2] - this.srcMinVals[n2]) / 32767.0f : (this.srcMaxVals[n2] - this.srcMinVals[n2]) / (float)((1 << sampleModel.getSampleSize(n2)) - 1);
            }
        }
        if (!bl3) {
            fArray2 = new float[n8];
            for (n2 = 0; n2 < n8; ++n2) {
                fArray2[n2] = n4 == 2 ? 32767.0f / (this.dstMaxVals[n2] - this.dstMinVals[n2]) : (float)((1 << sampleModel2.getSampleSize(n2)) - 1) / (this.dstMaxVals[n2] - this.dstMinVals[n2]);
            }
        }
        n2 = raster.getMinY();
        int n9 = writableRaster.getMinY();
        float[] fArray3 = new float[n7];
        ColorSpace colorSpace = this.CSList[0];
        ColorSpace colorSpace2 = this.CSList[1];
        int n10 = 0;
        while (n10 < n6) {
            int n11 = raster.getMinX();
            int n12 = writableRaster.getMinX();
            int n13 = 0;
            while (n13 < n5) {
                float f2;
                int n14;
                for (n14 = 0; n14 < n7; ++n14) {
                    f2 = raster.getSampleFloat(n11, n2, n14);
                    if (!bl2) {
                        f2 = f2 * fArray[n14] + this.srcMinVals[n14];
                    }
                    fArray3[n14] = f2;
                }
                float[] fArray4 = colorSpace.toCIEXYZ(fArray3);
                fArray4 = colorSpace2.fromCIEXYZ(fArray4);
                for (n14 = 0; n14 < n8; ++n14) {
                    f2 = fArray4[n14];
                    if (!bl3) {
                        f2 = (f2 - this.dstMinVals[n14]) * fArray2[n14];
                    }
                    writableRaster.setSample(n12, n9, n14, f2);
                }
                ++n13;
                ++n11;
                ++n12;
            }
            ++n10;
            ++n2;
            ++n9;
        }
        return writableRaster;
    }

    private BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel, ColorSpace colorSpace) {
        int n2;
        if (colorModel == null) {
            ColorModel colorModel2 = bufferedImage.getColorModel();
            n2 = colorSpace.getNumComponents();
            boolean bl2 = colorModel2.hasAlpha();
            if (bl2) {
                ++n2;
            }
            int[] nArray = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = 8;
            }
            colorModel = new ComponentColorModel(colorSpace, nArray, bl2, colorModel2.isAlphaPremultiplied(), colorModel2.getTransparency(), 0);
        }
        int n3 = bufferedImage.getWidth();
        n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n3, n2), colorModel.isAlphaPremultiplied(), null);
        return bufferedImage2;
    }

    private final BufferedImage ICCBIFilter(BufferedImage bufferedImage, ColorSpace colorSpace, BufferedImage bufferedImage2, ColorSpace colorSpace2) {
        int n2 = this.profileList.length;
        ICC_Profile iCC_Profile = null;
        ICC_Profile iCC_Profile2 = null;
        iCC_Profile = ((ICC_ColorSpace)colorSpace).getProfile();
        if (bufferedImage2 == null) {
            if (n2 == 0) {
                throw new IllegalArgumentException("Destination ColorSpace is undefined");
            }
            iCC_Profile2 = this.profileList[n2 - 1];
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        } else {
            if (bufferedImage.getHeight() != bufferedImage2.getHeight() || bufferedImage.getWidth() != bufferedImage2.getWidth()) {
                throw new IllegalArgumentException("Width or height of BufferedImages do not match");
            }
            iCC_Profile2 = ((ICC_ColorSpace)colorSpace2).getProfile();
        }
        if (this.thisTransform == null || this.thisSrcProfile != iCC_Profile || this.thisDestProfile != iCC_Profile2) {
            this.updateBITransform(iCC_Profile, iCC_Profile2);
        }
        this.thisTransform.colorConvert(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    private final BufferedImage nonICCBIFilter(BufferedImage bufferedImage, ColorSpace colorSpace, BufferedImage bufferedImage2, ColorSpace colorSpace2) {
        boolean bl2;
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        ICC_ColorSpace iCC_ColorSpace = (ICC_ColorSpace)ColorSpace.getInstance(1001);
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            colorSpace2 = bufferedImage2.getColorModel().getColorSpace();
        } else if (n3 != bufferedImage2.getHeight() || n2 != bufferedImage2.getWidth()) {
            throw new IllegalArgumentException("Width or height of BufferedImages do not match");
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        ColorModel colorModel = bufferedImage.getColorModel();
        ColorModel colorModel2 = bufferedImage2.getColorModel();
        int n4 = colorModel.getNumColorComponents();
        int n5 = colorModel2.getNumColorComponents();
        boolean bl3 = colorModel2.hasAlpha();
        boolean bl4 = bl2 = colorModel.hasAlpha() && bl3;
        if (this.CSList == null && this.profileList.length != 0) {
            float[] fArray;
            int n6;
            int n7;
            int n8;
            ColorSpace colorSpace3;
            ICC_Profile iCC_Profile;
            boolean bl5;
            ICC_Profile iCC_Profile2;
            boolean bl6;
            if (!(colorSpace instanceof ICC_ColorSpace)) {
                bl6 = true;
                iCC_Profile2 = iCC_ColorSpace.getProfile();
            } else {
                bl6 = false;
                iCC_Profile2 = ((ICC_ColorSpace)colorSpace).getProfile();
            }
            if (!(colorSpace2 instanceof ICC_ColorSpace)) {
                bl5 = true;
                iCC_Profile = iCC_ColorSpace.getProfile();
            } else {
                bl5 = false;
                iCC_Profile = ((ICC_ColorSpace)colorSpace2).getProfile();
            }
            if (this.thisTransform == null || this.thisSrcProfile != iCC_Profile2 || this.thisDestProfile != iCC_Profile) {
                this.updateBITransform(iCC_Profile2, iCC_Profile);
            }
            float f2 = 65535.0f;
            if (bl6) {
                colorSpace3 = iCC_ColorSpace;
                n8 = 3;
            } else {
                colorSpace3 = colorSpace;
                n8 = n4;
            }
            float[] fArray2 = new float[n8];
            float[] fArray3 = new float[n8];
            for (n7 = 0; n7 < n4; ++n7) {
                fArray2[n7] = colorSpace3.getMinValue(n7);
                fArray3[n7] = f2 / (colorSpace3.getMaxValue(n7) - fArray2[n7]);
            }
            if (bl5) {
                colorSpace3 = iCC_ColorSpace;
                n7 = 3;
            } else {
                colorSpace3 = colorSpace2;
                n7 = n5;
            }
            float[] fArray4 = new float[n7];
            float[] fArray5 = new float[n7];
            for (int i2 = 0; i2 < n5; ++i2) {
                fArray4[i2] = colorSpace3.getMinValue(i2);
                fArray5[i2] = (colorSpace3.getMaxValue(i2) - fArray4[i2]) / f2;
            }
            if (bl3) {
                n6 = n5 + 1 > 3 ? n5 + 1 : 3;
                fArray = new float[n6];
            } else {
                n6 = n5 > 3 ? n5 : 3;
                fArray = new float[n6];
            }
            short[] sArray = new short[n2 * n8];
            short[] sArray2 = new short[n2 * n7];
            float[] fArray6 = null;
            if (bl2) {
                fArray6 = new float[n2];
            }
            for (int i3 = 0; i3 < n3; ++i3) {
                int n9;
                int n10;
                Object object = null;
                float[] fArray7 = null;
                int n11 = 0;
                for (n10 = 0; n10 < n2; ++n10) {
                    object = writableRaster.getDataElements(n10, i3, object);
                    fArray7 = colorModel.getNormalizedComponents(object, fArray7, 0);
                    if (bl2) {
                        fArray6[n10] = fArray7[n4];
                    }
                    if (bl6) {
                        fArray7 = colorSpace.toCIEXYZ(fArray7);
                    }
                    for (n9 = 0; n9 < n8; ++n9) {
                        sArray[n11++] = (short)((fArray7[n9] - fArray2[n9]) * fArray3[n9] + 0.5f);
                    }
                }
                this.thisTransform.colorConvert(sArray, sArray2);
                object = null;
                n11 = 0;
                for (n10 = 0; n10 < n2; ++n10) {
                    for (n9 = 0; n9 < n7; ++n9) {
                        fArray[n9] = (float)(sArray2[n11++] & 0xFFFF) * fArray5[n9] + fArray4[n9];
                    }
                    if (bl5) {
                        fArray7 = colorSpace.fromCIEXYZ(fArray);
                        for (n9 = 0; n9 < n5; ++n9) {
                            fArray[n9] = fArray7[n9];
                        }
                    }
                    if (bl2) {
                        fArray[n5] = fArray6[n10];
                    } else if (bl3) {
                        fArray[n5] = 1.0f;
                    }
                    object = colorModel2.getDataElements(fArray, 0, object);
                    writableRaster2.setDataElements(n10, i3, object);
                }
            }
        } else {
            int n12 = this.CSList == null ? 0 : this.CSList.length;
            float[] fArray = bl3 ? new float[n5 + 1] : new float[n5];
            Object object = null;
            Object object2 = null;
            float[] fArray8 = null;
            for (int i4 = 0; i4 < n3; ++i4) {
                for (int i5 = 0; i5 < n2; ++i5) {
                    int n13;
                    object = writableRaster.getDataElements(i5, i4, object);
                    fArray8 = colorModel.getNormalizedComponents(object, fArray8, 0);
                    float[] fArray9 = colorSpace.toCIEXYZ(fArray8);
                    for (n13 = 0; n13 < n12; ++n13) {
                        fArray9 = this.CSList[n13].fromCIEXYZ(fArray9);
                        fArray9 = this.CSList[n13].toCIEXYZ(fArray9);
                    }
                    fArray9 = colorSpace2.fromCIEXYZ(fArray9);
                    for (n13 = 0; n13 < n5; ++n13) {
                        fArray[n13] = fArray9[n13];
                    }
                    if (bl2) {
                        fArray[n5] = fArray8[n4];
                    } else if (bl3) {
                        fArray[n5] = 1.0f;
                    }
                    object2 = colorModel2.getDataElements(fArray, 0, object2);
                    writableRaster2.setDataElements(i5, i4, object2);
                }
            }
        }
        return bufferedImage2;
    }
}

